/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFlywheelIterationHistoryResponse extends ComprehendResponse implements
        ToCopyableBuilder<ListFlywheelIterationHistoryResponse.Builder, ListFlywheelIterationHistoryResponse> {
    private static final SdkField<List<FlywheelIterationProperties>> FLYWHEEL_ITERATION_PROPERTIES_LIST_FIELD = SdkField
            .<List<FlywheelIterationProperties>> builder(MarshallingType.LIST)
            .memberName("FlywheelIterationPropertiesList")
            .getter(getter(ListFlywheelIterationHistoryResponse::flywheelIterationPropertiesList))
            .setter(setter(Builder::flywheelIterationPropertiesList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlywheelIterationPropertiesList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FlywheelIterationProperties> builder(MarshallingType.SDK_POJO)
                                            .constructor(FlywheelIterationProperties::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFlywheelIterationHistoryResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FLYWHEEL_ITERATION_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<FlywheelIterationProperties> flywheelIterationPropertiesList;

    private final String nextToken;

    private ListFlywheelIterationHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.flywheelIterationPropertiesList = builder.flywheelIterationPropertiesList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the FlywheelIterationPropertiesList
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasFlywheelIterationPropertiesList() {
        return flywheelIterationPropertiesList != null && !(flywheelIterationPropertiesList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of flywheel iteration properties
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFlywheelIterationPropertiesList}
     * method.
     * </p>
     * 
     * @return List of flywheel iteration properties
     */
    public final List<FlywheelIterationProperties> flywheelIterationPropertiesList() {
        return flywheelIterationPropertiesList;
    }

    /**
     * <p>
     * Next token
     * </p>
     * 
     * @return Next token
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasFlywheelIterationPropertiesList() ? flywheelIterationPropertiesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFlywheelIterationHistoryResponse)) {
            return false;
        }
        ListFlywheelIterationHistoryResponse other = (ListFlywheelIterationHistoryResponse) obj;
        return hasFlywheelIterationPropertiesList() == other.hasFlywheelIterationPropertiesList()
                && Objects.equals(flywheelIterationPropertiesList(), other.flywheelIterationPropertiesList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListFlywheelIterationHistoryResponse")
                .add("FlywheelIterationPropertiesList",
                        hasFlywheelIterationPropertiesList() ? flywheelIterationPropertiesList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlywheelIterationPropertiesList":
            return Optional.ofNullable(clazz.cast(flywheelIterationPropertiesList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFlywheelIterationHistoryResponse, T> g) {
        return obj -> g.apply((ListFlywheelIterationHistoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFlywheelIterationHistoryResponse> {
        /**
         * <p>
         * List of flywheel iteration properties
         * </p>
         * 
         * @param flywheelIterationPropertiesList
         *        List of flywheel iteration properties
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flywheelIterationPropertiesList(Collection<FlywheelIterationProperties> flywheelIterationPropertiesList);

        /**
         * <p>
         * List of flywheel iteration properties
         * </p>
         * 
         * @param flywheelIterationPropertiesList
         *        List of flywheel iteration properties
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flywheelIterationPropertiesList(FlywheelIterationProperties... flywheelIterationPropertiesList);

        /**
         * <p>
         * List of flywheel iteration properties
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.comprehend.model.FlywheelIterationProperties.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.comprehend.model.FlywheelIterationProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.comprehend.model.FlywheelIterationProperties.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #flywheelIterationPropertiesList(List<FlywheelIterationProperties>)}.
         * 
         * @param flywheelIterationPropertiesList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.comprehend.model.FlywheelIterationProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flywheelIterationPropertiesList(java.util.Collection<FlywheelIterationProperties>)
         */
        Builder flywheelIterationPropertiesList(Consumer<FlywheelIterationProperties.Builder>... flywheelIterationPropertiesList);

        /**
         * <p>
         * Next token
         * </p>
         * 
         * @param nextToken
         *        Next token
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private List<FlywheelIterationProperties> flywheelIterationPropertiesList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFlywheelIterationHistoryResponse model) {
            super(model);
            flywheelIterationPropertiesList(model.flywheelIterationPropertiesList);
            nextToken(model.nextToken);
        }

        public final List<FlywheelIterationProperties.Builder> getFlywheelIterationPropertiesList() {
            List<FlywheelIterationProperties.Builder> result = FlywheelIterationPropertiesListCopier
                    .copyToBuilder(this.flywheelIterationPropertiesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFlywheelIterationPropertiesList(
                Collection<FlywheelIterationProperties.BuilderImpl> flywheelIterationPropertiesList) {
            this.flywheelIterationPropertiesList = FlywheelIterationPropertiesListCopier
                    .copyFromBuilder(flywheelIterationPropertiesList);
        }

        @Override
        public final Builder flywheelIterationPropertiesList(
                Collection<FlywheelIterationProperties> flywheelIterationPropertiesList) {
            this.flywheelIterationPropertiesList = FlywheelIterationPropertiesListCopier.copy(flywheelIterationPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flywheelIterationPropertiesList(FlywheelIterationProperties... flywheelIterationPropertiesList) {
            flywheelIterationPropertiesList(Arrays.asList(flywheelIterationPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flywheelIterationPropertiesList(
                Consumer<FlywheelIterationProperties.Builder>... flywheelIterationPropertiesList) {
            flywheelIterationPropertiesList(Stream.of(flywheelIterationPropertiesList)
                    .map(c -> FlywheelIterationProperties.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFlywheelIterationHistoryResponse build() {
            return new ListFlywheelIterationHistoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
