/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.DocumentReadAction;
import software.amazon.awssdk.services.comprehend.model.DocumentReadFeatureTypes;
import software.amazon.awssdk.services.comprehend.model.DocumentReadMode;
import software.amazon.awssdk.services.comprehend.model.ListOfDocumentReadFeatureTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentReaderConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentReaderConfig> {
    private static final SdkField<String> DOCUMENT_READ_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentReadAction").getter(DocumentReaderConfig.getter(DocumentReaderConfig::documentReadActionAsString)).setter(DocumentReaderConfig.setter(Builder::documentReadAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentReadAction").build()}).build();
    private static final SdkField<String> DOCUMENT_READ_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentReadMode").getter(DocumentReaderConfig.getter(DocumentReaderConfig::documentReadModeAsString)).setter(DocumentReaderConfig.setter(Builder::documentReadMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentReadMode").build()}).build();
    private static final SdkField<List<String>> FEATURE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FeatureTypes").getter(DocumentReaderConfig.getter(DocumentReaderConfig::featureTypesAsStrings)).setter(DocumentReaderConfig.setter(Builder::featureTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_READ_ACTION_FIELD, DOCUMENT_READ_MODE_FIELD, FEATURE_TYPES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String documentReadAction;
    private final String documentReadMode;
    private final List<String> featureTypes;

    private DocumentReaderConfig(BuilderImpl builder) {
        this.documentReadAction = builder.documentReadAction;
        this.documentReadMode = builder.documentReadMode;
        this.featureTypes = builder.featureTypes;
    }

    public final DocumentReadAction documentReadAction() {
        return DocumentReadAction.fromValue(this.documentReadAction);
    }

    public final String documentReadActionAsString() {
        return this.documentReadAction;
    }

    public final DocumentReadMode documentReadMode() {
        return DocumentReadMode.fromValue(this.documentReadMode);
    }

    public final String documentReadModeAsString() {
        return this.documentReadMode;
    }

    public final List<DocumentReadFeatureTypes> featureTypes() {
        return ListOfDocumentReadFeatureTypesCopier.copyStringToEnum(this.featureTypes);
    }

    public final boolean hasFeatureTypes() {
        return this.featureTypes != null && !(this.featureTypes instanceof SdkAutoConstructList);
    }

    public final List<String> featureTypesAsStrings() {
        return this.featureTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.documentReadActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentReadModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeatureTypes() ? this.featureTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentReaderConfig)) {
            return false;
        }
        DocumentReaderConfig other = (DocumentReaderConfig)obj;
        return Objects.equals(this.documentReadActionAsString(), other.documentReadActionAsString()) && Objects.equals(this.documentReadModeAsString(), other.documentReadModeAsString()) && this.hasFeatureTypes() == other.hasFeatureTypes() && Objects.equals(this.featureTypesAsStrings(), other.featureTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentReaderConfig").add("DocumentReadAction", (Object)this.documentReadActionAsString()).add("DocumentReadMode", (Object)this.documentReadModeAsString()).add("FeatureTypes", this.hasFeatureTypes() ? this.featureTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentReadAction": {
                return Optional.ofNullable(clazz.cast(this.documentReadActionAsString()));
            }
            case "DocumentReadMode": {
                return Optional.ofNullable(clazz.cast(this.documentReadModeAsString()));
            }
            case "FeatureTypes": {
                return Optional.ofNullable(clazz.cast(this.featureTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentReaderConfig, T> g) {
        return obj -> g.apply((DocumentReaderConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String documentReadAction;
        private String documentReadMode;
        private List<String> featureTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentReaderConfig model) {
            this.documentReadAction(model.documentReadAction);
            this.documentReadMode(model.documentReadMode);
            this.featureTypesWithStrings(model.featureTypes);
        }

        public final String getDocumentReadAction() {
            return this.documentReadAction;
        }

        public final void setDocumentReadAction(String documentReadAction) {
            this.documentReadAction = documentReadAction;
        }

        @Override
        public final Builder documentReadAction(String documentReadAction) {
            this.documentReadAction = documentReadAction;
            return this;
        }

        @Override
        public final Builder documentReadAction(DocumentReadAction documentReadAction) {
            this.documentReadAction(documentReadAction == null ? null : documentReadAction.toString());
            return this;
        }

        public final String getDocumentReadMode() {
            return this.documentReadMode;
        }

        public final void setDocumentReadMode(String documentReadMode) {
            this.documentReadMode = documentReadMode;
        }

        @Override
        public final Builder documentReadMode(String documentReadMode) {
            this.documentReadMode = documentReadMode;
            return this;
        }

        @Override
        public final Builder documentReadMode(DocumentReadMode documentReadMode) {
            this.documentReadMode(documentReadMode == null ? null : documentReadMode.toString());
            return this;
        }

        public final Collection<String> getFeatureTypes() {
            if (this.featureTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.featureTypes;
        }

        public final void setFeatureTypes(Collection<String> featureTypes) {
            this.featureTypes = ListOfDocumentReadFeatureTypesCopier.copy(featureTypes);
        }

        @Override
        public final Builder featureTypesWithStrings(Collection<String> featureTypes) {
            this.featureTypes = ListOfDocumentReadFeatureTypesCopier.copy(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypesWithStrings(String ... featureTypes) {
            this.featureTypesWithStrings(Arrays.asList(featureTypes));
            return this;
        }

        @Override
        public final Builder featureTypes(Collection<DocumentReadFeatureTypes> featureTypes) {
            this.featureTypes = ListOfDocumentReadFeatureTypesCopier.copyEnumToString(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypes(DocumentReadFeatureTypes ... featureTypes) {
            this.featureTypes(Arrays.asList(featureTypes));
            return this;
        }

        public DocumentReaderConfig build() {
            return new DocumentReaderConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentReaderConfig> {
        public Builder documentReadAction(String var1);

        public Builder documentReadAction(DocumentReadAction var1);

        public Builder documentReadMode(String var1);

        public Builder documentReadMode(DocumentReadMode var1);

        public Builder featureTypesWithStrings(Collection<String> var1);

        public Builder featureTypesWithStrings(String ... var1);

        public Builder featureTypes(Collection<DocumentReadFeatureTypes> var1);

        public Builder featureTypes(DocumentReadFeatureTypes ... var1);
    }
}

