/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ListOfDocumentTypeCopier {
    static List<DocumentTypeListItem> copy(Collection<? extends DocumentTypeListItem> listOfDocumentTypeParam) {
        List<DocumentTypeListItem> list;
        if (listOfDocumentTypeParam == null || listOfDocumentTypeParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DocumentTypeListItem> modifiableList = new ArrayList<>();
            listOfDocumentTypeParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DocumentTypeListItem> copyFromBuilder(Collection<? extends DocumentTypeListItem.Builder> listOfDocumentTypeParam) {
        List<DocumentTypeListItem> list;
        if (listOfDocumentTypeParam == null || listOfDocumentTypeParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DocumentTypeListItem> modifiableList = new ArrayList<>();
            listOfDocumentTypeParam.forEach(entry -> {
                DocumentTypeListItem member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DocumentTypeListItem.Builder> copyToBuilder(Collection<? extends DocumentTypeListItem> listOfDocumentTypeParam) {
        List<DocumentTypeListItem.Builder> list;
        if (listOfDocumentTypeParam == null || listOfDocumentTypeParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DocumentTypeListItem.Builder> modifiableList = new ArrayList<>();
            listOfDocumentTypeParam.forEach(entry -> {
                DocumentTypeListItem.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
