/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.comprehend.ComprehendClient;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse;

public class ListDocumentClassificationJobsIterable
implements SdkIterable<ListDocumentClassificationJobsResponse> {
    private final ComprehendClient client;
    private final ListDocumentClassificationJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDocumentClassificationJobsIterable(ComprehendClient client, ListDocumentClassificationJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDocumentClassificationJobsResponseFetcher();
    }

    public Iterator<ListDocumentClassificationJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDocumentClassificationJobsResponseFetcher
    implements SyncPageFetcher<ListDocumentClassificationJobsResponse> {
        private ListDocumentClassificationJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListDocumentClassificationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDocumentClassificationJobsResponse nextPage(ListDocumentClassificationJobsResponse previousPage) {
            if (previousPage == null) {
                return ListDocumentClassificationJobsIterable.this.client.listDocumentClassificationJobs(ListDocumentClassificationJobsIterable.this.firstRequest);
            }
            return ListDocumentClassificationJobsIterable.this.client.listDocumentClassificationJobs((ListDocumentClassificationJobsRequest)((Object)ListDocumentClassificationJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

