/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>StartPipelineExecution</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartPipelineExecutionRequest extends CodePipelineRequest implements
        ToCopyableBuilder<StartPipelineExecutionRequest.Builder, StartPipelineExecutionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(StartPipelineExecutionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<PipelineVariable>> VARIABLES_FIELD = SdkField
            .<List<PipelineVariable>> builder(MarshallingType.LIST)
            .memberName("variables")
            .getter(getter(StartPipelineExecutionRequest::variables))
            .setter(setter(Builder::variables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PipelineVariable> builder(MarshallingType.SDK_POJO)
                                            .constructor(PipelineVariable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(StartPipelineExecutionRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VARIABLES_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD));

    private final String name;

    private final List<PipelineVariable> variables;

    private final String clientRequestToken;

    private StartPipelineExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.variables = builder.variables;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The name of the pipeline to start.
     * </p>
     * 
     * @return The name of the pipeline to start.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Variables property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVariables() {
        return variables != null && !(variables instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that overrides pipeline variables for a pipeline execution that's being started. Variable names must match
     * <code>[A-Za-z0-9@\-_]+</code>, and the values can be anything except an empty string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVariables} method.
     * </p>
     * 
     * @return A list that overrides pipeline variables for a pipeline execution that's being started. Variable names
     *         must match <code>[A-Za-z0-9@\-_]+</code>, and the values can be anything except an empty string.
     */
    public final List<PipelineVariable> variables() {
        return variables;
    }

    /**
     * <p>
     * The system-generated unique ID used to identify a unique execution request.
     * </p>
     * 
     * @return The system-generated unique ID used to identify a unique execution request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasVariables() ? variables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartPipelineExecutionRequest)) {
            return false;
        }
        StartPipelineExecutionRequest other = (StartPipelineExecutionRequest) obj;
        return Objects.equals(name(), other.name()) && hasVariables() == other.hasVariables()
                && Objects.equals(variables(), other.variables())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartPipelineExecutionRequest").add("Name", name())
                .add("Variables", hasVariables() ? variables() : null).add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "variables":
            return Optional.ofNullable(clazz.cast(variables()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartPipelineExecutionRequest, T> g) {
        return obj -> g.apply((StartPipelineExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartPipelineExecutionRequest> {
        /**
         * <p>
         * The name of the pipeline to start.
         * </p>
         * 
         * @param name
         *        The name of the pipeline to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A list that overrides pipeline variables for a pipeline execution that's being started. Variable names must
         * match <code>[A-Za-z0-9@\-_]+</code>, and the values can be anything except an empty string.
         * </p>
         * 
         * @param variables
         *        A list that overrides pipeline variables for a pipeline execution that's being started. Variable names
         *        must match <code>[A-Za-z0-9@\-_]+</code>, and the values can be anything except an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variables(Collection<PipelineVariable> variables);

        /**
         * <p>
         * A list that overrides pipeline variables for a pipeline execution that's being started. Variable names must
         * match <code>[A-Za-z0-9@\-_]+</code>, and the values can be anything except an empty string.
         * </p>
         * 
         * @param variables
         *        A list that overrides pipeline variables for a pipeline execution that's being started. Variable names
         *        must match <code>[A-Za-z0-9@\-_]+</code>, and the values can be anything except an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variables(PipelineVariable... variables);

        /**
         * <p>
         * A list that overrides pipeline variables for a pipeline execution that's being started. Variable names must
         * match <code>[A-Za-z0-9@\-_]+</code>, and the values can be anything except an empty string.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codepipeline.model.PipelineVariable.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.codepipeline.model.PipelineVariable#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codepipeline.model.PipelineVariable.Builder#build()} is called
         * immediately and its result is passed to {@link #variables(List<PipelineVariable>)}.
         * 
         * @param variables
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codepipeline.model.PipelineVariable.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #variables(java.util.Collection<PipelineVariable>)
         */
        Builder variables(Consumer<PipelineVariable.Builder>... variables);

        /**
         * <p>
         * The system-generated unique ID used to identify a unique execution request.
         * </p>
         * 
         * @param clientRequestToken
         *        The system-generated unique ID used to identify a unique execution request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodePipelineRequest.BuilderImpl implements Builder {
        private String name;

        private List<PipelineVariable> variables = DefaultSdkAutoConstructList.getInstance();

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartPipelineExecutionRequest model) {
            super(model);
            name(model.name);
            variables(model.variables);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<PipelineVariable.Builder> getVariables() {
            List<PipelineVariable.Builder> result = PipelineVariableListCopier.copyToBuilder(this.variables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariables(Collection<PipelineVariable.BuilderImpl> variables) {
            this.variables = PipelineVariableListCopier.copyFromBuilder(variables);
        }

        @Override
        public final Builder variables(Collection<PipelineVariable> variables) {
            this.variables = PipelineVariableListCopier.copy(variables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(PipelineVariable... variables) {
            variables(Arrays.asList(variables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(Consumer<PipelineVariable.Builder>... variables) {
            variables(Stream.of(variables).map(c -> PipelineVariable.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartPipelineExecutionRequest build() {
            return new StartPipelineExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
