/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.ExecutorConfiguration;
import software.amazon.awssdk.services.codepipeline.model.ExecutorType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActionTypeExecutor
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActionTypeExecutor> {
    private static final SdkField<ExecutorConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(ActionTypeExecutor.getter(ActionTypeExecutor::configuration)).setter(ActionTypeExecutor.setter(Builder::configuration)).constructor(ExecutorConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ActionTypeExecutor.getter(ActionTypeExecutor::typeAsString)).setter(ActionTypeExecutor.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> POLICY_STATEMENTS_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyStatementsTemplate").getter(ActionTypeExecutor.getter(ActionTypeExecutor::policyStatementsTemplate)).setter(ActionTypeExecutor.setter(Builder::policyStatementsTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStatementsTemplate").build()}).build();
    private static final SdkField<Integer> JOB_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("jobTimeout").getter(ActionTypeExecutor.getter(ActionTypeExecutor::jobTimeout)).setter(ActionTypeExecutor.setter(Builder::jobTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTimeout").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD, TYPE_FIELD, POLICY_STATEMENTS_TEMPLATE_FIELD, JOB_TIMEOUT_FIELD));
    private static final long serialVersionUID = 1L;
    private final ExecutorConfiguration configuration;
    private final String type;
    private final String policyStatementsTemplate;
    private final Integer jobTimeout;

    private ActionTypeExecutor(BuilderImpl builder) {
        this.configuration = builder.configuration;
        this.type = builder.type;
        this.policyStatementsTemplate = builder.policyStatementsTemplate;
        this.jobTimeout = builder.jobTimeout;
    }

    public final ExecutorConfiguration configuration() {
        return this.configuration;
    }

    public final ExecutorType type() {
        return ExecutorType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String policyStatementsTemplate() {
        return this.policyStatementsTemplate;
    }

    public final Integer jobTimeout() {
        return this.jobTimeout;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyStatementsTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTimeout());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionTypeExecutor)) {
            return false;
        }
        ActionTypeExecutor other = (ActionTypeExecutor)obj;
        return Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.policyStatementsTemplate(), other.policyStatementsTemplate()) && Objects.equals(this.jobTimeout(), other.jobTimeout());
    }

    public final String toString() {
        return ToString.builder((String)"ActionTypeExecutor").add("Configuration", (Object)this.configuration()).add("Type", (Object)this.typeAsString()).add("PolicyStatementsTemplate", (Object)this.policyStatementsTemplate()).add("JobTimeout", (Object)this.jobTimeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "policyStatementsTemplate": {
                return Optional.ofNullable(clazz.cast(this.policyStatementsTemplate()));
            }
            case "jobTimeout": {
                return Optional.ofNullable(clazz.cast(this.jobTimeout()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionTypeExecutor, T> g) {
        return obj -> g.apply((ActionTypeExecutor)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ExecutorConfiguration configuration;
        private String type;
        private String policyStatementsTemplate;
        private Integer jobTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionTypeExecutor model) {
            this.configuration(model.configuration);
            this.type(model.type);
            this.policyStatementsTemplate(model.policyStatementsTemplate);
            this.jobTimeout(model.jobTimeout);
        }

        public final ExecutorConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(ExecutorConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(ExecutorConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ExecutorType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getPolicyStatementsTemplate() {
            return this.policyStatementsTemplate;
        }

        public final void setPolicyStatementsTemplate(String policyStatementsTemplate) {
            this.policyStatementsTemplate = policyStatementsTemplate;
        }

        @Override
        public final Builder policyStatementsTemplate(String policyStatementsTemplate) {
            this.policyStatementsTemplate = policyStatementsTemplate;
            return this;
        }

        public final Integer getJobTimeout() {
            return this.jobTimeout;
        }

        public final void setJobTimeout(Integer jobTimeout) {
            this.jobTimeout = jobTimeout;
        }

        @Override
        public final Builder jobTimeout(Integer jobTimeout) {
            this.jobTimeout = jobTimeout;
            return this;
        }

        public ActionTypeExecutor build() {
            return new ActionTypeExecutor(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActionTypeExecutor> {
        public Builder configuration(ExecutorConfiguration var1);

        default public Builder configuration(Consumer<ExecutorConfiguration.Builder> configuration) {
            return this.configuration((ExecutorConfiguration)((ExecutorConfiguration.Builder)ExecutorConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder type(String var1);

        public Builder type(ExecutorType var1);

        public Builder policyStatementsTemplate(String var1);

        public Builder jobTimeout(Integer var1);
    }
}

