/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WebhookAuthenticationType {
    GITHUB_HMAC("GITHUB_HMAC"),
    IP("IP"),
    UNAUTHENTICATED("UNAUTHENTICATED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WebhookAuthenticationType> VALUE_MAP;
    private final String value;

    private WebhookAuthenticationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WebhookAuthenticationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WebhookAuthenticationType> knownValues() {
        EnumSet<WebhookAuthenticationType> knownValues = EnumSet.allOf(WebhookAuthenticationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WebhookAuthenticationType.class, WebhookAuthenticationType::toString);
    }
}

