/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codepipeline.CodePipelineAsyncClient;
import software.amazon.awssdk.services.codepipeline.CodePipelineAsyncClientBuilder;
import software.amazon.awssdk.services.codepipeline.CodePipelineServiceClientConfiguration;
import software.amazon.awssdk.services.codepipeline.DefaultCodePipelineAsyncClient;
import software.amazon.awssdk.services.codepipeline.DefaultCodePipelineBaseClientBuilder;
import software.amazon.awssdk.services.codepipeline.endpoints.CodePipelineEndpointProvider;

@SdkInternalApi
final class DefaultCodePipelineAsyncClientBuilder
extends DefaultCodePipelineBaseClientBuilder<CodePipelineAsyncClientBuilder, CodePipelineAsyncClient>
implements CodePipelineAsyncClientBuilder {
    DefaultCodePipelineAsyncClientBuilder() {
    }

    @Override
    public DefaultCodePipelineAsyncClientBuilder endpointProvider(CodePipelineEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodePipelineAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCodePipelineAsyncClientBuilder.validateClientOptions(clientConfiguration);
        CodePipelineServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCodePipelineAsyncClient client = new DefaultCodePipelineAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CodePipelineServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CodePipelineServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

