/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.ArtifactRevision;
import software.amazon.awssdk.services.codepipeline.model.ArtifactRevisionListCopier;
import software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipelineExecution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipelineExecution> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineName").getter(PipelineExecution.getter(PipelineExecution::pipelineName)).setter(PipelineExecution.setter(Builder::pipelineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineName").build()}).build();
    private static final SdkField<Integer> PIPELINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("pipelineVersion").getter(PipelineExecution.getter(PipelineExecution::pipelineVersion)).setter(PipelineExecution.setter(Builder::pipelineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineVersion").build()}).build();
    private static final SdkField<String> PIPELINE_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineExecutionId").getter(PipelineExecution.getter(PipelineExecution::pipelineExecutionId)).setter(PipelineExecution.setter(Builder::pipelineExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineExecutionId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(PipelineExecution.getter(PipelineExecution::statusAsString)).setter(PipelineExecution.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusSummary").getter(PipelineExecution.getter(PipelineExecution::statusSummary)).setter(PipelineExecution.setter(Builder::statusSummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusSummary").build()}).build();
    private static final SdkField<List<ArtifactRevision>> ARTIFACT_REVISIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("artifactRevisions").getter(PipelineExecution.getter(PipelineExecution::artifactRevisions)).setter(PipelineExecution.setter(Builder::artifactRevisions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactRevisions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ArtifactRevision::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD, PIPELINE_VERSION_FIELD, PIPELINE_EXECUTION_ID_FIELD, STATUS_FIELD, STATUS_SUMMARY_FIELD, ARTIFACT_REVISIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String pipelineName;
    private final Integer pipelineVersion;
    private final String pipelineExecutionId;
    private final String status;
    private final String statusSummary;
    private final List<ArtifactRevision> artifactRevisions;

    private PipelineExecution(BuilderImpl builder) {
        this.pipelineName = builder.pipelineName;
        this.pipelineVersion = builder.pipelineVersion;
        this.pipelineExecutionId = builder.pipelineExecutionId;
        this.status = builder.status;
        this.statusSummary = builder.statusSummary;
        this.artifactRevisions = builder.artifactRevisions;
    }

    public final String pipelineName() {
        return this.pipelineName;
    }

    public final Integer pipelineVersion() {
        return this.pipelineVersion;
    }

    public final String pipelineExecutionId() {
        return this.pipelineExecutionId;
    }

    public final PipelineExecutionStatus status() {
        return PipelineExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusSummary() {
        return this.statusSummary;
    }

    public final boolean hasArtifactRevisions() {
        return this.artifactRevisions != null && !(this.artifactRevisions instanceof SdkAutoConstructList);
    }

    public final List<ArtifactRevision> artifactRevisions() {
        return this.artifactRevisions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArtifactRevisions() ? this.artifactRevisions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineExecution)) {
            return false;
        }
        PipelineExecution other = (PipelineExecution)obj;
        return Objects.equals(this.pipelineName(), other.pipelineName()) && Objects.equals(this.pipelineVersion(), other.pipelineVersion()) && Objects.equals(this.pipelineExecutionId(), other.pipelineExecutionId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusSummary(), other.statusSummary()) && this.hasArtifactRevisions() == other.hasArtifactRevisions() && Objects.equals(this.artifactRevisions(), other.artifactRevisions());
    }

    public final String toString() {
        return ToString.builder((String)"PipelineExecution").add("PipelineName", (Object)this.pipelineName()).add("PipelineVersion", (Object)this.pipelineVersion()).add("PipelineExecutionId", (Object)this.pipelineExecutionId()).add("Status", (Object)this.statusAsString()).add("StatusSummary", (Object)this.statusSummary()).add("ArtifactRevisions", this.hasArtifactRevisions() ? this.artifactRevisions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineName": {
                return Optional.ofNullable(clazz.cast(this.pipelineName()));
            }
            case "pipelineVersion": {
                return Optional.ofNullable(clazz.cast(this.pipelineVersion()));
            }
            case "pipelineExecutionId": {
                return Optional.ofNullable(clazz.cast(this.pipelineExecutionId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusSummary": {
                return Optional.ofNullable(clazz.cast(this.statusSummary()));
            }
            case "artifactRevisions": {
                return Optional.ofNullable(clazz.cast(this.artifactRevisions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineExecution, T> g) {
        return obj -> g.apply((PipelineExecution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineName;
        private Integer pipelineVersion;
        private String pipelineExecutionId;
        private String status;
        private String statusSummary;
        private List<ArtifactRevision> artifactRevisions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineExecution model) {
            this.pipelineName(model.pipelineName);
            this.pipelineVersion(model.pipelineVersion);
            this.pipelineExecutionId(model.pipelineExecutionId);
            this.status(model.status);
            this.statusSummary(model.statusSummary);
            this.artifactRevisions(model.artifactRevisions);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final Integer getPipelineVersion() {
            return this.pipelineVersion;
        }

        public final void setPipelineVersion(Integer pipelineVersion) {
            this.pipelineVersion = pipelineVersion;
        }

        @Override
        public final Builder pipelineVersion(Integer pipelineVersion) {
            this.pipelineVersion = pipelineVersion;
            return this;
        }

        public final String getPipelineExecutionId() {
            return this.pipelineExecutionId;
        }

        public final void setPipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
        }

        @Override
        public final Builder pipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PipelineExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusSummary() {
            return this.statusSummary;
        }

        public final void setStatusSummary(String statusSummary) {
            this.statusSummary = statusSummary;
        }

        @Override
        public final Builder statusSummary(String statusSummary) {
            this.statusSummary = statusSummary;
            return this;
        }

        public final List<ArtifactRevision.Builder> getArtifactRevisions() {
            List<ArtifactRevision.Builder> result = ArtifactRevisionListCopier.copyToBuilder(this.artifactRevisions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setArtifactRevisions(Collection<ArtifactRevision.BuilderImpl> artifactRevisions) {
            this.artifactRevisions = ArtifactRevisionListCopier.copyFromBuilder(artifactRevisions);
        }

        @Override
        public final Builder artifactRevisions(Collection<ArtifactRevision> artifactRevisions) {
            this.artifactRevisions = ArtifactRevisionListCopier.copy(artifactRevisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder artifactRevisions(ArtifactRevision ... artifactRevisions) {
            this.artifactRevisions(Arrays.asList(artifactRevisions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder artifactRevisions(Consumer<ArtifactRevision.Builder> ... artifactRevisions) {
            this.artifactRevisions(Stream.of(artifactRevisions).map(c -> (ArtifactRevision)((ArtifactRevision.Builder)ArtifactRevision.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PipelineExecution build() {
            return new PipelineExecution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipelineExecution> {
        public Builder pipelineName(String var1);

        public Builder pipelineVersion(Integer var1);

        public Builder pipelineExecutionId(String var1);

        public Builder status(String var1);

        public Builder status(PipelineExecutionStatus var1);

        public Builder statusSummary(String var1);

        public Builder artifactRevisions(Collection<ArtifactRevision> var1);

        public Builder artifactRevisions(ArtifactRevision ... var1);

        public Builder artifactRevisions(Consumer<ArtifactRevision.Builder> ... var1);
    }
}

