/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ArtifactLocationType {
    S3("S3"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ArtifactLocationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ArtifactLocationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ArtifactLocationType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ArtifactLocationType> knownValues() {
        return Stream.of(ArtifactLocationType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

