/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.rules.EndpointRulesSpecUtils;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.http.SdkHttpRequest;

public class RequestEndpointInterceptorSpec
implements ClassSpec {
    private final EndpointRulesSpecUtils endpointRulesSpecUtils;

    public RequestEndpointInterceptorSpec(IntermediateModel model) {
        this.endpointRulesSpecUtils = new EndpointRulesSpecUtils(model);
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder b = PoetUtils.createClassBuilder(this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(SdkInternalApi.class).addSuperinterface(ExecutionInterceptor.class);
        b.addMethod(this.modifyHttpRequestMethod());
        return b.build();
    }

    @Override
    public ClassName className() {
        return this.endpointRulesSpecUtils.requestModifierInterceptorName();
    }

    private MethodSpec modifyHttpRequestMethod() {
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"modifyHttpRequest").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(SdkHttpRequest.class).addParameter(Context.ModifyHttpRequest.class, "context", new Modifier[0]).addParameter(ExecutionAttributes.class, "executionAttributes", new Modifier[0]);
        b.beginControlFlow("if ($1T.endpointIsDiscovered(executionAttributes))", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("AwsEndpointProviderUtils")}).addStatement("return context.httpRequest()", new Object[0]).endControlFlow().build();
        b.addStatement("$1T endpoint = ($1T) executionAttributes.getAttribute($2T.RESOLVED_ENDPOINT)", new Object[]{Endpoint.class, SdkInternalExecutionAttribute.class});
        b.addStatement("return $T.setUri(context.httpRequest(),executionAttributes.getAttribute($T.CLIENT_ENDPOINT),endpoint.url())", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("AwsEndpointProviderUtils"), SdkExecutionAttribute.class});
        return b.build();
    }
}

