/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.awscore.AwsServiceClientConfiguration;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.model.ServiceClientConfigurationUtils;

public class ServiceClientConfigurationClass
implements ClassSpec {
    private final ClassName defaultClientMetadataClassName;
    private final ServiceClientConfigurationUtils utils;

    public ServiceClientConfigurationClass(IntermediateModel model) {
        String basePackage = model.getMetadata().getFullClientPackageName();
        String serviceId = model.getMetadata().getServiceName();
        this.defaultClientMetadataClassName = ClassName.get((String)basePackage, (String)(serviceId + "ServiceClientConfiguration"), (String[])new String[0]);
        this.utils = new ServiceClientConfigurationUtils(model);
    }

    @Override
    public ClassName className() {
        return this.utils.serviceClientConfigurationClassName();
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder builder = PoetUtils.createClassBuilder(this.defaultClientMetadataClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(SdkPublicApi.class).superclass(AwsServiceClientConfiguration.class).addJavadoc("Class to expose the service client settings to the user. Implementation of {@link $T}", new Object[]{AwsServiceClientConfiguration.class});
        builder.addMethod(this.constructor()).addMethod(this.builderMethod());
        for (ServiceClientConfigurationUtils.Field field : this.utils.serviceClientConfigurationFields()) {
            if (field.isInherited()) continue;
            builder.addField(field.type(), field.name(), new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            builder.addMethod(field.localGetter());
        }
        return builder.addType(this.builderInterfaceSpec()).build();
    }

    private MethodSpec constructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.className().nestedClass("Builder"), "builder", new Modifier[0]);
        builder.addStatement("super(builder)", new Object[0]);
        for (ServiceClientConfigurationUtils.Field field : this.utils.serviceClientConfigurationFields()) {
            if (field.isInherited()) continue;
            builder.addStatement("this.$L = builder.$L()", new Object[]{field.name(), field.name()});
        }
        return builder.build();
    }

    private MethodSpec builderMethod() {
        return MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addStatement("return new $T()", new Object[]{this.utils.serviceClientConfigurationBuilderClassName()}).returns((TypeName)this.className().nestedClass("Builder")).build();
    }

    private TypeSpec builderInterfaceSpec() {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)ClassName.get(AwsServiceClientConfiguration.class).nestedClass("Builder")).addJavadoc("A builder for creating a {@link $T}", new Object[]{this.className()});
        for (ServiceClientConfigurationUtils.Field field : this.utils.serviceClientConfigurationFields()) {
            MethodSpec.Builder setterMethod = field.setterSpec().toBuilder().addModifiers(new Modifier[]{Modifier.ABSTRACT});
            MethodSpec.Builder getterMethod = field.getterSpec().toBuilder().addModifiers(new Modifier[]{Modifier.ABSTRACT});
            if (field.isInherited()) {
                setterMethod.addAnnotation(Override.class);
                getterMethod.addAnnotation(Override.class);
            }
            builder.addMethod(setterMethod.build());
            builder.addMethod(getterMethod.build());
        }
        builder.addMethod(MethodSpec.methodBuilder((String)"build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)this.className()).build());
        return builder.build();
    }
}

