/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.codedeploy.internal.CodeDeployServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.codedeploy.model.AddTagsToOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.AddTagsToOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.AlarmsLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.ApplicationAlreadyExistsException;
import software.amazon.awssdk.services.codedeploy.model.ApplicationDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.ApplicationLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.ApplicationNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.ArnNotSupportedException;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationRevisionsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationRevisionsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentGroupsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentGroupsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentTargetsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentTargetsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.BucketNameFilterRequiredException;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployException;
import software.amazon.awssdk.services.codedeploy.model.ContinueDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.ContinueDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentConfigRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentConfigResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentConfigRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentConfigResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteGitHubAccountTokenRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteGitHubAccountTokenResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteResourcesByExternalIdRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteResourcesByExternalIdResponse;
import software.amazon.awssdk.services.codedeploy.model.DeploymentAlreadyCompletedException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigAlreadyExistsException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigInUseException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupAlreadyExistsException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentIdRequiredException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentIsNotInReadyStateException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentNotStartedException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentTargetDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentTargetIdRequiredException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentTargetListSizeExceededException;
import software.amazon.awssdk.services.codedeploy.model.DeregisterOnPremisesInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.DeregisterOnPremisesInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.DescriptionTooLongException;
import software.amazon.awssdk.services.codedeploy.model.EcsServiceMappingLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationRevisionRequest;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationRevisionResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentConfigRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentConfigResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentTargetRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentTargetResponse;
import software.amazon.awssdk.services.codedeploy.model.GetOnPremisesInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.GetOnPremisesInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.GitHubAccountTokenDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.GitHubAccountTokenNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.IamArnRequiredException;
import software.amazon.awssdk.services.codedeploy.model.IamSessionArnAlreadyRegisteredException;
import software.amazon.awssdk.services.codedeploy.model.IamUserArnAlreadyRegisteredException;
import software.amazon.awssdk.services.codedeploy.model.IamUserArnRequiredException;
import software.amazon.awssdk.services.codedeploy.model.InstanceLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.InstanceNameAlreadyRegisteredException;
import software.amazon.awssdk.services.codedeploy.model.InstanceNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.InstanceNotRegisteredException;
import software.amazon.awssdk.services.codedeploy.model.InvalidAlarmConfigException;
import software.amazon.awssdk.services.codedeploy.model.InvalidApplicationNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidArnException;
import software.amazon.awssdk.services.codedeploy.model.InvalidAutoRollbackConfigException;
import software.amazon.awssdk.services.codedeploy.model.InvalidAutoScalingGroupException;
import software.amazon.awssdk.services.codedeploy.model.InvalidBlueGreenDeploymentConfigurationException;
import software.amazon.awssdk.services.codedeploy.model.InvalidBucketNameFilterException;
import software.amazon.awssdk.services.codedeploy.model.InvalidComputePlatformException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeployedStateFilterException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentConfigNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentGroupNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentIdException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentInstanceTypeException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentStatusException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentStyleException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentTargetIdException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentWaitTypeException;
import software.amazon.awssdk.services.codedeploy.model.InvalidEc2TagCombinationException;
import software.amazon.awssdk.services.codedeploy.model.InvalidEc2TagException;
import software.amazon.awssdk.services.codedeploy.model.InvalidEcsServiceException;
import software.amazon.awssdk.services.codedeploy.model.InvalidExternalIdException;
import software.amazon.awssdk.services.codedeploy.model.InvalidFileExistsBehaviorException;
import software.amazon.awssdk.services.codedeploy.model.InvalidGitHubAccountTokenException;
import software.amazon.awssdk.services.codedeploy.model.InvalidGitHubAccountTokenNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidIamSessionArnException;
import software.amazon.awssdk.services.codedeploy.model.InvalidIamUserArnException;
import software.amazon.awssdk.services.codedeploy.model.InvalidIgnoreApplicationStopFailuresValueException;
import software.amazon.awssdk.services.codedeploy.model.InvalidInputException;
import software.amazon.awssdk.services.codedeploy.model.InvalidInstanceNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidInstanceStatusException;
import software.amazon.awssdk.services.codedeploy.model.InvalidInstanceTypeException;
import software.amazon.awssdk.services.codedeploy.model.InvalidKeyPrefixFilterException;
import software.amazon.awssdk.services.codedeploy.model.InvalidLifecycleEventHookExecutionIdException;
import software.amazon.awssdk.services.codedeploy.model.InvalidLifecycleEventHookExecutionStatusException;
import software.amazon.awssdk.services.codedeploy.model.InvalidLoadBalancerInfoException;
import software.amazon.awssdk.services.codedeploy.model.InvalidMinimumHealthyHostValueException;
import software.amazon.awssdk.services.codedeploy.model.InvalidNextTokenException;
import software.amazon.awssdk.services.codedeploy.model.InvalidOnPremisesTagCombinationException;
import software.amazon.awssdk.services.codedeploy.model.InvalidOperationException;
import software.amazon.awssdk.services.codedeploy.model.InvalidRegistrationStatusException;
import software.amazon.awssdk.services.codedeploy.model.InvalidRevisionException;
import software.amazon.awssdk.services.codedeploy.model.InvalidRoleException;
import software.amazon.awssdk.services.codedeploy.model.InvalidSortByException;
import software.amazon.awssdk.services.codedeploy.model.InvalidSortOrderException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTagException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTagFilterException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTagsToAddException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTargetGroupPairException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTargetInstancesException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTimeRangeException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTrafficRoutingConfigurationException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTriggerConfigException;
import software.amazon.awssdk.services.codedeploy.model.InvalidUpdateOutdatedInstancesOnlyValueException;
import software.amazon.awssdk.services.codedeploy.model.LifecycleEventAlreadyCompletedException;
import software.amazon.awssdk.services.codedeploy.model.LifecycleHookLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListGitHubAccountTokenNamesRequest;
import software.amazon.awssdk.services.codedeploy.model.ListGitHubAccountTokenNamesResponse;
import software.amazon.awssdk.services.codedeploy.model.ListOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.ListOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.codedeploy.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.codedeploy.model.MultipleIamArnsProvidedException;
import software.amazon.awssdk.services.codedeploy.model.OperationNotSupportedException;
import software.amazon.awssdk.services.codedeploy.model.PutLifecycleEventHookExecutionStatusRequest;
import software.amazon.awssdk.services.codedeploy.model.PutLifecycleEventHookExecutionStatusResponse;
import software.amazon.awssdk.services.codedeploy.model.RegisterApplicationRevisionRequest;
import software.amazon.awssdk.services.codedeploy.model.RegisterApplicationRevisionResponse;
import software.amazon.awssdk.services.codedeploy.model.RegisterOnPremisesInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.RegisterOnPremisesInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.RemoveTagsFromOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.RemoveTagsFromOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.ResourceArnRequiredException;
import software.amazon.awssdk.services.codedeploy.model.ResourceValidationException;
import software.amazon.awssdk.services.codedeploy.model.RevisionDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.RevisionRequiredException;
import software.amazon.awssdk.services.codedeploy.model.RoleRequiredException;
import software.amazon.awssdk.services.codedeploy.model.StopDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.StopDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.TagLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.TagRequiredException;
import software.amazon.awssdk.services.codedeploy.model.TagResourceRequest;
import software.amazon.awssdk.services.codedeploy.model.TagResourceResponse;
import software.amazon.awssdk.services.codedeploy.model.TagSetListLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.ThrottlingException;
import software.amazon.awssdk.services.codedeploy.model.TriggerTargetsLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.UnsupportedActionForDeploymentTypeException;
import software.amazon.awssdk.services.codedeploy.model.UntagResourceRequest;
import software.amazon.awssdk.services.codedeploy.model.UntagResourceResponse;
import software.amazon.awssdk.services.codedeploy.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.UpdateDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.UpdateDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.transform.AddTagsToOnPremisesInstancesRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetApplicationRevisionsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetApplicationsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetDeploymentGroupsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetDeploymentTargetsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetOnPremisesInstancesRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ContinueDeploymentRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.CreateApplicationRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.CreateDeploymentConfigRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.CreateDeploymentGroupRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.CreateDeploymentRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeleteApplicationRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeleteDeploymentConfigRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeleteDeploymentGroupRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeleteGitHubAccountTokenRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeleteResourcesByExternalIdRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeregisterOnPremisesInstanceRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetApplicationRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetApplicationRevisionRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetDeploymentConfigRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetDeploymentGroupRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetDeploymentRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetDeploymentTargetRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetOnPremisesInstanceRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListApplicationRevisionsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListApplicationsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListDeploymentConfigsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListDeploymentGroupsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListDeploymentTargetsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListGitHubAccountTokenNamesRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListOnPremisesInstancesRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.PutLifecycleEventHookExecutionStatusRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.RegisterApplicationRevisionRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.RegisterOnPremisesInstanceRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.RemoveTagsFromOnPremisesInstancesRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.StopDeploymentRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.UpdateApplicationRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.UpdateDeploymentGroupRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.waiters.CodeDeployAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link CodeDeployAsyncClient}.
 *
 * @see CodeDeployAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultCodeDeployAsyncClient implements CodeDeployAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCodeDeployAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final ScheduledExecutorService executorService;

    protected DefaultCodeDeployAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
        this.executorService = clientConfiguration.option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    /**
     * <p>
     * Adds tags to on-premises instances.
     * </p>
     *
     * @param addTagsToOnPremisesInstancesRequest
     *        Represents the input of, and adds tags to, an on-premises instance operation.
     * @return A Java Future containing the result of the AddTagsToOnPremisesInstances operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>InvalidInstanceNameException The on-premises instance name was specified in an invalid format.</li>
     *         <li>TagRequiredException A tag was not specified.</li>
     *         <li>InvalidTagException The tag was specified in an invalid format.</li>
     *         <li>TagLimitExceededException The maximum allowed number of tags was exceeded.</li>
     *         <li>InstanceLimitExceededException The maximum number of allowed on-premises instances in a single call
     *         was exceeded.</li>
     *         <li>InstanceNotRegisteredException The specified on-premises instance is not registered.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.AddTagsToOnPremisesInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/AddTagsToOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AddTagsToOnPremisesInstancesResponse> addTagsToOnPremisesInstances(
            AddTagsToOnPremisesInstancesRequest addTagsToOnPremisesInstancesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addTagsToOnPremisesInstancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addTagsToOnPremisesInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTagsToOnPremisesInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddTagsToOnPremisesInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AddTagsToOnPremisesInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AddTagsToOnPremisesInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddTagsToOnPremisesInstancesRequest, AddTagsToOnPremisesInstancesResponse>()
                            .withOperationName("AddTagsToOnPremisesInstances").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AddTagsToOnPremisesInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addTagsToOnPremisesInstancesRequest));
            CompletableFuture<AddTagsToOnPremisesInstancesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about one or more application revisions. The maximum number of application revisions that can be
     * returned is 25.
     * </p>
     *
     * @param batchGetApplicationRevisionsRequest
     *        Represents the input of a <code>BatchGetApplicationRevisions</code> operation.
     * @return A Java Future containing the result of the BatchGetApplicationRevisions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationDoesNotExistException The application does not exist with the user or Amazon Web Services
     *         account.</li>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>RevisionRequiredException The revision ID was not specified.</li>
     *         <li>InvalidRevisionException The revision was specified in an invalid format.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.BatchGetApplicationRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetApplicationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetApplicationRevisionsResponse> batchGetApplicationRevisions(
            BatchGetApplicationRevisionsRequest batchGetApplicationRevisionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetApplicationRevisionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetApplicationRevisionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetApplicationRevisions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetApplicationRevisionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetApplicationRevisionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchGetApplicationRevisionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetApplicationRevisionsRequest, BatchGetApplicationRevisionsResponse>()
                            .withOperationName("BatchGetApplicationRevisions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetApplicationRevisionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetApplicationRevisionsRequest));
            CompletableFuture<BatchGetApplicationRevisionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about one or more applications. The maximum number of applications that can be returned is 100.
     * </p>
     *
     * @param batchGetApplicationsRequest
     *        Represents the input of a <code>BatchGetApplications</code> operation.
     * @return A Java Future containing the result of the BatchGetApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the user or Amazon Web Services
     *         account.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.BatchGetApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetApplications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetApplicationsResponse> batchGetApplications(
            BatchGetApplicationsRequest batchGetApplicationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetApplicationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetApplicationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetApplications");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetApplicationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetApplicationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchGetApplicationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetApplicationsRequest, BatchGetApplicationsResponse>()
                            .withOperationName("BatchGetApplications").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetApplicationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetApplicationsRequest));
            CompletableFuture<BatchGetApplicationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about one or more deployment groups.
     * </p>
     *
     * @param batchGetDeploymentGroupsRequest
     *        Represents the input of a <code>BatchGetDeploymentGroups</code> operation.
     * @return A Java Future containing the result of the BatchGetDeploymentGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the user or Amazon Web Services
     *         account.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the user or
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.BatchGetDeploymentGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeploymentGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetDeploymentGroupsResponse> batchGetDeploymentGroups(
            BatchGetDeploymentGroupsRequest batchGetDeploymentGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetDeploymentGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetDeploymentGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetDeploymentGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetDeploymentGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetDeploymentGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchGetDeploymentGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetDeploymentGroupsRequest, BatchGetDeploymentGroupsResponse>()
                            .withOperationName("BatchGetDeploymentGroups").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetDeploymentGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetDeploymentGroupsRequest));
            CompletableFuture<BatchGetDeploymentGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns an array of one or more targets associated with a deployment. This method works with all compute types
     * and should be used instead of the deprecated <code>BatchGetDeploymentInstances</code>. The maximum number of
     * targets that can be returned is 25.
     * </p>
     * <p>
     * The type of targets returned depends on the deployment's compute platform or deployment method:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>EC2/On-premises</b>: Information about Amazon EC2 instance targets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Lambda</b>: Information about Lambda functions targets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Amazon ECS</b>: Information about Amazon ECS service targets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CloudFormation</b>: Information about targets of blue/green deployments initiated by a CloudFormation stack
     * update.
     * </p>
     * </li>
     * </ul>
     *
     * @param batchGetDeploymentTargetsRequest
     * @return A Java Future containing the result of the BatchGetDeploymentTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment with the user or Amazon Web Services account does not
     *         exist.</li>
     *         <li>DeploymentNotStartedException The specified deployment has not started.</li>
     *         <li>DeploymentTargetIdRequiredException A deployment target ID was not provided.</li>
     *         <li>InvalidDeploymentTargetIdException The target ID provided was not valid.</li>
     *         <li>DeploymentTargetDoesNotExistException The provided target ID does not belong to the attempted
     *         deployment.</li>
     *         <li>DeploymentTargetListSizeExceededException The maximum number of targets that can be associated with
     *         an Amazon ECS or Lambda deployment was exceeded. The target list of both types of deployments must have
     *         exactly one item. This exception does not apply to EC2/On-premises deployments.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.BatchGetDeploymentTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeploymentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetDeploymentTargetsResponse> batchGetDeploymentTargets(
            BatchGetDeploymentTargetsRequest batchGetDeploymentTargetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetDeploymentTargetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetDeploymentTargetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetDeploymentTargets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetDeploymentTargetsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetDeploymentTargetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchGetDeploymentTargetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetDeploymentTargetsRequest, BatchGetDeploymentTargetsResponse>()
                            .withOperationName("BatchGetDeploymentTargets").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetDeploymentTargetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetDeploymentTargetsRequest));
            CompletableFuture<BatchGetDeploymentTargetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about one or more deployments. The maximum number of deployments that can be returned is 25.
     * </p>
     *
     * @param batchGetDeploymentsRequest
     *        Represents the input of a <code>BatchGetDeployments</code> operation.
     * @return A Java Future containing the result of the BatchGetDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.BatchGetDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetDeploymentsResponse> batchGetDeployments(
            BatchGetDeploymentsRequest batchGetDeploymentsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetDeploymentsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetDeploymentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetDeployments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetDeploymentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetDeploymentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchGetDeploymentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetDeploymentsRequest, BatchGetDeploymentsResponse>()
                            .withOperationName("BatchGetDeployments").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetDeploymentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetDeploymentsRequest));
            CompletableFuture<BatchGetDeploymentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about one or more on-premises instances. The maximum number of on-premises instances that can be
     * returned is 25.
     * </p>
     *
     * @param batchGetOnPremisesInstancesRequest
     *        Represents the input of a <code>BatchGetOnPremisesInstances</code> operation.
     * @return A Java Future containing the result of the BatchGetOnPremisesInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>InvalidInstanceNameException The on-premises instance name was specified in an invalid format.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.BatchGetOnPremisesInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetOnPremisesInstancesResponse> batchGetOnPremisesInstances(
            BatchGetOnPremisesInstancesRequest batchGetOnPremisesInstancesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetOnPremisesInstancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetOnPremisesInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetOnPremisesInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetOnPremisesInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetOnPremisesInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchGetOnPremisesInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetOnPremisesInstancesRequest, BatchGetOnPremisesInstancesResponse>()
                            .withOperationName("BatchGetOnPremisesInstances").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetOnPremisesInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetOnPremisesInstancesRequest));
            CompletableFuture<BatchGetOnPremisesInstancesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * For a blue/green deployment, starts the process of rerouting traffic from instances in the original environment
     * to instances in the replacement environment without waiting for a specified wait time to elapse. (Traffic
     * rerouting, which is achieved by registering instances in the replacement environment with the load balancer, can
     * start as soon as all instances have a status of Ready.)
     * </p>
     *
     * @param continueDeploymentRequest
     * @return A Java Future containing the result of the ContinueDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment with the user or Amazon Web Services account does not
     *         exist.</li>
     *         <li>DeploymentAlreadyCompletedException The deployment is already complete.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>DeploymentIsNotInReadyStateException The deployment does not have a status of Ready and can't
     *         continue yet.</li>
     *         <li>UnsupportedActionForDeploymentTypeException A call was submitted that is not supported for the
     *         specified deployment type.</li>
     *         <li>InvalidDeploymentWaitTypeException The wait type is invalid.</li>
     *         <li>InvalidDeploymentStatusException The specified deployment status doesn't exist or cannot be
     *         determined.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ContinueDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ContinueDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ContinueDeploymentResponse> continueDeployment(ContinueDeploymentRequest continueDeploymentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(continueDeploymentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, continueDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ContinueDeployment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ContinueDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ContinueDeploymentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ContinueDeploymentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ContinueDeploymentRequest, ContinueDeploymentResponse>()
                            .withOperationName("ContinueDeployment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ContinueDeploymentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(continueDeploymentRequest));
            CompletableFuture<ContinueDeploymentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an application.
     * </p>
     *
     * @param createApplicationRequest
     *        Represents the input of a <code>CreateApplication</code> operation.
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationAlreadyExistsException An application with the specified name with the user or Amazon Web
     *         Services account already exists.</li>
     *         <li>ApplicationLimitExceededException More applications were attempted to be created than are allowed.</li>
     *         <li>InvalidComputePlatformException The computePlatform is invalid. The computePlatform should be
     *         <code>Lambda</code>, <code>Server</code>, or <code>ECS</code>.</li>
     *         <li>InvalidTagsToAddException The specified tags are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateApplicationResponse> createApplication(CreateApplicationRequest createApplicationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateApplicationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateApplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateApplicationRequest, CreateApplicationResponse>()
                            .withOperationName("CreateApplication").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateApplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createApplicationRequest));
            CompletableFuture<CreateApplicationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deploys an application revision through the specified deployment group.
     * </p>
     *
     * @param createDeploymentRequest
     *        Represents the input of a <code>CreateDeployment</code> operation.
     * @return A Java Future containing the result of the CreateDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the user or Amazon Web Services
     *         account.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group with the user or Amazon Web Services
     *         account does not exist.</li>
     *         <li>RevisionRequiredException The revision ID was not specified.</li>
     *         <li>RevisionDoesNotExistException The named revision does not exist with the user or Amazon Web Services
     *         account.</li>
     *         <li>InvalidRevisionException The revision was specified in an invalid format.</li>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the user or
     *         Amazon Web Services account.</li>
     *         <li>DescriptionTooLongException The description is too long.</li>
     *         <li>DeploymentLimitExceededException The number of allowed deployments was exceeded.</li>
     *         <li>InvalidTargetInstancesException The target instance configuration is invalid. Possible causes
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Configuration data for target instances was entered for an in-place deployment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The limit of 10 tags for a tag type was exceeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The combined length of the tag names exceeded the limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A specified tag is not currently applied to any instances.
     *         </p>
     *         </li></li>
     *         <li>InvalidAlarmConfigException The format of the alarm configuration is invalid. Possible causes
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The alarm list is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm object is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm name is empty or null or exceeds the limit of 255 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Two alarms with the same name have been specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm configuration is enabled, but the alarm list is empty.
     *         </p>
     *         </li></li>
     *         <li>AlarmsLimitExceededException The maximum number of alarms for a deployment group (10) was exceeded.</li>
     *         <li>InvalidAutoRollbackConfigException The automatic rollback configuration was specified in an invalid
     *         format. For example, automatic rollback is enabled, but an invalid triggering event type or no event
     *         types were listed.</li>
     *         <li>InvalidLoadBalancerInfoException An invalid load balancer name, or no load balancer name, was
     *         specified.</li>
     *         <li>InvalidFileExistsBehaviorException An invalid fileExistsBehavior option was specified to determine
     *         how CodeDeploy handles files or directories that already exist in a deployment target location, but
     *         weren't part of the previous successful deployment. Valid values include "DISALLOW," "OVERWRITE," and
     *         "RETAIN."</li>
     *         <li>InvalidRoleException The service role ARN was specified in an invalid format. Or, if an Auto Scaling
     *         group was specified, the specified service role does not grant the appropriate permissions to Amazon EC2
     *         Auto Scaling.</li>
     *         <li>InvalidAutoScalingGroupException The Auto Scaling group was specified in an invalid format or does
     *         not exist.</li>
     *         <li>ThrottlingException An API function was called too frequently.</li>
     *         <li>InvalidUpdateOutdatedInstancesOnlyValueException The UpdateOutdatedInstancesOnly value is invalid.
     *         For Lambda deployments, <code>false</code> is expected. For EC2/On-premises deployments,
     *         <code>true</code> or <code>false</code> is expected.</li>
     *         <li>InvalidIgnoreApplicationStopFailuresValueException The IgnoreApplicationStopFailures value is
     *         invalid. For Lambda deployments, <code>false</code> is expected. For EC2/On-premises deployments,
     *         <code>true</code> or <code>false</code> is expected.</li>
     *         <li>InvalidGitHubAccountTokenException The GitHub token is not valid.</li>
     *         <li>InvalidTrafficRoutingConfigurationException The configuration that specifies how traffic is routed
     *         during a deployment is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.CreateDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDeploymentResponse> createDeployment(CreateDeploymentRequest createDeploymentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDeploymentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDeployment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDeploymentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDeploymentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDeploymentRequest, CreateDeploymentResponse>()
                            .withOperationName("CreateDeployment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDeploymentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDeploymentRequest));
            CompletableFuture<CreateDeploymentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a deployment configuration.
     * </p>
     *
     * @param createDeploymentConfigRequest
     *        Represents the input of a <code>CreateDeploymentConfig</code> operation.
     * @return A Java Future containing the result of the CreateDeploymentConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigNameRequiredException The deployment configuration name was not specified.</li>
     *         <li>DeploymentConfigAlreadyExistsException A deployment configuration with the specified name with the
     *         user or Amazon Web Services account already exists.</li>
     *         <li>InvalidMinimumHealthyHostValueException The minimum healthy instance value was specified in an
     *         invalid format.</li>
     *         <li>DeploymentConfigLimitExceededException The deployment configurations limit was exceeded.</li>
     *         <li>InvalidComputePlatformException The computePlatform is invalid. The computePlatform should be
     *         <code>Lambda</code>, <code>Server</code>, or <code>ECS</code>.</li>
     *         <li>InvalidTrafficRoutingConfigurationException The configuration that specifies how traffic is routed
     *         during a deployment is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.CreateDeploymentConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeploymentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDeploymentConfigResponse> createDeploymentConfig(
            CreateDeploymentConfigRequest createDeploymentConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDeploymentConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDeploymentConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDeploymentConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDeploymentConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDeploymentConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDeploymentConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDeploymentConfigRequest, CreateDeploymentConfigResponse>()
                            .withOperationName("CreateDeploymentConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDeploymentConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDeploymentConfigRequest));
            CompletableFuture<CreateDeploymentConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a deployment group to which application revisions are deployed.
     * </p>
     *
     * @param createDeploymentGroupRequest
     *        Represents the input of a <code>CreateDeploymentGroup</code> operation.
     * @return A Java Future containing the result of the CreateDeploymentGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the user or Amazon Web Services
     *         account.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupAlreadyExistsException A deployment group with the specified name with the user or
     *         Amazon Web Services account already exists.</li>
     *         <li>InvalidEc2TagException The tag was specified in an invalid format.</li>
     *         <li>InvalidTagException The tag was specified in an invalid format.</li>
     *         <li>InvalidAutoScalingGroupException The Auto Scaling group was specified in an invalid format or does
     *         not exist.</li>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the user or
     *         Amazon Web Services account.</li>
     *         <li>RoleRequiredException The role ID was not specified.</li>
     *         <li>InvalidRoleException The service role ARN was specified in an invalid format. Or, if an Auto Scaling
     *         group was specified, the specified service role does not grant the appropriate permissions to Amazon EC2
     *         Auto Scaling.</li>
     *         <li>DeploymentGroupLimitExceededException The deployment groups limit was exceeded.</li>
     *         <li>LifecycleHookLimitExceededException The limit for lifecycle hooks was exceeded.</li>
     *         <li>InvalidTriggerConfigException The trigger was specified in an invalid format.</li>
     *         <li>TriggerTargetsLimitExceededException The maximum allowed number of triggers was exceeded.</li>
     *         <li>InvalidAlarmConfigException The format of the alarm configuration is invalid. Possible causes
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The alarm list is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm object is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm name is empty or null or exceeds the limit of 255 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Two alarms with the same name have been specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm configuration is enabled, but the alarm list is empty.
     *         </p>
     *         </li></li>
     *         <li>AlarmsLimitExceededException The maximum number of alarms for a deployment group (10) was exceeded.</li>
     *         <li>InvalidAutoRollbackConfigException The automatic rollback configuration was specified in an invalid
     *         format. For example, automatic rollback is enabled, but an invalid triggering event type or no event
     *         types were listed.</li>
     *         <li>InvalidLoadBalancerInfoException An invalid load balancer name, or no load balancer name, was
     *         specified.</li>
     *         <li>InvalidDeploymentStyleException An invalid deployment style was specified. Valid deployment types
     *         include "IN_PLACE" and "BLUE_GREEN." Valid deployment options include "WITH_TRAFFIC_CONTROL" and
     *         "WITHOUT_TRAFFIC_CONTROL."</li>
     *         <li>InvalidBlueGreenDeploymentConfigurationException The configuration for the blue/green deployment
     *         group was provided in an invalid format. For information about deployment configuration format, see
     *         <a>CreateDeploymentConfig</a>.</li>
     *         <li>InvalidEc2TagCombinationException A call was submitted that specified both Ec2TagFilters and
     *         Ec2TagSet, but only one of these data types can be used in a single call.</li>
     *         <li>InvalidOnPremisesTagCombinationException A call was submitted that specified both
     *         OnPremisesTagFilters and OnPremisesTagSet, but only one of these data types can be used in a single call.
     *         </li>
     *         <li>TagSetListLimitExceededException The number of tag groups included in the tag set list exceeded the
     *         maximum allowed limit of 3.</li>
     *         <li>InvalidInputException The input was specified in an invalid format.</li>
     *         <li>ThrottlingException An API function was called too frequently.</li>
     *         <li>InvalidEcsServiceException The Amazon ECS service identifier is not valid.</li>
     *         <li>InvalidTargetGroupPairException A target group pair associated with this deployment is not valid.</li>
     *         <li>EcsServiceMappingLimitExceededException The Amazon ECS service is associated with more than one
     *         deployment groups. An Amazon ECS service can be associated with only one deployment group.</li>
     *         <li>InvalidTagsToAddException The specified tags are not valid.</li>
     *         <li>InvalidTrafficRoutingConfigurationException The configuration that specifies how traffic is routed
     *         during a deployment is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.CreateDeploymentGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDeploymentGroupResponse> createDeploymentGroup(
            CreateDeploymentGroupRequest createDeploymentGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDeploymentGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDeploymentGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDeploymentGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDeploymentGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDeploymentGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDeploymentGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDeploymentGroupRequest, CreateDeploymentGroupResponse>()
                            .withOperationName("CreateDeploymentGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDeploymentGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDeploymentGroupRequest));
            CompletableFuture<CreateDeploymentGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an application.
     * </p>
     *
     * @param deleteApplicationRequest
     *        Represents the input of a <code>DeleteApplication</code> operation.
     * @return A Java Future containing the result of the DeleteApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>InvalidRoleException The service role ARN was specified in an invalid format. Or, if an Auto Scaling
     *         group was specified, the specified service role does not grant the appropriate permissions to Amazon EC2
     *         Auto Scaling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteApplication" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest deleteApplicationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteApplicationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteApplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteApplicationRequest, DeleteApplicationResponse>()
                            .withOperationName("DeleteApplication").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteApplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteApplicationRequest));
            CompletableFuture<DeleteApplicationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a deployment configuration.
     * </p>
     * <note>
     * <p>
     * A deployment configuration cannot be deleted if it is currently in use. Predefined configurations cannot be
     * deleted.
     * </p>
     * </note>
     *
     * @param deleteDeploymentConfigRequest
     *        Represents the input of a <code>DeleteDeploymentConfig</code> operation.
     * @return A Java Future containing the result of the DeleteDeploymentConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigNameRequiredException The deployment configuration name was not specified.</li>
     *         <li>DeploymentConfigInUseException The deployment configuration is still in use.</li>
     *         <li>InvalidOperationException An invalid operation was detected.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.DeleteDeploymentConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteDeploymentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDeploymentConfigResponse> deleteDeploymentConfig(
            DeleteDeploymentConfigRequest deleteDeploymentConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDeploymentConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDeploymentConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDeploymentConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDeploymentConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDeploymentConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDeploymentConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDeploymentConfigRequest, DeleteDeploymentConfigResponse>()
                            .withOperationName("DeleteDeploymentConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDeploymentConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDeploymentConfigRequest));
            CompletableFuture<DeleteDeploymentConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a deployment group.
     * </p>
     *
     * @param deleteDeploymentGroupRequest
     *        Represents the input of a <code>DeleteDeploymentGroup</code> operation.
     * @return A Java Future containing the result of the DeleteDeploymentGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>InvalidRoleException The service role ARN was specified in an invalid format. Or, if an Auto Scaling
     *         group was specified, the specified service role does not grant the appropriate permissions to Amazon EC2
     *         Auto Scaling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.DeleteDeploymentGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDeploymentGroupResponse> deleteDeploymentGroup(
            DeleteDeploymentGroupRequest deleteDeploymentGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDeploymentGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDeploymentGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDeploymentGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDeploymentGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDeploymentGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDeploymentGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDeploymentGroupRequest, DeleteDeploymentGroupResponse>()
                            .withOperationName("DeleteDeploymentGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDeploymentGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDeploymentGroupRequest));
            CompletableFuture<DeleteDeploymentGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a GitHub account connection.
     * </p>
     *
     * @param deleteGitHubAccountTokenRequest
     *        Represents the input of a <code>DeleteGitHubAccount</code> operation.
     * @return A Java Future containing the result of the DeleteGitHubAccountToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GitHubAccountTokenNameRequiredException The call is missing a required GitHub account connection
     *         name.</li>
     *         <li>GitHubAccountTokenDoesNotExistException No GitHub account connection exists with the named specified
     *         in the call.</li>
     *         <li>InvalidGitHubAccountTokenNameException The format of the specified GitHub account connection name is
     *         invalid.</li>
     *         <li>ResourceValidationException The specified resource could not be validated.</li>
     *         <li>OperationNotSupportedException The API used does not support the deployment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.DeleteGitHubAccountToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteGitHubAccountToken"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteGitHubAccountTokenResponse> deleteGitHubAccountToken(
            DeleteGitHubAccountTokenRequest deleteGitHubAccountTokenRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGitHubAccountTokenRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGitHubAccountTokenRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGitHubAccountToken");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteGitHubAccountTokenResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteGitHubAccountTokenResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteGitHubAccountTokenResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteGitHubAccountTokenRequest, DeleteGitHubAccountTokenResponse>()
                            .withOperationName("DeleteGitHubAccountToken").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteGitHubAccountTokenRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteGitHubAccountTokenRequest));
            CompletableFuture<DeleteGitHubAccountTokenResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes resources linked to an external ID. This action only applies if you have configured blue/green
     * deployments through CloudFormation.
     * </p>
     * <note>
     * <p>
     * It is not necessary to call this action directly. CloudFormation calls it on your behalf when it needs to delete
     * stack resources. This action is offered publicly in case you need to delete resources to comply with General Data
     * Protection Regulation (GDPR) requirements.
     * </p>
     * </note>
     *
     * @param deleteResourcesByExternalIdRequest
     * @return A Java Future containing the result of the DeleteResourcesByExternalId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.DeleteResourcesByExternalId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteResourcesByExternalId"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteResourcesByExternalIdResponse> deleteResourcesByExternalId(
            DeleteResourcesByExternalIdRequest deleteResourcesByExternalIdRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteResourcesByExternalIdRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourcesByExternalIdRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourcesByExternalId");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteResourcesByExternalIdResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteResourcesByExternalIdResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteResourcesByExternalIdResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteResourcesByExternalIdRequest, DeleteResourcesByExternalIdResponse>()
                            .withOperationName("DeleteResourcesByExternalId").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteResourcesByExternalIdRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteResourcesByExternalIdRequest));
            CompletableFuture<DeleteResourcesByExternalIdResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deregisters an on-premises instance.
     * </p>
     *
     * @param deregisterOnPremisesInstanceRequest
     *        Represents the input of a <code>DeregisterOnPremisesInstance</code> operation.
     * @return A Java Future containing the result of the DeregisterOnPremisesInstance operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>InvalidInstanceNameException The on-premises instance name was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.DeregisterOnPremisesInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeregisterOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterOnPremisesInstanceResponse> deregisterOnPremisesInstance(
            DeregisterOnPremisesInstanceRequest deregisterOnPremisesInstanceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterOnPremisesInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterOnPremisesInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterOnPremisesInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeregisterOnPremisesInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeregisterOnPremisesInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeregisterOnPremisesInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterOnPremisesInstanceRequest, DeregisterOnPremisesInstanceResponse>()
                            .withOperationName("DeregisterOnPremisesInstance").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeregisterOnPremisesInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deregisterOnPremisesInstanceRequest));
            CompletableFuture<DeregisterOnPremisesInstanceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about an application.
     * </p>
     *
     * @param getApplicationRequest
     *        Represents the input of a <code>GetApplication</code> operation.
     * @return A Java Future containing the result of the GetApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the user or Amazon Web Services
     *         account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetApplication" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetApplicationResponse> getApplication(GetApplicationRequest getApplicationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getApplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetApplicationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetApplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetApplicationRequest, GetApplicationResponse>()
                            .withOperationName("GetApplication").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetApplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getApplicationRequest));
            CompletableFuture<GetApplicationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about an application revision.
     * </p>
     *
     * @param getApplicationRevisionRequest
     *        Represents the input of a <code>GetApplicationRevision</code> operation.
     * @return A Java Future containing the result of the GetApplicationRevision operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationDoesNotExistException The application does not exist with the user or Amazon Web Services
     *         account.</li>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>RevisionDoesNotExistException The named revision does not exist with the user or Amazon Web Services
     *         account.</li>
     *         <li>RevisionRequiredException The revision ID was not specified.</li>
     *         <li>InvalidRevisionException The revision was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.GetApplicationRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetApplicationRevision"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetApplicationRevisionResponse> getApplicationRevision(
            GetApplicationRevisionRequest getApplicationRevisionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getApplicationRevisionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApplicationRevisionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApplicationRevision");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetApplicationRevisionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetApplicationRevisionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetApplicationRevisionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetApplicationRevisionRequest, GetApplicationRevisionResponse>()
                            .withOperationName("GetApplicationRevision").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetApplicationRevisionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getApplicationRevisionRequest));
            CompletableFuture<GetApplicationRevisionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a deployment.
     * </p>
     * <note>
     * <p>
     * The <code>content</code> property of the <code>appSpecContent</code> object in the returned revision is always
     * null. Use <code>GetApplicationRevision</code> and the <code>sha256</code> property of the returned
     * <code>appSpecContent</code> object to get the content of the deployment’s AppSpec file.
     * </p>
     * </note>
     *
     * @param getDeploymentRequest
     *        Represents the input of a <code>GetDeployment</code> operation.
     * @return A Java Future containing the result of the GetDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>DeploymentDoesNotExistException The deployment with the user or Amazon Web Services account does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.GetDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeploymentResponse> getDeployment(GetDeploymentRequest getDeploymentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDeploymentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeployment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetDeploymentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDeploymentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDeploymentRequest, GetDeploymentResponse>()
                            .withOperationName("GetDeployment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDeploymentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDeploymentRequest));
            CompletableFuture<GetDeploymentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a deployment configuration.
     * </p>
     *
     * @param getDeploymentConfigRequest
     *        Represents the input of a <code>GetDeploymentConfig</code> operation.
     * @return A Java Future containing the result of the GetDeploymentConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigNameRequiredException The deployment configuration name was not specified.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the user or
     *         Amazon Web Services account.</li>
     *         <li>InvalidComputePlatformException The computePlatform is invalid. The computePlatform should be
     *         <code>Lambda</code>, <code>Server</code>, or <code>ECS</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.GetDeploymentConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeploymentConfigResponse> getDeploymentConfig(
            GetDeploymentConfigRequest getDeploymentConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDeploymentConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeploymentConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeploymentConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDeploymentConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDeploymentConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDeploymentConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDeploymentConfigRequest, GetDeploymentConfigResponse>()
                            .withOperationName("GetDeploymentConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDeploymentConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDeploymentConfigRequest));
            CompletableFuture<GetDeploymentConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a deployment group.
     * </p>
     *
     * @param getDeploymentGroupRequest
     *        Represents the input of a <code>GetDeploymentGroup</code> operation.
     * @return A Java Future containing the result of the GetDeploymentGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the user or Amazon Web Services
     *         account.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group with the user or Amazon Web Services
     *         account does not exist.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the user or
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.GetDeploymentGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeploymentGroupResponse> getDeploymentGroup(GetDeploymentGroupRequest getDeploymentGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDeploymentGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeploymentGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeploymentGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDeploymentGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDeploymentGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDeploymentGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDeploymentGroupRequest, GetDeploymentGroupResponse>()
                            .withOperationName("GetDeploymentGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDeploymentGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDeploymentGroupRequest));
            CompletableFuture<GetDeploymentGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a deployment target.
     * </p>
     *
     * @param getDeploymentTargetRequest
     * @return A Java Future containing the result of the GetDeploymentTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment with the user or Amazon Web Services account does not
     *         exist.</li>
     *         <li>DeploymentNotStartedException The specified deployment has not started.</li>
     *         <li>DeploymentTargetIdRequiredException A deployment target ID was not provided.</li>
     *         <li>InvalidDeploymentTargetIdException The target ID provided was not valid.</li>
     *         <li>DeploymentTargetDoesNotExistException The provided target ID does not belong to the attempted
     *         deployment.</li>
     *         <li>InvalidInstanceNameException The on-premises instance name was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.GetDeploymentTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentTarget"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeploymentTargetResponse> getDeploymentTarget(
            GetDeploymentTargetRequest getDeploymentTargetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDeploymentTargetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeploymentTargetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeploymentTarget");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDeploymentTargetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDeploymentTargetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDeploymentTargetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDeploymentTargetRequest, GetDeploymentTargetResponse>()
                            .withOperationName("GetDeploymentTarget").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDeploymentTargetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDeploymentTargetRequest));
            CompletableFuture<GetDeploymentTargetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about an on-premises instance.
     * </p>
     *
     * @param getOnPremisesInstanceRequest
     *        Represents the input of a <code>GetOnPremisesInstance</code> operation.
     * @return A Java Future containing the result of the GetOnPremisesInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>InstanceNotRegisteredException The specified on-premises instance is not registered.</li>
     *         <li>InvalidInstanceNameException The on-premises instance name was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.GetOnPremisesInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetOnPremisesInstanceResponse> getOnPremisesInstance(
            GetOnPremisesInstanceRequest getOnPremisesInstanceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getOnPremisesInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOnPremisesInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOnPremisesInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetOnPremisesInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetOnPremisesInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetOnPremisesInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOnPremisesInstanceRequest, GetOnPremisesInstanceResponse>()
                            .withOperationName("GetOnPremisesInstance").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetOnPremisesInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getOnPremisesInstanceRequest));
            CompletableFuture<GetOnPremisesInstanceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists information about revisions for an application.
     * </p>
     *
     * @param listApplicationRevisionsRequest
     *        Represents the input of a <code>ListApplicationRevisions</code> operation.
     * @return A Java Future containing the result of the ListApplicationRevisions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationDoesNotExistException The application does not exist with the user or Amazon Web Services
     *         account.</li>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>InvalidSortByException The column name to sort by is either not present or was specified in an
     *         invalid format.</li>
     *         <li>InvalidSortOrderException The sort order was specified in an invalid format.</li>
     *         <li>InvalidBucketNameFilterException The bucket name either doesn't exist or was specified in an invalid
     *         format.</li>
     *         <li>InvalidKeyPrefixFilterException The specified key prefix filter was specified in an invalid format.</li>
     *         <li>BucketNameFilterRequiredException A bucket name is required, but was not provided.</li>
     *         <li>InvalidDeployedStateFilterException The deployed state filter was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListApplicationRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplicationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListApplicationRevisionsResponse> listApplicationRevisions(
            ListApplicationRevisionsRequest listApplicationRevisionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listApplicationRevisionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listApplicationRevisionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListApplicationRevisions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListApplicationRevisionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListApplicationRevisionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListApplicationRevisionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListApplicationRevisionsRequest, ListApplicationRevisionsResponse>()
                            .withOperationName("ListApplicationRevisions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListApplicationRevisionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listApplicationRevisionsRequest));
            CompletableFuture<ListApplicationRevisionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the applications registered with the user or Amazon Web Services account.
     * </p>
     *
     * @param listApplicationsRequest
     *        Represents the input of a <code>ListApplications</code> operation.
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListApplicationsResponse> listApplications(ListApplicationsRequest listApplicationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listApplicationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listApplicationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListApplications");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListApplicationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListApplicationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListApplicationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListApplicationsRequest, ListApplicationsResponse>()
                            .withOperationName("ListApplications").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListApplicationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listApplicationsRequest));
            CompletableFuture<ListApplicationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the deployment configurations with the user or Amazon Web Services account.
     * </p>
     *
     * @param listDeploymentConfigsRequest
     *        Represents the input of a <code>ListDeploymentConfigs</code> operation.
     * @return A Java Future containing the result of the ListDeploymentConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListDeploymentConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDeploymentConfigsResponse> listDeploymentConfigs(
            ListDeploymentConfigsRequest listDeploymentConfigsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDeploymentConfigsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDeploymentConfigsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDeploymentConfigs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDeploymentConfigsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDeploymentConfigsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDeploymentConfigsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDeploymentConfigsRequest, ListDeploymentConfigsResponse>()
                            .withOperationName("ListDeploymentConfigs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDeploymentConfigsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDeploymentConfigsRequest));
            CompletableFuture<ListDeploymentConfigsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the deployment groups for an application registered with the Amazon Web Services user or Amazon Web
     * Services account.
     * </p>
     *
     * @param listDeploymentGroupsRequest
     *        Represents the input of a <code>ListDeploymentGroups</code> operation.
     * @return A Java Future containing the result of the ListDeploymentGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the user or Amazon Web Services
     *         account.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListDeploymentGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDeploymentGroupsResponse> listDeploymentGroups(
            ListDeploymentGroupsRequest listDeploymentGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDeploymentGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDeploymentGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDeploymentGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDeploymentGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDeploymentGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDeploymentGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDeploymentGroupsRequest, ListDeploymentGroupsResponse>()
                            .withOperationName("ListDeploymentGroups").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDeploymentGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDeploymentGroupsRequest));
            CompletableFuture<ListDeploymentGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns an array of target IDs that are associated a deployment.
     * </p>
     *
     * @param listDeploymentTargetsRequest
     * @return A Java Future containing the result of the ListDeploymentTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment with the user or Amazon Web Services account does not
     *         exist.</li>
     *         <li>DeploymentNotStartedException The specified deployment has not started.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>InvalidInstanceStatusException The specified instance status does not exist.</li>
     *         <li>InvalidInstanceTypeException An invalid instance type was specified for instances in a blue/green
     *         deployment. Valid values include "Blue" for an original environment and "Green" for a replacement
     *         environment.</li>
     *         <li>InvalidDeploymentInstanceTypeException An instance type was specified for an in-place deployment.
     *         Instance types are supported for blue/green deployments only.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListDeploymentTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDeploymentTargetsResponse> listDeploymentTargets(
            ListDeploymentTargetsRequest listDeploymentTargetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDeploymentTargetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDeploymentTargetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDeploymentTargets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDeploymentTargetsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDeploymentTargetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDeploymentTargetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDeploymentTargetsRequest, ListDeploymentTargetsResponse>()
                            .withOperationName("ListDeploymentTargets").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDeploymentTargetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDeploymentTargetsRequest));
            CompletableFuture<ListDeploymentTargetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the deployments in a deployment group for an application registered with the user or Amazon Web Services
     * account.
     * </p>
     *
     * @param listDeploymentsRequest
     *        Represents the input of a <code>ListDeployments</code> operation.
     * @return A Java Future containing the result of the ListDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the user or Amazon Web Services
     *         account.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group with the user or Amazon Web Services
     *         account does not exist.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidTimeRangeException The specified time range was specified in an invalid format.</li>
     *         <li>InvalidDeploymentStatusException The specified deployment status doesn't exist or cannot be
     *         determined.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>InvalidExternalIdException The external ID was specified in an invalid format.</li>
     *         <li>InvalidInputException The input was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDeploymentsResponse> listDeployments(ListDeploymentsRequest listDeploymentsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDeploymentsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDeploymentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDeployments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDeploymentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDeploymentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDeploymentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDeploymentsRequest, ListDeploymentsResponse>()
                            .withOperationName("ListDeployments").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDeploymentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDeploymentsRequest));
            CompletableFuture<ListDeploymentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the names of stored connections to GitHub accounts.
     * </p>
     *
     * @param listGitHubAccountTokenNamesRequest
     *        Represents the input of a <code>ListGitHubAccountTokenNames</code> operation.
     * @return A Java Future containing the result of the ListGitHubAccountTokenNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>ResourceValidationException The specified resource could not be validated.</li>
     *         <li>OperationNotSupportedException The API used does not support the deployment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListGitHubAccountTokenNames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListGitHubAccountTokenNames"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListGitHubAccountTokenNamesResponse> listGitHubAccountTokenNames(
            ListGitHubAccountTokenNamesRequest listGitHubAccountTokenNamesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGitHubAccountTokenNamesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGitHubAccountTokenNamesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGitHubAccountTokenNames");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGitHubAccountTokenNamesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListGitHubAccountTokenNamesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListGitHubAccountTokenNamesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGitHubAccountTokenNamesRequest, ListGitHubAccountTokenNamesResponse>()
                            .withOperationName("ListGitHubAccountTokenNames").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListGitHubAccountTokenNamesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listGitHubAccountTokenNamesRequest));
            CompletableFuture<ListGitHubAccountTokenNamesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of names for one or more on-premises instances.
     * </p>
     * <p>
     * Unless otherwise specified, both registered and deregistered on-premises instance names are listed. To list only
     * registered or deregistered on-premises instance names, use the registration status parameter.
     * </p>
     *
     * @param listOnPremisesInstancesRequest
     *        Represents the input of a <code>ListOnPremisesInstances</code> operation.
     * @return A Java Future containing the result of the ListOnPremisesInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRegistrationStatusException The registration status was specified in an invalid format.</li>
     *         <li>InvalidTagFilterException The tag filter was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListOnPremisesInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListOnPremisesInstancesResponse> listOnPremisesInstances(
            ListOnPremisesInstancesRequest listOnPremisesInstancesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listOnPremisesInstancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOnPremisesInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOnPremisesInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListOnPremisesInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListOnPremisesInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListOnPremisesInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListOnPremisesInstancesRequest, ListOnPremisesInstancesResponse>()
                            .withOperationName("ListOnPremisesInstances").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListOnPremisesInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listOnPremisesInstancesRequest));
            CompletableFuture<ListOnPremisesInstancesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of tags for the resource identified by a specified Amazon Resource Name (ARN). Tags are used to
     * organize and categorize your CodeDeploy resources.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArnNotSupportedException The specified ARN is not supported. For example, it might be an ARN for a
     *         resource that is not expected.</li>
     *         <li>InvalidArnException The specified ARN is not in a valid format.</li>
     *         <li>ResourceArnRequiredException The ARN of a resource is required, but was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the result of a Lambda validation function. The function validates lifecycle hooks during a deployment that
     * uses the Lambda or Amazon ECS compute platform. For Lambda deployments, the available lifecycle hooks are
     * <code>BeforeAllowTraffic</code> and <code>AfterAllowTraffic</code>. For Amazon ECS deployments, the available
     * lifecycle hooks are <code>BeforeInstall</code>, <code>AfterInstall</code>, <code>AfterAllowTestTraffic</code>,
     * <code>BeforeAllowTraffic</code>, and <code>AfterAllowTraffic</code>. Lambda validation functions return
     * <code>Succeeded</code> or <code>Failed</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-lambda"
     * >AppSpec 'hooks' Section for an Lambda Deployment </a> and <a href=
     * "https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-ecs"
     * >AppSpec 'hooks' Section for an Amazon ECS Deployment</a>.
     * </p>
     *
     * @param putLifecycleEventHookExecutionStatusRequest
     * @return A Java Future containing the result of the PutLifecycleEventHookExecutionStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidLifecycleEventHookExecutionStatusException The result of a Lambda validation function that
     *         verifies a lifecycle event is invalid. It should return <code>Succeeded</code> or <code>Failed</code>.</li>
     *         <li>InvalidLifecycleEventHookExecutionIdException A lifecycle event hook is invalid. Review the
     *         <code>hooks</code> section in your AppSpec file to ensure the lifecycle events and <code>hooks</code>
     *         functions are valid.</li>
     *         <li>LifecycleEventAlreadyCompletedException An attempt to return the status of an already completed
     *         lifecycle event occurred.</li>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment with the user or Amazon Web Services account does not
     *         exist.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>UnsupportedActionForDeploymentTypeException A call was submitted that is not supported for the
     *         specified deployment type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.PutLifecycleEventHookExecutionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/PutLifecycleEventHookExecutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutLifecycleEventHookExecutionStatusResponse> putLifecycleEventHookExecutionStatus(
            PutLifecycleEventHookExecutionStatusRequest putLifecycleEventHookExecutionStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putLifecycleEventHookExecutionStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putLifecycleEventHookExecutionStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutLifecycleEventHookExecutionStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutLifecycleEventHookExecutionStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, PutLifecycleEventHookExecutionStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutLifecycleEventHookExecutionStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutLifecycleEventHookExecutionStatusRequest, PutLifecycleEventHookExecutionStatusResponse>()
                            .withOperationName("PutLifecycleEventHookExecutionStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutLifecycleEventHookExecutionStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putLifecycleEventHookExecutionStatusRequest));
            CompletableFuture<PutLifecycleEventHookExecutionStatusResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers with CodeDeploy a revision for the specified application.
     * </p>
     *
     * @param registerApplicationRevisionRequest
     *        Represents the input of a RegisterApplicationRevision operation.
     * @return A Java Future containing the result of the RegisterApplicationRevision operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationDoesNotExistException The application does not exist with the user or Amazon Web Services
     *         account.</li>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>DescriptionTooLongException The description is too long.</li>
     *         <li>RevisionRequiredException The revision ID was not specified.</li>
     *         <li>InvalidRevisionException The revision was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.RegisterApplicationRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RegisterApplicationRevision"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterApplicationRevisionResponse> registerApplicationRevision(
            RegisterApplicationRevisionRequest registerApplicationRevisionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(registerApplicationRevisionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerApplicationRevisionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterApplicationRevision");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RegisterApplicationRevisionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RegisterApplicationRevisionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RegisterApplicationRevisionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RegisterApplicationRevisionRequest, RegisterApplicationRevisionResponse>()
                            .withOperationName("RegisterApplicationRevision").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RegisterApplicationRevisionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(registerApplicationRevisionRequest));
            CompletableFuture<RegisterApplicationRevisionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers an on-premises instance.
     * </p>
     * <note>
     * <p>
     * Only one IAM ARN (an IAM session ARN or IAM user ARN) is supported in the request. You cannot use both.
     * </p>
     * </note>
     *
     * @param registerOnPremisesInstanceRequest
     *        Represents the input of the register on-premises instance operation.
     * @return A Java Future containing the result of the RegisterOnPremisesInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameAlreadyRegisteredException The specified on-premises instance name is already registered.
     *         </li>
     *         <li>IamArnRequiredException No IAM ARN was included in the request. You must use an IAM session ARN or
     *         user ARN in the request.</li>
     *         <li>IamSessionArnAlreadyRegisteredException The request included an IAM session ARN that has already been
     *         used to register a different instance.</li>
     *         <li>IamUserArnAlreadyRegisteredException The specified user ARN is already registered with an on-premises
     *         instance.</li>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>IamUserArnRequiredException An user ARN was not specified.</li>
     *         <li>InvalidInstanceNameException The on-premises instance name was specified in an invalid format.</li>
     *         <li>InvalidIamSessionArnException The IAM session ARN was specified in an invalid format.</li>
     *         <li>InvalidIamUserArnException The user ARN was specified in an invalid format.</li>
     *         <li>MultipleIamArnsProvidedException Both an user ARN and an IAM session ARN were included in the
     *         request. Use only one ARN type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.RegisterOnPremisesInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RegisterOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterOnPremisesInstanceResponse> registerOnPremisesInstance(
            RegisterOnPremisesInstanceRequest registerOnPremisesInstanceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(registerOnPremisesInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerOnPremisesInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterOnPremisesInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RegisterOnPremisesInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RegisterOnPremisesInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RegisterOnPremisesInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RegisterOnPremisesInstanceRequest, RegisterOnPremisesInstanceResponse>()
                            .withOperationName("RegisterOnPremisesInstance").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RegisterOnPremisesInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(registerOnPremisesInstanceRequest));
            CompletableFuture<RegisterOnPremisesInstanceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes one or more tags from one or more on-premises instances.
     * </p>
     *
     * @param removeTagsFromOnPremisesInstancesRequest
     *        Represents the input of a <code>RemoveTagsFromOnPremisesInstances</code> operation.
     * @return A Java Future containing the result of the RemoveTagsFromOnPremisesInstances operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>InvalidInstanceNameException The on-premises instance name was specified in an invalid format.</li>
     *         <li>TagRequiredException A tag was not specified.</li>
     *         <li>InvalidTagException The tag was specified in an invalid format.</li>
     *         <li>TagLimitExceededException The maximum allowed number of tags was exceeded.</li>
     *         <li>InstanceLimitExceededException The maximum number of allowed on-premises instances in a single call
     *         was exceeded.</li>
     *         <li>InstanceNotRegisteredException The specified on-premises instance is not registered.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.RemoveTagsFromOnPremisesInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RemoveTagsFromOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveTagsFromOnPremisesInstancesResponse> removeTagsFromOnPremisesInstances(
            RemoveTagsFromOnPremisesInstancesRequest removeTagsFromOnPremisesInstancesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeTagsFromOnPremisesInstancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                removeTagsFromOnPremisesInstancesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveTagsFromOnPremisesInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RemoveTagsFromOnPremisesInstancesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, RemoveTagsFromOnPremisesInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RemoveTagsFromOnPremisesInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveTagsFromOnPremisesInstancesRequest, RemoveTagsFromOnPremisesInstancesResponse>()
                            .withOperationName("RemoveTagsFromOnPremisesInstances").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RemoveTagsFromOnPremisesInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(removeTagsFromOnPremisesInstancesRequest));
            CompletableFuture<RemoveTagsFromOnPremisesInstancesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attempts to stop an ongoing deployment.
     * </p>
     *
     * @param stopDeploymentRequest
     *        Represents the input of a <code>StopDeployment</code> operation.
     * @return A Java Future containing the result of the StopDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment with the user or Amazon Web Services account does not
     *         exist.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group with the user or Amazon Web Services
     *         account does not exist.</li>
     *         <li>DeploymentAlreadyCompletedException The deployment is already complete.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>UnsupportedActionForDeploymentTypeException A call was submitted that is not supported for the
     *         specified deployment type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.StopDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/StopDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StopDeploymentResponse> stopDeployment(StopDeploymentRequest stopDeploymentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopDeploymentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopDeployment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopDeploymentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopDeploymentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopDeploymentRequest, StopDeploymentResponse>()
                            .withOperationName("StopDeployment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopDeploymentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopDeploymentRequest));
            CompletableFuture<StopDeploymentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates the list of tags in the input <code>Tags</code> parameter with the resource identified by the
     * <code>ResourceArn</code> input parameter.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceArnRequiredException The ARN of a resource is required, but was not found.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the user or Amazon Web Services
     *         account.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group with the user or Amazon Web Services
     *         account does not exist.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the user or
     *         Amazon Web Services account.</li>
     *         <li>TagRequiredException A tag was not specified.</li>
     *         <li>InvalidTagsToAddException The specified tags are not valid.</li>
     *         <li>ArnNotSupportedException The specified ARN is not supported. For example, it might be an ARN for a
     *         resource that is not expected.</li>
     *         <li>InvalidArnException The specified ARN is not in a valid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a resource from a list of tags. The resource is identified by the <code>ResourceArn</code> input
     * parameter. The tags are identified by the list of keys in the <code>TagKeys</code> input parameter.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceArnRequiredException The ARN of a resource is required, but was not found.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the user or Amazon Web Services
     *         account.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group with the user or Amazon Web Services
     *         account does not exist.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the user or
     *         Amazon Web Services account.</li>
     *         <li>TagRequiredException A tag was not specified.</li>
     *         <li>InvalidTagsToAddException The specified tags are not valid.</li>
     *         <li>ArnNotSupportedException The specified ARN is not supported. For example, it might be an ARN for a
     *         resource that is not expected.</li>
     *         <li>InvalidArnException The specified ARN is not in a valid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes the name of an application.
     * </p>
     *
     * @param updateApplicationRequest
     *        Represents the input of an <code>UpdateApplication</code> operation.
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationAlreadyExistsException An application with the specified name with the user or Amazon Web
     *         Services account already exists.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the user or Amazon Web Services
     *         account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UpdateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest updateApplicationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateApplicationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateApplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateApplicationRequest, UpdateApplicationResponse>()
                            .withOperationName("UpdateApplication").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateApplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateApplicationRequest));
            CompletableFuture<UpdateApplicationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes information about a deployment group.
     * </p>
     *
     * @param updateDeploymentGroupRequest
     *        Represents the input of an <code>UpdateDeploymentGroup</code> operation.
     * @return A Java Future containing the result of the UpdateDeploymentGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the user or Amazon Web Services
     *         account.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupAlreadyExistsException A deployment group with the specified name with the user or
     *         Amazon Web Services account already exists.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group with the user or Amazon Web Services
     *         account does not exist.</li>
     *         <li>InvalidEc2TagException The tag was specified in an invalid format.</li>
     *         <li>InvalidTagException The tag was specified in an invalid format.</li>
     *         <li>InvalidAutoScalingGroupException The Auto Scaling group was specified in an invalid format or does
     *         not exist.</li>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the user or
     *         Amazon Web Services account.</li>
     *         <li>InvalidRoleException The service role ARN was specified in an invalid format. Or, if an Auto Scaling
     *         group was specified, the specified service role does not grant the appropriate permissions to Amazon EC2
     *         Auto Scaling.</li>
     *         <li>LifecycleHookLimitExceededException The limit for lifecycle hooks was exceeded.</li>
     *         <li>InvalidTriggerConfigException The trigger was specified in an invalid format.</li>
     *         <li>TriggerTargetsLimitExceededException The maximum allowed number of triggers was exceeded.</li>
     *         <li>InvalidAlarmConfigException The format of the alarm configuration is invalid. Possible causes
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The alarm list is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm object is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm name is empty or null or exceeds the limit of 255 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Two alarms with the same name have been specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm configuration is enabled, but the alarm list is empty.
     *         </p>
     *         </li></li>
     *         <li>AlarmsLimitExceededException The maximum number of alarms for a deployment group (10) was exceeded.</li>
     *         <li>InvalidAutoRollbackConfigException The automatic rollback configuration was specified in an invalid
     *         format. For example, automatic rollback is enabled, but an invalid triggering event type or no event
     *         types were listed.</li>
     *         <li>InvalidLoadBalancerInfoException An invalid load balancer name, or no load balancer name, was
     *         specified.</li>
     *         <li>InvalidDeploymentStyleException An invalid deployment style was specified. Valid deployment types
     *         include "IN_PLACE" and "BLUE_GREEN." Valid deployment options include "WITH_TRAFFIC_CONTROL" and
     *         "WITHOUT_TRAFFIC_CONTROL."</li>
     *         <li>InvalidBlueGreenDeploymentConfigurationException The configuration for the blue/green deployment
     *         group was provided in an invalid format. For information about deployment configuration format, see
     *         <a>CreateDeploymentConfig</a>.</li>
     *         <li>InvalidEc2TagCombinationException A call was submitted that specified both Ec2TagFilters and
     *         Ec2TagSet, but only one of these data types can be used in a single call.</li>
     *         <li>InvalidOnPremisesTagCombinationException A call was submitted that specified both
     *         OnPremisesTagFilters and OnPremisesTagSet, but only one of these data types can be used in a single call.
     *         </li>
     *         <li>TagSetListLimitExceededException The number of tag groups included in the tag set list exceeded the
     *         maximum allowed limit of 3.</li>
     *         <li>InvalidInputException The input was specified in an invalid format.</li>
     *         <li>ThrottlingException An API function was called too frequently.</li>
     *         <li>InvalidEcsServiceException The Amazon ECS service identifier is not valid.</li>
     *         <li>InvalidTargetGroupPairException A target group pair associated with this deployment is not valid.</li>
     *         <li>EcsServiceMappingLimitExceededException The Amazon ECS service is associated with more than one
     *         deployment groups. An Amazon ECS service can be associated with only one deployment group.</li>
     *         <li>InvalidTrafficRoutingConfigurationException The configuration that specifies how traffic is routed
     *         during a deployment is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.UpdateDeploymentGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UpdateDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDeploymentGroupResponse> updateDeploymentGroup(
            UpdateDeploymentGroupRequest updateDeploymentGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDeploymentGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDeploymentGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDeploymentGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDeploymentGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDeploymentGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDeploymentGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDeploymentGroupRequest, UpdateDeploymentGroupResponse>()
                            .withOperationName("UpdateDeploymentGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateDeploymentGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateDeploymentGroupRequest));
            CompletableFuture<UpdateDeploymentGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CodeDeployAsyncWaiter waiter() {
        return CodeDeployAsyncWaiter.builder().client(this).scheduledExecutorService(executorService).build();
    }

    @Override
    public final CodeDeployServiceClientConfiguration serviceClientConfiguration() {
        return new CodeDeployServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(CodeDeployException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceValidationException")
                                .exceptionBuilderSupplier(ResourceValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                                .exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOperationException")
                                .exceptionBuilderSupplier(InvalidOperationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTagsToAddException")
                                .exceptionBuilderSupplier(InvalidTagsToAddException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException")
                                .exceptionBuilderSupplier(TagSetListLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                                .exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException")
                                .exceptionBuilderSupplier(ApplicationNameRequiredException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                                .exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                                .exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException")
                                .exceptionBuilderSupplier(DeploymentLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidECSServiceException")
                                .exceptionBuilderSupplier(InvalidEcsServiceException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidArnException")
                                .exceptionBuilderSupplier(InvalidArnException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTagFilterException")
                                .exceptionBuilderSupplier(InvalidTagFilterException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                                .exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceArnRequiredException")
                                .exceptionBuilderSupplier(ResourceArnRequiredException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OperationNotSupportedException")
                                .exceptionBuilderSupplier(OperationNotSupportedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                                .exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                                .exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                                .exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException")
                                .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidNextTokenException")
                                .exceptionBuilderSupplier(InvalidNextTokenException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                                .exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                                .exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                                .exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException")
                                .exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException")
                                .exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidEC2TagException")
                                .exceptionBuilderSupplier(InvalidEc2TagException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                                .exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                                .exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                                .exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RevisionRequiredException")
                                .exceptionBuilderSupplier(RevisionRequiredException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                                .exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                                .exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException")
                                .exceptionBuilderSupplier(InstanceNotRegisteredException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                                .exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException")
                                .exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                                .exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                                .exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException")
                                .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DescriptionTooLongException")
                                .exceptionBuilderSupplier(DescriptionTooLongException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException")
                                .exceptionBuilderSupplier(InvalidInstanceStatusException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InstanceLimitExceededException")
                                .exceptionBuilderSupplier(InstanceLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException")
                                .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidIgnoreApplicationStopFailuresValueException")
                                .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                                .exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException")
                                .exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException")
                                .exceptionBuilderSupplier(ApplicationLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                                .exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                                .exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidExternalIdException")
                                .exceptionBuilderSupplier(InvalidExternalIdException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                                .exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                                .exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                                .exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BatchLimitExceededException")
                                .exceptionBuilderSupplier(BatchLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException")
                                .exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException")
                                .exceptionBuilderSupplier(InvalidTargetInstancesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TagRequiredException")
                                .exceptionBuilderSupplier(TagRequiredException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException")
                                .exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidIamUserArnException")
                                .exceptionBuilderSupplier(InvalidIamUserArnException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException")
                                .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException")
                                .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IamArnRequiredException")
                                .exceptionBuilderSupplier(IamArnRequiredException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException")
                                .exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                                .exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException")
                                .exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidComputePlatformException")
                                .exceptionBuilderSupplier(InvalidComputePlatformException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RoleRequiredException")
                                .exceptionBuilderSupplier(RoleRequiredException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeploymentNotStartedException")
                                .exceptionBuilderSupplier(DeploymentNotStartedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                                .exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException")
                                .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                                .exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                                .exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InstanceNameRequiredException")
                                .exceptionBuilderSupplier(InstanceNameRequiredException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                                .exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRevisionException")
                                .exceptionBuilderSupplier(InvalidRevisionException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IamUserArnRequiredException")
                                .exceptionBuilderSupplier(IamUserArnRequiredException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                                .exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException")
                                .exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException")
                                .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ArnNotSupportedException")
                                .exceptionBuilderSupplier(ArnNotSupportedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                                .exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException")
                                .exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidInstanceNameException")
                                .exceptionBuilderSupplier(InvalidInstanceNameException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException")
                                .exceptionBuilderSupplier(DeploymentConfigInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                                .exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                                .exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                                .exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTagException")
                                .exceptionBuilderSupplier(InvalidTagException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidApplicationNameException")
                                .exceptionBuilderSupplier(InvalidApplicationNameException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException")
                                .exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTimeRangeException")
                                .exceptionBuilderSupplier(InvalidTimeRangeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidInputException")
                                .exceptionBuilderSupplier(InvalidInputException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSortByException")
                                .exceptionBuilderSupplier(InvalidSortByException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                                .exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException")
                                .exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSortOrderException")
                                .exceptionBuilderSupplier(InvalidSortOrderException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                                .exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException")
                                .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRoleException")
                                .exceptionBuilderSupplier(InvalidRoleException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                                .exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                                .exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TagLimitExceededException")
                                .exceptionBuilderSupplier(TagLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                                .exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException")
                                .exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                                .exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                                .httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        CodeDeployServiceClientConfigurationBuilder serviceConfigBuilder = new CodeDeployServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
