/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RevisionLocationType {
    S3("S3"),
    GIT_HUB("GitHub"),
    STRING("String"),
    APP_SPEC_CONTENT("AppSpecContent"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RevisionLocationType> VALUE_MAP;
    private final String value;

    private RevisionLocationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RevisionLocationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RevisionLocationType> knownValues() {
        EnumSet<RevisionLocationType> knownValues = EnumSet.allOf(RevisionLocationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RevisionLocationType.class, RevisionLocationType::toString);
    }
}

