/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OutdatedInstancesStrategy {
    UPDATE("UPDATE"),
    IGNORE("IGNORE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OutdatedInstancesStrategy> VALUE_MAP;
    private final String value;

    private OutdatedInstancesStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OutdatedInstancesStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OutdatedInstancesStrategy> knownValues() {
        EnumSet<OutdatedInstancesStrategy> knownValues = EnumSet.allOf(OutdatedInstancesStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OutdatedInstancesStrategy.class, OutdatedInstancesStrategy::toString);
    }
}

