/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>StopDeployment</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopDeploymentRequest extends CodeDeployRequest implements
        ToCopyableBuilder<StopDeploymentRequest.Builder, StopDeploymentRequest> {
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentId").getter(getter(StopDeploymentRequest::deploymentId)).setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()).build();

    private static final SdkField<Boolean> AUTO_ROLLBACK_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("autoRollbackEnabled").getter(getter(StopDeploymentRequest::autoRollbackEnabled))
            .setter(setter(Builder::autoRollbackEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoRollbackEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ID_FIELD,
            AUTO_ROLLBACK_ENABLED_FIELD));

    private final String deploymentId;

    private final Boolean autoRollbackEnabled;

    private StopDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentId = builder.deploymentId;
        this.autoRollbackEnabled = builder.autoRollbackEnabled;
    }

    /**
     * <p>
     * The unique ID of a deployment.
     * </p>
     * 
     * @return The unique ID of a deployment.
     */
    public final String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * Indicates, when a deployment is stopped, whether instances that have been updated should be rolled back to the
     * previous version of the application revision.
     * </p>
     * 
     * @return Indicates, when a deployment is stopped, whether instances that have been updated should be rolled back
     *         to the previous version of the application revision.
     */
    public final Boolean autoRollbackEnabled() {
        return autoRollbackEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(autoRollbackEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopDeploymentRequest)) {
            return false;
        }
        StopDeploymentRequest other = (StopDeploymentRequest) obj;
        return Objects.equals(deploymentId(), other.deploymentId())
                && Objects.equals(autoRollbackEnabled(), other.autoRollbackEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopDeploymentRequest").add("DeploymentId", deploymentId())
                .add("AutoRollbackEnabled", autoRollbackEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "autoRollbackEnabled":
            return Optional.ofNullable(clazz.cast(autoRollbackEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopDeploymentRequest, T> g) {
        return obj -> g.apply((StopDeploymentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployRequest.Builder, SdkPojo, CopyableBuilder<Builder, StopDeploymentRequest> {
        /**
         * <p>
         * The unique ID of a deployment.
         * </p>
         * 
         * @param deploymentId
         *        The unique ID of a deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * Indicates, when a deployment is stopped, whether instances that have been updated should be rolled back to
         * the previous version of the application revision.
         * </p>
         * 
         * @param autoRollbackEnabled
         *        Indicates, when a deployment is stopped, whether instances that have been updated should be rolled
         *        back to the previous version of the application revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRollbackEnabled(Boolean autoRollbackEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeDeployRequest.BuilderImpl implements Builder {
        private String deploymentId;

        private Boolean autoRollbackEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(StopDeploymentRequest model) {
            super(model);
            deploymentId(model.deploymentId);
            autoRollbackEnabled(model.autoRollbackEnabled);
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final Boolean getAutoRollbackEnabled() {
            return autoRollbackEnabled;
        }

        public final void setAutoRollbackEnabled(Boolean autoRollbackEnabled) {
            this.autoRollbackEnabled = autoRollbackEnabled;
        }

        @Override
        public final Builder autoRollbackEnabled(Boolean autoRollbackEnabled) {
            this.autoRollbackEnabled = autoRollbackEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopDeploymentRequest build() {
            return new StopDeploymentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
