/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecommit.CodeCommitAsyncClient;
import software.amazon.awssdk.services.codecommit.internal.UserAgentUtils;
import software.amazon.awssdk.services.codecommit.model.GetCommentReactionsRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentReactionsResponse;

public class GetCommentReactionsPublisher
implements SdkPublisher<GetCommentReactionsResponse> {
    private final CodeCommitAsyncClient client;
    private final GetCommentReactionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetCommentReactionsPublisher(CodeCommitAsyncClient client, GetCommentReactionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetCommentReactionsPublisher(CodeCommitAsyncClient client, GetCommentReactionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetCommentReactionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetCommentReactionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetCommentReactionsResponseFetcher
    implements AsyncPageFetcher<GetCommentReactionsResponse> {
        private GetCommentReactionsResponseFetcher() {
        }

        public boolean hasNextPage(GetCommentReactionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetCommentReactionsResponse> nextPage(GetCommentReactionsResponse previousPage) {
            if (previousPage == null) {
                return GetCommentReactionsPublisher.this.client.getCommentReactions(GetCommentReactionsPublisher.this.firstRequest);
            }
            return GetCommentReactionsPublisher.this.client.getCommentReactions((GetCommentReactionsRequest)((Object)GetCommentReactionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

