/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceFileSpecifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceFileSpecifier> {
    private static final SdkField<String> FILE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filePath").getter(SourceFileSpecifier.getter(SourceFileSpecifier::filePath)).setter(SourceFileSpecifier.setter(Builder::filePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()}).build();
    private static final SdkField<Boolean> IS_MOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isMove").getter(SourceFileSpecifier.getter(SourceFileSpecifier::isMove)).setter(SourceFileSpecifier.setter(Builder::isMove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isMove").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_PATH_FIELD, IS_MOVE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String filePath;
    private final Boolean isMove;

    private SourceFileSpecifier(BuilderImpl builder) {
        this.filePath = builder.filePath;
        this.isMove = builder.isMove;
    }

    public final String filePath() {
        return this.filePath;
    }

    public final Boolean isMove() {
        return this.isMove;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.isMove());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceFileSpecifier)) {
            return false;
        }
        SourceFileSpecifier other = (SourceFileSpecifier)obj;
        return Objects.equals(this.filePath(), other.filePath()) && Objects.equals(this.isMove(), other.isMove());
    }

    public final String toString() {
        return ToString.builder((String)"SourceFileSpecifier").add("FilePath", (Object)this.filePath()).add("IsMove", (Object)this.isMove()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filePath": {
                return Optional.ofNullable(clazz.cast(this.filePath()));
            }
            case "isMove": {
                return Optional.ofNullable(clazz.cast(this.isMove()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceFileSpecifier, T> g) {
        return obj -> g.apply((SourceFileSpecifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filePath;
        private Boolean isMove;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceFileSpecifier model) {
            this.filePath(model.filePath);
            this.isMove(model.isMove);
        }

        public final String getFilePath() {
            return this.filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final Boolean getIsMove() {
            return this.isMove;
        }

        public final void setIsMove(Boolean isMove) {
            this.isMove = isMove;
        }

        @Override
        public final Builder isMove(Boolean isMove) {
            this.isMove = isMove;
            return this;
        }

        public SourceFileSpecifier build() {
            return new SourceFileSpecifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceFileSpecifier> {
        public Builder filePath(String var1);

        public Builder isMove(Boolean var1);
    }
}

