/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RepositoryMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RepositoryMetadata> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(RepositoryMetadata.getter(RepositoryMetadata::accountId)).setter(RepositoryMetadata.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> REPOSITORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryId").getter(RepositoryMetadata.getter(RepositoryMetadata::repositoryId)).setter(RepositoryMetadata.setter(Builder::repositoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryId").build()}).build();
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(RepositoryMetadata.getter(RepositoryMetadata::repositoryName)).setter(RepositoryMetadata.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> REPOSITORY_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryDescription").getter(RepositoryMetadata.getter(RepositoryMetadata::repositoryDescription)).setter(RepositoryMetadata.setter(Builder::repositoryDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryDescription").build()}).build();
    private static final SdkField<String> DEFAULT_BRANCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultBranch").getter(RepositoryMetadata.getter(RepositoryMetadata::defaultBranch)).setter(RepositoryMetadata.setter(Builder::defaultBranch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultBranch").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedDate").getter(RepositoryMetadata.getter(RepositoryMetadata::lastModifiedDate)).setter(RepositoryMetadata.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(RepositoryMetadata.getter(RepositoryMetadata::creationDate)).setter(RepositoryMetadata.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<String> CLONE_URL_HTTP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cloneUrlHttp").getter(RepositoryMetadata.getter(RepositoryMetadata::cloneUrlHttp)).setter(RepositoryMetadata.setter(Builder::cloneUrlHttp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloneUrlHttp").build()}).build();
    private static final SdkField<String> CLONE_URL_SSH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cloneUrlSsh").getter(RepositoryMetadata.getter(RepositoryMetadata::cloneUrlSsh)).setter(RepositoryMetadata.setter(Builder::cloneUrlSsh)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloneUrlSsh").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(RepositoryMetadata.getter(RepositoryMetadata::arn)).setter(RepositoryMetadata.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, REPOSITORY_ID_FIELD, REPOSITORY_NAME_FIELD, REPOSITORY_DESCRIPTION_FIELD, DEFAULT_BRANCH_FIELD, LAST_MODIFIED_DATE_FIELD, CREATION_DATE_FIELD, CLONE_URL_HTTP_FIELD, CLONE_URL_SSH_FIELD, ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String repositoryId;
    private final String repositoryName;
    private final String repositoryDescription;
    private final String defaultBranch;
    private final Instant lastModifiedDate;
    private final Instant creationDate;
    private final String cloneUrlHttp;
    private final String cloneUrlSsh;
    private final String arn;

    private RepositoryMetadata(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.repositoryId = builder.repositoryId;
        this.repositoryName = builder.repositoryName;
        this.repositoryDescription = builder.repositoryDescription;
        this.defaultBranch = builder.defaultBranch;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.creationDate = builder.creationDate;
        this.cloneUrlHttp = builder.cloneUrlHttp;
        this.cloneUrlSsh = builder.cloneUrlSsh;
        this.arn = builder.arn;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String repositoryId() {
        return this.repositoryId;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final String repositoryDescription() {
        return this.repositoryDescription;
    }

    public final String defaultBranch() {
        return this.defaultBranch;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final String cloneUrlHttp() {
        return this.cloneUrlHttp;
    }

    public final String cloneUrlSsh() {
        return this.cloneUrlSsh;
    }

    public final String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultBranch());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloneUrlHttp());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloneUrlSsh());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryMetadata)) {
            return false;
        }
        RepositoryMetadata other = (RepositoryMetadata)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.repositoryId(), other.repositoryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.repositoryDescription(), other.repositoryDescription()) && Objects.equals(this.defaultBranch(), other.defaultBranch()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.cloneUrlHttp(), other.cloneUrlHttp()) && Objects.equals(this.cloneUrlSsh(), other.cloneUrlSsh()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"RepositoryMetadata").add("AccountId", (Object)this.accountId()).add("RepositoryId", (Object)this.repositoryId()).add("RepositoryName", (Object)this.repositoryName()).add("RepositoryDescription", (Object)this.repositoryDescription()).add("DefaultBranch", (Object)this.defaultBranch()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("CreationDate", (Object)this.creationDate()).add("CloneUrlHttp", (Object)this.cloneUrlHttp()).add("CloneUrlSsh", (Object)this.cloneUrlSsh()).add("Arn", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "repositoryId": {
                return Optional.ofNullable(clazz.cast(this.repositoryId()));
            }
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "repositoryDescription": {
                return Optional.ofNullable(clazz.cast(this.repositoryDescription()));
            }
            case "defaultBranch": {
                return Optional.ofNullable(clazz.cast(this.defaultBranch()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "cloneUrlHttp": {
                return Optional.ofNullable(clazz.cast(this.cloneUrlHttp()));
            }
            case "cloneUrlSsh": {
                return Optional.ofNullable(clazz.cast(this.cloneUrlSsh()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RepositoryMetadata, T> g) {
        return obj -> g.apply((RepositoryMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String repositoryId;
        private String repositoryName;
        private String repositoryDescription;
        private String defaultBranch;
        private Instant lastModifiedDate;
        private Instant creationDate;
        private String cloneUrlHttp;
        private String cloneUrlSsh;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryMetadata model) {
            this.accountId(model.accountId);
            this.repositoryId(model.repositoryId);
            this.repositoryName(model.repositoryName);
            this.repositoryDescription(model.repositoryDescription);
            this.defaultBranch(model.defaultBranch);
            this.lastModifiedDate(model.lastModifiedDate);
            this.creationDate(model.creationDate);
            this.cloneUrlHttp(model.cloneUrlHttp);
            this.cloneUrlSsh(model.cloneUrlSsh);
            this.arn(model.arn);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getRepositoryId() {
            return this.repositoryId;
        }

        public final void setRepositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
        }

        @Override
        public final Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getRepositoryDescription() {
            return this.repositoryDescription;
        }

        public final void setRepositoryDescription(String repositoryDescription) {
            this.repositoryDescription = repositoryDescription;
        }

        @Override
        public final Builder repositoryDescription(String repositoryDescription) {
            this.repositoryDescription = repositoryDescription;
            return this;
        }

        public final String getDefaultBranch() {
            return this.defaultBranch;
        }

        public final void setDefaultBranch(String defaultBranch) {
            this.defaultBranch = defaultBranch;
        }

        @Override
        public final Builder defaultBranch(String defaultBranch) {
            this.defaultBranch = defaultBranch;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getCloneUrlHttp() {
            return this.cloneUrlHttp;
        }

        public final void setCloneUrlHttp(String cloneUrlHttp) {
            this.cloneUrlHttp = cloneUrlHttp;
        }

        @Override
        public final Builder cloneUrlHttp(String cloneUrlHttp) {
            this.cloneUrlHttp = cloneUrlHttp;
            return this;
        }

        public final String getCloneUrlSsh() {
            return this.cloneUrlSsh;
        }

        public final void setCloneUrlSsh(String cloneUrlSsh) {
            this.cloneUrlSsh = cloneUrlSsh;
        }

        @Override
        public final Builder cloneUrlSsh(String cloneUrlSsh) {
            this.cloneUrlSsh = cloneUrlSsh;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public RepositoryMetadata build() {
            return new RepositoryMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RepositoryMetadata> {
        public Builder accountId(String var1);

        public Builder repositoryId(String var1);

        public Builder repositoryName(String var1);

        public Builder repositoryDescription(String var1);

        public Builder defaultBranch(String var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder creationDate(Instant var1);

        public Builder cloneUrlHttp(String var1);

        public Builder cloneUrlSsh(String var1);

        public Builder arn(String var1);
    }
}

