/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DevEnvironmentStatus {
    PENDING("PENDING"),
    RUNNING("RUNNING"),
    STARTING("STARTING"),
    STOPPING("STOPPING"),
    STOPPED("STOPPED"),
    FAILED("FAILED"),
    DELETING("DELETING"),
    DELETED("DELETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DevEnvironmentStatus> VALUE_MAP;
    private final String value;

    private DevEnvironmentStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DevEnvironmentStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DevEnvironmentStatus> knownValues() {
        EnumSet<DevEnvironmentStatus> knownValues = EnumSet.allOf(DevEnvironmentStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DevEnvironmentStatus.class, DevEnvironmentStatus::toString);
    }
}

