/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DevEnvironmentSessionType {
    SSM("SSM"),
    SSH("SSH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DevEnvironmentSessionType> VALUE_MAP;
    private final String value;

    private DevEnvironmentSessionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DevEnvironmentSessionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DevEnvironmentSessionType> knownValues() {
        EnumSet<DevEnvironmentSessionType> knownValues = EnumSet.allOf(DevEnvironmentSessionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DevEnvironmentSessionType.class, DevEnvironmentSessionType::toString);
    }
}

