/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codebuild.CodeBuildAsyncClient;
import software.amazon.awssdk.services.codebuild.internal.UserAgentUtils;
import software.amazon.awssdk.services.codebuild.model.ListSharedProjectsRequest;
import software.amazon.awssdk.services.codebuild.model.ListSharedProjectsResponse;

public class ListSharedProjectsPublisher
implements SdkPublisher<ListSharedProjectsResponse> {
    private final CodeBuildAsyncClient client;
    private final ListSharedProjectsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSharedProjectsPublisher(CodeBuildAsyncClient client, ListSharedProjectsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSharedProjectsPublisher(CodeBuildAsyncClient client, ListSharedProjectsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSharedProjectsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSharedProjectsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> projects() {
        Function<ListSharedProjectsResponse, Iterator> getIterator = response -> {
            if (response != null && response.projects() != null) {
                return response.projects().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSharedProjectsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSharedProjectsResponseFetcher
    implements AsyncPageFetcher<ListSharedProjectsResponse> {
        private ListSharedProjectsResponseFetcher() {
        }

        public boolean hasNextPage(ListSharedProjectsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSharedProjectsResponse> nextPage(ListSharedProjectsResponse previousPage) {
            if (previousPage == null) {
                return ListSharedProjectsPublisher.this.client.listSharedProjects(ListSharedProjectsPublisher.this.firstRequest);
            }
            return ListSharedProjectsPublisher.this.client.listSharedProjects((ListSharedProjectsRequest)((Object)ListSharedProjectsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

