/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CacheMode {
    LOCAL_DOCKER_LAYER_CACHE("LOCAL_DOCKER_LAYER_CACHE"),
    LOCAL_SOURCE_CACHE("LOCAL_SOURCE_CACHE"),
    LOCAL_CUSTOM_CACHE("LOCAL_CUSTOM_CACHE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CacheMode> VALUE_MAP;
    private final String value;

    private CacheMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CacheMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CacheMode> knownValues() {
        EnumSet<CacheMode> knownValues = EnumSet.allOf(CacheMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CacheMode.class, CacheMode::toString);
    }
}

