/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BuildPhaseType {
    SUBMITTED("SUBMITTED"),
    QUEUED("QUEUED"),
    PROVISIONING("PROVISIONING"),
    DOWNLOAD_SOURCE("DOWNLOAD_SOURCE"),
    INSTALL("INSTALL"),
    PRE_BUILD("PRE_BUILD"),
    BUILD("BUILD"),
    POST_BUILD("POST_BUILD"),
    UPLOAD_ARTIFACTS("UPLOAD_ARTIFACTS"),
    FINALIZING("FINALIZING"),
    COMPLETED("COMPLETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BuildPhaseType> VALUE_MAP;
    private final String value;

    private BuildPhaseType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BuildPhaseType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BuildPhaseType> knownValues() {
        EnumSet<BuildPhaseType> knownValues = EnumSet.allOf(BuildPhaseType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BuildPhaseType.class, BuildPhaseType::toString);
    }
}

