/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ArtifactNamespace {
    NONE("NONE"),
    BUILD_ID("BUILD_ID"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ArtifactNamespace> VALUE_MAP;
    private final String value;

    private ArtifactNamespace(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ArtifactNamespace fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ArtifactNamespace> knownValues() {
        EnumSet<ArtifactNamespace> knownValues = EnumSet.allOf(ArtifactNamespace.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ArtifactNamespace.class, ArtifactNamespace::toString);
    }
}

