/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AlarmType {
    COMPOSITE_ALARM("CompositeAlarm"),
    METRIC_ALARM("MetricAlarm"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AlarmType> VALUE_MAP;
    private final String value;

    private AlarmType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AlarmType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AlarmType> knownValues() {
        EnumSet<AlarmType> knownValues = EnumSet.allOf(AlarmType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AlarmType.class, AlarmType::toString);
    }
}

