/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EvaluationState {
    PARTIAL_DATA("PARTIAL_DATA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EvaluationState> VALUE_MAP;
    private final String value;

    private EvaluationState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EvaluationState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EvaluationState> knownValues() {
        EnumSet<EvaluationState> knownValues = EnumSet.allOf(EvaluationState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EvaluationState.class, EvaluationState::toString);
    }
}

