/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.ActionsSuppressedBy;
import software.amazon.awssdk.services.cloudwatch.model.ResourceListCopier;
import software.amazon.awssdk.services.cloudwatch.model.StateValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompositeAlarm
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CompositeAlarm> {
    private static final SdkField<Boolean> ACTIONS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ActionsEnabled").getter(CompositeAlarm.getter(CompositeAlarm::actionsEnabled)).setter(CompositeAlarm.setter(Builder::actionsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionsEnabled").build()}).build();
    private static final SdkField<List<String>> ALARM_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AlarmActions").getter(CompositeAlarm.getter(CompositeAlarm::alarmActions)).setter(CompositeAlarm.setter(Builder::alarmActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ALARM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlarmArn").getter(CompositeAlarm.getter(CompositeAlarm::alarmArn)).setter(CompositeAlarm.setter(Builder::alarmArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmArn").build()}).build();
    private static final SdkField<Instant> ALARM_CONFIGURATION_UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AlarmConfigurationUpdatedTimestamp").getter(CompositeAlarm.getter(CompositeAlarm::alarmConfigurationUpdatedTimestamp)).setter(CompositeAlarm.setter(Builder::alarmConfigurationUpdatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmConfigurationUpdatedTimestamp").build()}).build();
    private static final SdkField<String> ALARM_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlarmDescription").getter(CompositeAlarm.getter(CompositeAlarm::alarmDescription)).setter(CompositeAlarm.setter(Builder::alarmDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmDescription").build()}).build();
    private static final SdkField<String> ALARM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlarmName").getter(CompositeAlarm.getter(CompositeAlarm::alarmName)).setter(CompositeAlarm.setter(Builder::alarmName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmName").build()}).build();
    private static final SdkField<String> ALARM_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlarmRule").getter(CompositeAlarm.getter(CompositeAlarm::alarmRule)).setter(CompositeAlarm.setter(Builder::alarmRule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmRule").build()}).build();
    private static final SdkField<List<String>> INSUFFICIENT_DATA_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InsufficientDataActions").getter(CompositeAlarm.getter(CompositeAlarm::insufficientDataActions)).setter(CompositeAlarm.setter(Builder::insufficientDataActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsufficientDataActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> OK_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OKActions").getter(CompositeAlarm.getter(CompositeAlarm::okActions)).setter(CompositeAlarm.setter(Builder::okActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OKActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateReason").getter(CompositeAlarm.getter(CompositeAlarm::stateReason)).setter(CompositeAlarm.setter(Builder::stateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()}).build();
    private static final SdkField<String> STATE_REASON_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateReasonData").getter(CompositeAlarm.getter(CompositeAlarm::stateReasonData)).setter(CompositeAlarm.setter(Builder::stateReasonData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReasonData").build()}).build();
    private static final SdkField<Instant> STATE_UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StateUpdatedTimestamp").getter(CompositeAlarm.getter(CompositeAlarm::stateUpdatedTimestamp)).setter(CompositeAlarm.setter(Builder::stateUpdatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateUpdatedTimestamp").build()}).build();
    private static final SdkField<String> STATE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateValue").getter(CompositeAlarm.getter(CompositeAlarm::stateValueAsString)).setter(CompositeAlarm.setter(Builder::stateValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateValue").build()}).build();
    private static final SdkField<Instant> STATE_TRANSITIONED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StateTransitionedTimestamp").getter(CompositeAlarm.getter(CompositeAlarm::stateTransitionedTimestamp)).setter(CompositeAlarm.setter(Builder::stateTransitionedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateTransitionedTimestamp").build()}).build();
    private static final SdkField<String> ACTIONS_SUPPRESSED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionsSuppressedBy").getter(CompositeAlarm.getter(CompositeAlarm::actionsSuppressedByAsString)).setter(CompositeAlarm.setter(Builder::actionsSuppressedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionsSuppressedBy").build()}).build();
    private static final SdkField<String> ACTIONS_SUPPRESSED_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionsSuppressedReason").getter(CompositeAlarm.getter(CompositeAlarm::actionsSuppressedReason)).setter(CompositeAlarm.setter(Builder::actionsSuppressedReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionsSuppressedReason").build()}).build();
    private static final SdkField<String> ACTIONS_SUPPRESSOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionsSuppressor").getter(CompositeAlarm.getter(CompositeAlarm::actionsSuppressor)).setter(CompositeAlarm.setter(Builder::actionsSuppressor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionsSuppressor").build()}).build();
    private static final SdkField<Integer> ACTIONS_SUPPRESSOR_WAIT_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ActionsSuppressorWaitPeriod").getter(CompositeAlarm.getter(CompositeAlarm::actionsSuppressorWaitPeriod)).setter(CompositeAlarm.setter(Builder::actionsSuppressorWaitPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionsSuppressorWaitPeriod").build()}).build();
    private static final SdkField<Integer> ACTIONS_SUPPRESSOR_EXTENSION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ActionsSuppressorExtensionPeriod").getter(CompositeAlarm.getter(CompositeAlarm::actionsSuppressorExtensionPeriod)).setter(CompositeAlarm.setter(Builder::actionsSuppressorExtensionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionsSuppressorExtensionPeriod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_ENABLED_FIELD, ALARM_ACTIONS_FIELD, ALARM_ARN_FIELD, ALARM_CONFIGURATION_UPDATED_TIMESTAMP_FIELD, ALARM_DESCRIPTION_FIELD, ALARM_NAME_FIELD, ALARM_RULE_FIELD, INSUFFICIENT_DATA_ACTIONS_FIELD, OK_ACTIONS_FIELD, STATE_REASON_FIELD, STATE_REASON_DATA_FIELD, STATE_UPDATED_TIMESTAMP_FIELD, STATE_VALUE_FIELD, STATE_TRANSITIONED_TIMESTAMP_FIELD, ACTIONS_SUPPRESSED_BY_FIELD, ACTIONS_SUPPRESSED_REASON_FIELD, ACTIONS_SUPPRESSOR_FIELD, ACTIONS_SUPPRESSOR_WAIT_PERIOD_FIELD, ACTIONS_SUPPRESSOR_EXTENSION_PERIOD_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean actionsEnabled;
    private final List<String> alarmActions;
    private final String alarmArn;
    private final Instant alarmConfigurationUpdatedTimestamp;
    private final String alarmDescription;
    private final String alarmName;
    private final String alarmRule;
    private final List<String> insufficientDataActions;
    private final List<String> okActions;
    private final String stateReason;
    private final String stateReasonData;
    private final Instant stateUpdatedTimestamp;
    private final String stateValue;
    private final Instant stateTransitionedTimestamp;
    private final String actionsSuppressedBy;
    private final String actionsSuppressedReason;
    private final String actionsSuppressor;
    private final Integer actionsSuppressorWaitPeriod;
    private final Integer actionsSuppressorExtensionPeriod;

    private CompositeAlarm(BuilderImpl builder) {
        this.actionsEnabled = builder.actionsEnabled;
        this.alarmActions = builder.alarmActions;
        this.alarmArn = builder.alarmArn;
        this.alarmConfigurationUpdatedTimestamp = builder.alarmConfigurationUpdatedTimestamp;
        this.alarmDescription = builder.alarmDescription;
        this.alarmName = builder.alarmName;
        this.alarmRule = builder.alarmRule;
        this.insufficientDataActions = builder.insufficientDataActions;
        this.okActions = builder.okActions;
        this.stateReason = builder.stateReason;
        this.stateReasonData = builder.stateReasonData;
        this.stateUpdatedTimestamp = builder.stateUpdatedTimestamp;
        this.stateValue = builder.stateValue;
        this.stateTransitionedTimestamp = builder.stateTransitionedTimestamp;
        this.actionsSuppressedBy = builder.actionsSuppressedBy;
        this.actionsSuppressedReason = builder.actionsSuppressedReason;
        this.actionsSuppressor = builder.actionsSuppressor;
        this.actionsSuppressorWaitPeriod = builder.actionsSuppressorWaitPeriod;
        this.actionsSuppressorExtensionPeriod = builder.actionsSuppressorExtensionPeriod;
    }

    public final Boolean actionsEnabled() {
        return this.actionsEnabled;
    }

    public final boolean hasAlarmActions() {
        return this.alarmActions != null && !(this.alarmActions instanceof SdkAutoConstructList);
    }

    public final List<String> alarmActions() {
        return this.alarmActions;
    }

    public final String alarmArn() {
        return this.alarmArn;
    }

    public final Instant alarmConfigurationUpdatedTimestamp() {
        return this.alarmConfigurationUpdatedTimestamp;
    }

    public final String alarmDescription() {
        return this.alarmDescription;
    }

    public final String alarmName() {
        return this.alarmName;
    }

    public final String alarmRule() {
        return this.alarmRule;
    }

    public final boolean hasInsufficientDataActions() {
        return this.insufficientDataActions != null && !(this.insufficientDataActions instanceof SdkAutoConstructList);
    }

    public final List<String> insufficientDataActions() {
        return this.insufficientDataActions;
    }

    public final boolean hasOkActions() {
        return this.okActions != null && !(this.okActions instanceof SdkAutoConstructList);
    }

    public final List<String> okActions() {
        return this.okActions;
    }

    public final String stateReason() {
        return this.stateReason;
    }

    public final String stateReasonData() {
        return this.stateReasonData;
    }

    public final Instant stateUpdatedTimestamp() {
        return this.stateUpdatedTimestamp;
    }

    public final StateValue stateValue() {
        return StateValue.fromValue(this.stateValue);
    }

    public final String stateValueAsString() {
        return this.stateValue;
    }

    public final Instant stateTransitionedTimestamp() {
        return this.stateTransitionedTimestamp;
    }

    public final ActionsSuppressedBy actionsSuppressedBy() {
        return ActionsSuppressedBy.fromValue(this.actionsSuppressedBy);
    }

    public final String actionsSuppressedByAsString() {
        return this.actionsSuppressedBy;
    }

    public final String actionsSuppressedReason() {
        return this.actionsSuppressedReason;
    }

    public final String actionsSuppressor() {
        return this.actionsSuppressor;
    }

    public final Integer actionsSuppressorWaitPeriod() {
        return this.actionsSuppressorWaitPeriod;
    }

    public final Integer actionsSuppressorExtensionPeriod() {
        return this.actionsSuppressorExtensionPeriod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlarmActions() ? this.alarmActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmConfigurationUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInsufficientDataActions() ? this.insufficientDataActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOkActions() ? this.okActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReasonData());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateValueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateTransitionedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionsSuppressedByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionsSuppressedReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionsSuppressor());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionsSuppressorWaitPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionsSuppressorExtensionPeriod());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompositeAlarm)) {
            return false;
        }
        CompositeAlarm other = (CompositeAlarm)obj;
        return Objects.equals(this.actionsEnabled(), other.actionsEnabled()) && this.hasAlarmActions() == other.hasAlarmActions() && Objects.equals(this.alarmActions(), other.alarmActions()) && Objects.equals(this.alarmArn(), other.alarmArn()) && Objects.equals(this.alarmConfigurationUpdatedTimestamp(), other.alarmConfigurationUpdatedTimestamp()) && Objects.equals(this.alarmDescription(), other.alarmDescription()) && Objects.equals(this.alarmName(), other.alarmName()) && Objects.equals(this.alarmRule(), other.alarmRule()) && this.hasInsufficientDataActions() == other.hasInsufficientDataActions() && Objects.equals(this.insufficientDataActions(), other.insufficientDataActions()) && this.hasOkActions() == other.hasOkActions() && Objects.equals(this.okActions(), other.okActions()) && Objects.equals(this.stateReason(), other.stateReason()) && Objects.equals(this.stateReasonData(), other.stateReasonData()) && Objects.equals(this.stateUpdatedTimestamp(), other.stateUpdatedTimestamp()) && Objects.equals(this.stateValueAsString(), other.stateValueAsString()) && Objects.equals(this.stateTransitionedTimestamp(), other.stateTransitionedTimestamp()) && Objects.equals(this.actionsSuppressedByAsString(), other.actionsSuppressedByAsString()) && Objects.equals(this.actionsSuppressedReason(), other.actionsSuppressedReason()) && Objects.equals(this.actionsSuppressor(), other.actionsSuppressor()) && Objects.equals(this.actionsSuppressorWaitPeriod(), other.actionsSuppressorWaitPeriod()) && Objects.equals(this.actionsSuppressorExtensionPeriod(), other.actionsSuppressorExtensionPeriod());
    }

    public final String toString() {
        return ToString.builder((String)"CompositeAlarm").add("ActionsEnabled", (Object)this.actionsEnabled()).add("AlarmActions", this.hasAlarmActions() ? this.alarmActions() : null).add("AlarmArn", (Object)this.alarmArn()).add("AlarmConfigurationUpdatedTimestamp", (Object)this.alarmConfigurationUpdatedTimestamp()).add("AlarmDescription", (Object)this.alarmDescription()).add("AlarmName", (Object)this.alarmName()).add("AlarmRule", (Object)this.alarmRule()).add("InsufficientDataActions", this.hasInsufficientDataActions() ? this.insufficientDataActions() : null).add("OKActions", this.hasOkActions() ? this.okActions() : null).add("StateReason", (Object)this.stateReason()).add("StateReasonData", (Object)this.stateReasonData()).add("StateUpdatedTimestamp", (Object)this.stateUpdatedTimestamp()).add("StateValue", (Object)this.stateValueAsString()).add("StateTransitionedTimestamp", (Object)this.stateTransitionedTimestamp()).add("ActionsSuppressedBy", (Object)this.actionsSuppressedByAsString()).add("ActionsSuppressedReason", (Object)this.actionsSuppressedReason()).add("ActionsSuppressor", (Object)this.actionsSuppressor()).add("ActionsSuppressorWaitPeriod", (Object)this.actionsSuppressorWaitPeriod()).add("ActionsSuppressorExtensionPeriod", (Object)this.actionsSuppressorExtensionPeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionsEnabled": {
                return Optional.ofNullable(clazz.cast(this.actionsEnabled()));
            }
            case "AlarmActions": {
                return Optional.ofNullable(clazz.cast(this.alarmActions()));
            }
            case "AlarmArn": {
                return Optional.ofNullable(clazz.cast(this.alarmArn()));
            }
            case "AlarmConfigurationUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.alarmConfigurationUpdatedTimestamp()));
            }
            case "AlarmDescription": {
                return Optional.ofNullable(clazz.cast(this.alarmDescription()));
            }
            case "AlarmName": {
                return Optional.ofNullable(clazz.cast(this.alarmName()));
            }
            case "AlarmRule": {
                return Optional.ofNullable(clazz.cast(this.alarmRule()));
            }
            case "InsufficientDataActions": {
                return Optional.ofNullable(clazz.cast(this.insufficientDataActions()));
            }
            case "OKActions": {
                return Optional.ofNullable(clazz.cast(this.okActions()));
            }
            case "StateReason": {
                return Optional.ofNullable(clazz.cast(this.stateReason()));
            }
            case "StateReasonData": {
                return Optional.ofNullable(clazz.cast(this.stateReasonData()));
            }
            case "StateUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.stateUpdatedTimestamp()));
            }
            case "StateValue": {
                return Optional.ofNullable(clazz.cast(this.stateValueAsString()));
            }
            case "StateTransitionedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.stateTransitionedTimestamp()));
            }
            case "ActionsSuppressedBy": {
                return Optional.ofNullable(clazz.cast(this.actionsSuppressedByAsString()));
            }
            case "ActionsSuppressedReason": {
                return Optional.ofNullable(clazz.cast(this.actionsSuppressedReason()));
            }
            case "ActionsSuppressor": {
                return Optional.ofNullable(clazz.cast(this.actionsSuppressor()));
            }
            case "ActionsSuppressorWaitPeriod": {
                return Optional.ofNullable(clazz.cast(this.actionsSuppressorWaitPeriod()));
            }
            case "ActionsSuppressorExtensionPeriod": {
                return Optional.ofNullable(clazz.cast(this.actionsSuppressorExtensionPeriod()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompositeAlarm, T> g) {
        return obj -> g.apply((CompositeAlarm)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean actionsEnabled;
        private List<String> alarmActions = DefaultSdkAutoConstructList.getInstance();
        private String alarmArn;
        private Instant alarmConfigurationUpdatedTimestamp;
        private String alarmDescription;
        private String alarmName;
        private String alarmRule;
        private List<String> insufficientDataActions = DefaultSdkAutoConstructList.getInstance();
        private List<String> okActions = DefaultSdkAutoConstructList.getInstance();
        private String stateReason;
        private String stateReasonData;
        private Instant stateUpdatedTimestamp;
        private String stateValue;
        private Instant stateTransitionedTimestamp;
        private String actionsSuppressedBy;
        private String actionsSuppressedReason;
        private String actionsSuppressor;
        private Integer actionsSuppressorWaitPeriod;
        private Integer actionsSuppressorExtensionPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(CompositeAlarm model) {
            this.actionsEnabled(model.actionsEnabled);
            this.alarmActions(model.alarmActions);
            this.alarmArn(model.alarmArn);
            this.alarmConfigurationUpdatedTimestamp(model.alarmConfigurationUpdatedTimestamp);
            this.alarmDescription(model.alarmDescription);
            this.alarmName(model.alarmName);
            this.alarmRule(model.alarmRule);
            this.insufficientDataActions(model.insufficientDataActions);
            this.okActions(model.okActions);
            this.stateReason(model.stateReason);
            this.stateReasonData(model.stateReasonData);
            this.stateUpdatedTimestamp(model.stateUpdatedTimestamp);
            this.stateValue(model.stateValue);
            this.stateTransitionedTimestamp(model.stateTransitionedTimestamp);
            this.actionsSuppressedBy(model.actionsSuppressedBy);
            this.actionsSuppressedReason(model.actionsSuppressedReason);
            this.actionsSuppressor(model.actionsSuppressor);
            this.actionsSuppressorWaitPeriod(model.actionsSuppressorWaitPeriod);
            this.actionsSuppressorExtensionPeriod(model.actionsSuppressorExtensionPeriod);
        }

        public final Boolean getActionsEnabled() {
            return this.actionsEnabled;
        }

        public final void setActionsEnabled(Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
        }

        @Override
        public final Builder actionsEnabled(Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
            return this;
        }

        public final Collection<String> getAlarmActions() {
            if (this.alarmActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.alarmActions;
        }

        public final void setAlarmActions(Collection<String> alarmActions) {
            this.alarmActions = ResourceListCopier.copy(alarmActions);
        }

        @Override
        public final Builder alarmActions(Collection<String> alarmActions) {
            this.alarmActions = ResourceListCopier.copy(alarmActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmActions(String ... alarmActions) {
            this.alarmActions(Arrays.asList(alarmActions));
            return this;
        }

        public final String getAlarmArn() {
            return this.alarmArn;
        }

        public final void setAlarmArn(String alarmArn) {
            this.alarmArn = alarmArn;
        }

        @Override
        public final Builder alarmArn(String alarmArn) {
            this.alarmArn = alarmArn;
            return this;
        }

        public final Instant getAlarmConfigurationUpdatedTimestamp() {
            return this.alarmConfigurationUpdatedTimestamp;
        }

        public final void setAlarmConfigurationUpdatedTimestamp(Instant alarmConfigurationUpdatedTimestamp) {
            this.alarmConfigurationUpdatedTimestamp = alarmConfigurationUpdatedTimestamp;
        }

        @Override
        public final Builder alarmConfigurationUpdatedTimestamp(Instant alarmConfigurationUpdatedTimestamp) {
            this.alarmConfigurationUpdatedTimestamp = alarmConfigurationUpdatedTimestamp;
            return this;
        }

        public final String getAlarmDescription() {
            return this.alarmDescription;
        }

        public final void setAlarmDescription(String alarmDescription) {
            this.alarmDescription = alarmDescription;
        }

        @Override
        public final Builder alarmDescription(String alarmDescription) {
            this.alarmDescription = alarmDescription;
            return this;
        }

        public final String getAlarmName() {
            return this.alarmName;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final String getAlarmRule() {
            return this.alarmRule;
        }

        public final void setAlarmRule(String alarmRule) {
            this.alarmRule = alarmRule;
        }

        @Override
        public final Builder alarmRule(String alarmRule) {
            this.alarmRule = alarmRule;
            return this;
        }

        public final Collection<String> getInsufficientDataActions() {
            if (this.insufficientDataActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.insufficientDataActions;
        }

        public final void setInsufficientDataActions(Collection<String> insufficientDataActions) {
            this.insufficientDataActions = ResourceListCopier.copy(insufficientDataActions);
        }

        @Override
        public final Builder insufficientDataActions(Collection<String> insufficientDataActions) {
            this.insufficientDataActions = ResourceListCopier.copy(insufficientDataActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insufficientDataActions(String ... insufficientDataActions) {
            this.insufficientDataActions(Arrays.asList(insufficientDataActions));
            return this;
        }

        public final Collection<String> getOkActions() {
            if (this.okActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.okActions;
        }

        public final void setOkActions(Collection<String> okActions) {
            this.okActions = ResourceListCopier.copy(okActions);
        }

        @Override
        public final Builder okActions(Collection<String> okActions) {
            this.okActions = ResourceListCopier.copy(okActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder okActions(String ... okActions) {
            this.okActions(Arrays.asList(okActions));
            return this;
        }

        public final String getStateReason() {
            return this.stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final String getStateReasonData() {
            return this.stateReasonData;
        }

        public final void setStateReasonData(String stateReasonData) {
            this.stateReasonData = stateReasonData;
        }

        @Override
        public final Builder stateReasonData(String stateReasonData) {
            this.stateReasonData = stateReasonData;
            return this;
        }

        public final Instant getStateUpdatedTimestamp() {
            return this.stateUpdatedTimestamp;
        }

        public final void setStateUpdatedTimestamp(Instant stateUpdatedTimestamp) {
            this.stateUpdatedTimestamp = stateUpdatedTimestamp;
        }

        @Override
        public final Builder stateUpdatedTimestamp(Instant stateUpdatedTimestamp) {
            this.stateUpdatedTimestamp = stateUpdatedTimestamp;
            return this;
        }

        public final String getStateValue() {
            return this.stateValue;
        }

        public final void setStateValue(String stateValue) {
            this.stateValue = stateValue;
        }

        @Override
        public final Builder stateValue(String stateValue) {
            this.stateValue = stateValue;
            return this;
        }

        @Override
        public final Builder stateValue(StateValue stateValue) {
            this.stateValue(stateValue == null ? null : stateValue.toString());
            return this;
        }

        public final Instant getStateTransitionedTimestamp() {
            return this.stateTransitionedTimestamp;
        }

        public final void setStateTransitionedTimestamp(Instant stateTransitionedTimestamp) {
            this.stateTransitionedTimestamp = stateTransitionedTimestamp;
        }

        @Override
        public final Builder stateTransitionedTimestamp(Instant stateTransitionedTimestamp) {
            this.stateTransitionedTimestamp = stateTransitionedTimestamp;
            return this;
        }

        public final String getActionsSuppressedBy() {
            return this.actionsSuppressedBy;
        }

        public final void setActionsSuppressedBy(String actionsSuppressedBy) {
            this.actionsSuppressedBy = actionsSuppressedBy;
        }

        @Override
        public final Builder actionsSuppressedBy(String actionsSuppressedBy) {
            this.actionsSuppressedBy = actionsSuppressedBy;
            return this;
        }

        @Override
        public final Builder actionsSuppressedBy(ActionsSuppressedBy actionsSuppressedBy) {
            this.actionsSuppressedBy(actionsSuppressedBy == null ? null : actionsSuppressedBy.toString());
            return this;
        }

        public final String getActionsSuppressedReason() {
            return this.actionsSuppressedReason;
        }

        public final void setActionsSuppressedReason(String actionsSuppressedReason) {
            this.actionsSuppressedReason = actionsSuppressedReason;
        }

        @Override
        public final Builder actionsSuppressedReason(String actionsSuppressedReason) {
            this.actionsSuppressedReason = actionsSuppressedReason;
            return this;
        }

        public final String getActionsSuppressor() {
            return this.actionsSuppressor;
        }

        public final void setActionsSuppressor(String actionsSuppressor) {
            this.actionsSuppressor = actionsSuppressor;
        }

        @Override
        public final Builder actionsSuppressor(String actionsSuppressor) {
            this.actionsSuppressor = actionsSuppressor;
            return this;
        }

        public final Integer getActionsSuppressorWaitPeriod() {
            return this.actionsSuppressorWaitPeriod;
        }

        public final void setActionsSuppressorWaitPeriod(Integer actionsSuppressorWaitPeriod) {
            this.actionsSuppressorWaitPeriod = actionsSuppressorWaitPeriod;
        }

        @Override
        public final Builder actionsSuppressorWaitPeriod(Integer actionsSuppressorWaitPeriod) {
            this.actionsSuppressorWaitPeriod = actionsSuppressorWaitPeriod;
            return this;
        }

        public final Integer getActionsSuppressorExtensionPeriod() {
            return this.actionsSuppressorExtensionPeriod;
        }

        public final void setActionsSuppressorExtensionPeriod(Integer actionsSuppressorExtensionPeriod) {
            this.actionsSuppressorExtensionPeriod = actionsSuppressorExtensionPeriod;
        }

        @Override
        public final Builder actionsSuppressorExtensionPeriod(Integer actionsSuppressorExtensionPeriod) {
            this.actionsSuppressorExtensionPeriod = actionsSuppressorExtensionPeriod;
            return this;
        }

        public CompositeAlarm build() {
            return new CompositeAlarm(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CompositeAlarm> {
        public Builder actionsEnabled(Boolean var1);

        public Builder alarmActions(Collection<String> var1);

        public Builder alarmActions(String ... var1);

        public Builder alarmArn(String var1);

        public Builder alarmConfigurationUpdatedTimestamp(Instant var1);

        public Builder alarmDescription(String var1);

        public Builder alarmName(String var1);

        public Builder alarmRule(String var1);

        public Builder insufficientDataActions(Collection<String> var1);

        public Builder insufficientDataActions(String ... var1);

        public Builder okActions(Collection<String> var1);

        public Builder okActions(String ... var1);

        public Builder stateReason(String var1);

        public Builder stateReasonData(String var1);

        public Builder stateUpdatedTimestamp(Instant var1);

        public Builder stateValue(String var1);

        public Builder stateValue(StateValue var1);

        public Builder stateTransitionedTimestamp(Instant var1);

        public Builder actionsSuppressedBy(String var1);

        public Builder actionsSuppressedBy(ActionsSuppressedBy var1);

        public Builder actionsSuppressedReason(String var1);

        public Builder actionsSuppressor(String var1);

        public Builder actionsSuppressorWaitPeriod(Integer var1);

        public Builder actionsSuppressorExtensionPeriod(Integer var1);
    }
}

