/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An origin group includes two origins (a primary origin and a second origin to failover to) and a failover criteria
 * that you specify. You create an origin group to support origin failover in CloudFront. When you create or update a
 * distribution, you can specify the origin group instead of a single origin, and CloudFront will failover from the
 * primary origin to the second origin under the failover conditions that you've chosen.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OriginGroup implements SdkPojo, Serializable, ToCopyableBuilder<OriginGroup.Builder, OriginGroup> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(OriginGroup::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<OriginGroupFailoverCriteria> FAILOVER_CRITERIA_FIELD = SdkField
            .<OriginGroupFailoverCriteria> builder(MarshallingType.SDK_POJO)
            .memberName("FailoverCriteria")
            .getter(getter(OriginGroup::failoverCriteria))
            .setter(setter(Builder::failoverCriteria))
            .constructor(OriginGroupFailoverCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailoverCriteria")
                    .unmarshallLocationName("FailoverCriteria").build()).build();

    private static final SdkField<OriginGroupMembers> MEMBERS_FIELD = SdkField
            .<OriginGroupMembers> builder(MarshallingType.SDK_POJO)
            .memberName("Members")
            .getter(getter(OriginGroup::members))
            .setter(setter(Builder::members))
            .constructor(OriginGroupMembers::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Members")
                    .unmarshallLocationName("Members").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            FAILOVER_CRITERIA_FIELD, MEMBERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final OriginGroupFailoverCriteria failoverCriteria;

    private final OriginGroupMembers members;

    private OriginGroup(BuilderImpl builder) {
        this.id = builder.id;
        this.failoverCriteria = builder.failoverCriteria;
        this.members = builder.members;
    }

    /**
     * <p>
     * The origin group's ID.
     * </p>
     * 
     * @return The origin group's ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A complex type that contains information about the failover criteria for an origin group.
     * </p>
     * 
     * @return A complex type that contains information about the failover criteria for an origin group.
     */
    public final OriginGroupFailoverCriteria failoverCriteria() {
        return failoverCriteria;
    }

    /**
     * <p>
     * A complex type that contains information about the origins in an origin group.
     * </p>
     * 
     * @return A complex type that contains information about the origins in an origin group.
     */
    public final OriginGroupMembers members() {
        return members;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(failoverCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(members());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginGroup)) {
            return false;
        }
        OriginGroup other = (OriginGroup) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(failoverCriteria(), other.failoverCriteria())
                && Objects.equals(members(), other.members());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OriginGroup").add("Id", id()).add("FailoverCriteria", failoverCriteria())
                .add("Members", members()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "FailoverCriteria":
            return Optional.ofNullable(clazz.cast(failoverCriteria()));
        case "Members":
            return Optional.ofNullable(clazz.cast(members()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OriginGroup, T> g) {
        return obj -> g.apply((OriginGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OriginGroup> {
        /**
         * <p>
         * The origin group's ID.
         * </p>
         * 
         * @param id
         *        The origin group's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A complex type that contains information about the failover criteria for an origin group.
         * </p>
         * 
         * @param failoverCriteria
         *        A complex type that contains information about the failover criteria for an origin group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failoverCriteria(OriginGroupFailoverCriteria failoverCriteria);

        /**
         * <p>
         * A complex type that contains information about the failover criteria for an origin group.
         * </p>
         * This is a convenience method that creates an instance of the {@link OriginGroupFailoverCriteria.Builder}
         * avoiding the need to create one manually via {@link OriginGroupFailoverCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OriginGroupFailoverCriteria.Builder#build()} is called
         * immediately and its result is passed to {@link #failoverCriteria(OriginGroupFailoverCriteria)}.
         * 
         * @param failoverCriteria
         *        a consumer that will call methods on {@link OriginGroupFailoverCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failoverCriteria(OriginGroupFailoverCriteria)
         */
        default Builder failoverCriteria(Consumer<OriginGroupFailoverCriteria.Builder> failoverCriteria) {
            return failoverCriteria(OriginGroupFailoverCriteria.builder().applyMutation(failoverCriteria).build());
        }

        /**
         * <p>
         * A complex type that contains information about the origins in an origin group.
         * </p>
         * 
         * @param members
         *        A complex type that contains information about the origins in an origin group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder members(OriginGroupMembers members);

        /**
         * <p>
         * A complex type that contains information about the origins in an origin group.
         * </p>
         * This is a convenience method that creates an instance of the {@link OriginGroupMembers.Builder} avoiding the
         * need to create one manually via {@link OriginGroupMembers#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OriginGroupMembers.Builder#build()} is called immediately and its
         * result is passed to {@link #members(OriginGroupMembers)}.
         * 
         * @param members
         *        a consumer that will call methods on {@link OriginGroupMembers.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #members(OriginGroupMembers)
         */
        default Builder members(Consumer<OriginGroupMembers.Builder> members) {
            return members(OriginGroupMembers.builder().applyMutation(members).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private OriginGroupFailoverCriteria failoverCriteria;

        private OriginGroupMembers members;

        private BuilderImpl() {
        }

        private BuilderImpl(OriginGroup model) {
            id(model.id);
            failoverCriteria(model.failoverCriteria);
            members(model.members);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final OriginGroupFailoverCriteria.Builder getFailoverCriteria() {
            return failoverCriteria != null ? failoverCriteria.toBuilder() : null;
        }

        public final void setFailoverCriteria(OriginGroupFailoverCriteria.BuilderImpl failoverCriteria) {
            this.failoverCriteria = failoverCriteria != null ? failoverCriteria.build() : null;
        }

        @Override
        public final Builder failoverCriteria(OriginGroupFailoverCriteria failoverCriteria) {
            this.failoverCriteria = failoverCriteria;
            return this;
        }

        public final OriginGroupMembers.Builder getMembers() {
            return members != null ? members.toBuilder() : null;
        }

        public final void setMembers(OriginGroupMembers.BuilderImpl members) {
            this.members = members != null ? members.build() : null;
        }

        @Override
        public final Builder members(OriginGroupMembers members) {
            this.members = members;
            return this;
        }

        @Override
        public OriginGroup build() {
            return new OriginGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
