/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A continuous deployment policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContinuousDeploymentPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<ContinuousDeploymentPolicy.Builder, ContinuousDeploymentPolicy> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(ContinuousDeploymentPolicy::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime")
            .getter(getter(ContinuousDeploymentPolicy::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime")
                    .unmarshallLocationName("LastModifiedTime").build()).build();

    private static final SdkField<ContinuousDeploymentPolicyConfig> CONTINUOUS_DEPLOYMENT_POLICY_CONFIG_FIELD = SdkField
            .<ContinuousDeploymentPolicyConfig> builder(MarshallingType.SDK_POJO)
            .memberName("ContinuousDeploymentPolicyConfig")
            .getter(getter(ContinuousDeploymentPolicy::continuousDeploymentPolicyConfig))
            .setter(setter(Builder::continuousDeploymentPolicyConfig))
            .constructor(ContinuousDeploymentPolicyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContinuousDeploymentPolicyConfig")
                    .unmarshallLocationName("ContinuousDeploymentPolicyConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            LAST_MODIFIED_TIME_FIELD, CONTINUOUS_DEPLOYMENT_POLICY_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final Instant lastModifiedTime;

    private final ContinuousDeploymentPolicyConfig continuousDeploymentPolicyConfig;

    private ContinuousDeploymentPolicy(BuilderImpl builder) {
        this.id = builder.id;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.continuousDeploymentPolicyConfig = builder.continuousDeploymentPolicyConfig;
    }

    /**
     * <p>
     * The identifier of the continuous deployment policy.
     * </p>
     * 
     * @return The identifier of the continuous deployment policy.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The date and time the continuous deployment policy was last modified.
     * </p>
     * 
     * @return The date and time the continuous deployment policy was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * Returns the value of the ContinuousDeploymentPolicyConfig property for this object.
     * 
     * @return The value of the ContinuousDeploymentPolicyConfig property for this object.
     */
    public final ContinuousDeploymentPolicyConfig continuousDeploymentPolicyConfig() {
        return continuousDeploymentPolicyConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(continuousDeploymentPolicyConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContinuousDeploymentPolicy)) {
            return false;
        }
        ContinuousDeploymentPolicy other = (ContinuousDeploymentPolicy) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(continuousDeploymentPolicyConfig(), other.continuousDeploymentPolicyConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContinuousDeploymentPolicy").add("Id", id()).add("LastModifiedTime", lastModifiedTime())
                .add("ContinuousDeploymentPolicyConfig", continuousDeploymentPolicyConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "ContinuousDeploymentPolicyConfig":
            return Optional.ofNullable(clazz.cast(continuousDeploymentPolicyConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContinuousDeploymentPolicy, T> g) {
        return obj -> g.apply((ContinuousDeploymentPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContinuousDeploymentPolicy> {
        /**
         * <p>
         * The identifier of the continuous deployment policy.
         * </p>
         * 
         * @param id
         *        The identifier of the continuous deployment policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The date and time the continuous deployment policy was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time the continuous deployment policy was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * Sets the value of the ContinuousDeploymentPolicyConfig property for this object.
         *
         * @param continuousDeploymentPolicyConfig
         *        The new value for the ContinuousDeploymentPolicyConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuousDeploymentPolicyConfig(ContinuousDeploymentPolicyConfig continuousDeploymentPolicyConfig);

        /**
         * Sets the value of the ContinuousDeploymentPolicyConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ContinuousDeploymentPolicyConfig.Builder}
         * avoiding the need to create one manually via {@link ContinuousDeploymentPolicyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContinuousDeploymentPolicyConfig.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #continuousDeploymentPolicyConfig(ContinuousDeploymentPolicyConfig)}.
         * 
         * @param continuousDeploymentPolicyConfig
         *        a consumer that will call methods on {@link ContinuousDeploymentPolicyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #continuousDeploymentPolicyConfig(ContinuousDeploymentPolicyConfig)
         */
        default Builder continuousDeploymentPolicyConfig(
                Consumer<ContinuousDeploymentPolicyConfig.Builder> continuousDeploymentPolicyConfig) {
            return continuousDeploymentPolicyConfig(ContinuousDeploymentPolicyConfig.builder()
                    .applyMutation(continuousDeploymentPolicyConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Instant lastModifiedTime;

        private ContinuousDeploymentPolicyConfig continuousDeploymentPolicyConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ContinuousDeploymentPolicy model) {
            id(model.id);
            lastModifiedTime(model.lastModifiedTime);
            continuousDeploymentPolicyConfig(model.continuousDeploymentPolicyConfig);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final ContinuousDeploymentPolicyConfig.Builder getContinuousDeploymentPolicyConfig() {
            return continuousDeploymentPolicyConfig != null ? continuousDeploymentPolicyConfig.toBuilder() : null;
        }

        public final void setContinuousDeploymentPolicyConfig(
                ContinuousDeploymentPolicyConfig.BuilderImpl continuousDeploymentPolicyConfig) {
            this.continuousDeploymentPolicyConfig = continuousDeploymentPolicyConfig != null ? continuousDeploymentPolicyConfig
                    .build() : null;
        }

        @Override
        public final Builder continuousDeploymentPolicyConfig(ContinuousDeploymentPolicyConfig continuousDeploymentPolicyConfig) {
            this.continuousDeploymentPolicyConfig = continuousDeploymentPolicyConfig;
            return this;
        }

        @Override
        public ContinuousDeploymentPolicy build() {
            return new ContinuousDeploymentPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
