/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryAsyncClient;
import software.amazon.awssdk.services.clouddirectory.internal.UserAgentUtils;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesResponse;

public class ListTypedLinkFacetNamesPublisher
implements SdkPublisher<ListTypedLinkFacetNamesResponse> {
    private final CloudDirectoryAsyncClient client;
    private final ListTypedLinkFacetNamesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTypedLinkFacetNamesPublisher(CloudDirectoryAsyncClient client, ListTypedLinkFacetNamesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTypedLinkFacetNamesPublisher(CloudDirectoryAsyncClient client, ListTypedLinkFacetNamesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTypedLinkFacetNamesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTypedLinkFacetNamesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListTypedLinkFacetNamesResponseFetcher
    implements AsyncPageFetcher<ListTypedLinkFacetNamesResponse> {
        private ListTypedLinkFacetNamesResponseFetcher() {
        }

        public boolean hasNextPage(ListTypedLinkFacetNamesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTypedLinkFacetNamesResponse> nextPage(ListTypedLinkFacetNamesResponse previousPage) {
            if (previousPage == null) {
                return ListTypedLinkFacetNamesPublisher.this.client.listTypedLinkFacetNames(ListTypedLinkFacetNamesPublisher.this.firstRequest);
            }
            return ListTypedLinkFacetNamesPublisher.this.client.listTypedLinkFacetNames((ListTypedLinkFacetNamesRequest)((Object)ListTypedLinkFacetNamesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

