/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesResponse;

public class ListObjectAttributesIterable
implements SdkIterable<ListObjectAttributesResponse> {
    private final CloudDirectoryClient client;
    private final ListObjectAttributesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListObjectAttributesIterable(CloudDirectoryClient client, ListObjectAttributesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListObjectAttributesResponseFetcher();
    }

    public Iterator<ListObjectAttributesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListObjectAttributesResponseFetcher
    implements SyncPageFetcher<ListObjectAttributesResponse> {
        private ListObjectAttributesResponseFetcher() {
        }

        public boolean hasNextPage(ListObjectAttributesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListObjectAttributesResponse nextPage(ListObjectAttributesResponse previousPage) {
            if (previousPage == null) {
                return ListObjectAttributesIterable.this.client.listObjectAttributes(ListObjectAttributesIterable.this.firstRequest);
            }
            return ListObjectAttributesIterable.this.client.listObjectAttributes((ListObjectAttributesRequest)((Object)ListObjectAttributesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

