/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsResponse;

public class ListManagedSchemaArnsIterable
implements SdkIterable<ListManagedSchemaArnsResponse> {
    private final CloudDirectoryClient client;
    private final ListManagedSchemaArnsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListManagedSchemaArnsIterable(CloudDirectoryClient client, ListManagedSchemaArnsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListManagedSchemaArnsResponseFetcher();
    }

    public Iterator<ListManagedSchemaArnsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListManagedSchemaArnsResponseFetcher
    implements SyncPageFetcher<ListManagedSchemaArnsResponse> {
        private ListManagedSchemaArnsResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedSchemaArnsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListManagedSchemaArnsResponse nextPage(ListManagedSchemaArnsResponse previousPage) {
            if (previousPage == null) {
                return ListManagedSchemaArnsIterable.this.client.listManagedSchemaArns(ListManagedSchemaArnsIterable.this.firstRequest);
            }
            return ListManagedSchemaArnsIterable.this.client.listManagedSchemaArns((ListManagedSchemaArnsRequest)((Object)ListManagedSchemaArnsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

