/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ConfiguredTableAnalysisRuleType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConfiguredTableAnalysisRuleRequest
extends CleanRoomsRequest
implements ToCopyableBuilder<Builder, GetConfiguredTableAnalysisRuleRequest> {
    private static final SdkField<String> CONFIGURED_TABLE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredTableIdentifier").getter(GetConfiguredTableAnalysisRuleRequest.getter(GetConfiguredTableAnalysisRuleRequest::configuredTableIdentifier)).setter(GetConfiguredTableAnalysisRuleRequest.setter(Builder::configuredTableIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("configuredTableIdentifier").build()}).build();
    private static final SdkField<String> ANALYSIS_RULE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("analysisRuleType").getter(GetConfiguredTableAnalysisRuleRequest.getter(GetConfiguredTableAnalysisRuleRequest::analysisRuleTypeAsString)).setter(GetConfiguredTableAnalysisRuleRequest.setter(Builder::analysisRuleType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("analysisRuleType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURED_TABLE_IDENTIFIER_FIELD, ANALYSIS_RULE_TYPE_FIELD));
    private final String configuredTableIdentifier;
    private final String analysisRuleType;

    private GetConfiguredTableAnalysisRuleRequest(BuilderImpl builder) {
        super(builder);
        this.configuredTableIdentifier = builder.configuredTableIdentifier;
        this.analysisRuleType = builder.analysisRuleType;
    }

    public final String configuredTableIdentifier() {
        return this.configuredTableIdentifier;
    }

    public final ConfiguredTableAnalysisRuleType analysisRuleType() {
        return ConfiguredTableAnalysisRuleType.fromValue(this.analysisRuleType);
    }

    public final String analysisRuleTypeAsString() {
        return this.analysisRuleType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredTableIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisRuleTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfiguredTableAnalysisRuleRequest)) {
            return false;
        }
        GetConfiguredTableAnalysisRuleRequest other = (GetConfiguredTableAnalysisRuleRequest)((Object)obj);
        return Objects.equals(this.configuredTableIdentifier(), other.configuredTableIdentifier()) && Objects.equals(this.analysisRuleTypeAsString(), other.analysisRuleTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetConfiguredTableAnalysisRuleRequest").add("ConfiguredTableIdentifier", (Object)this.configuredTableIdentifier()).add("AnalysisRuleType", (Object)this.analysisRuleTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configuredTableIdentifier": {
                return Optional.ofNullable(clazz.cast(this.configuredTableIdentifier()));
            }
            case "analysisRuleType": {
                return Optional.ofNullable(clazz.cast(this.analysisRuleTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConfiguredTableAnalysisRuleRequest, T> g) {
        return obj -> g.apply((GetConfiguredTableAnalysisRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsRequest.BuilderImpl
    implements Builder {
        private String configuredTableIdentifier;
        private String analysisRuleType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfiguredTableAnalysisRuleRequest model) {
            super(model);
            this.configuredTableIdentifier(model.configuredTableIdentifier);
            this.analysisRuleType(model.analysisRuleType);
        }

        public final String getConfiguredTableIdentifier() {
            return this.configuredTableIdentifier;
        }

        public final void setConfiguredTableIdentifier(String configuredTableIdentifier) {
            this.configuredTableIdentifier = configuredTableIdentifier;
        }

        @Override
        public final Builder configuredTableIdentifier(String configuredTableIdentifier) {
            this.configuredTableIdentifier = configuredTableIdentifier;
            return this;
        }

        public final String getAnalysisRuleType() {
            return this.analysisRuleType;
        }

        public final void setAnalysisRuleType(String analysisRuleType) {
            this.analysisRuleType = analysisRuleType;
        }

        @Override
        public final Builder analysisRuleType(String analysisRuleType) {
            this.analysisRuleType = analysisRuleType;
            return this;
        }

        @Override
        public final Builder analysisRuleType(ConfiguredTableAnalysisRuleType analysisRuleType) {
            this.analysisRuleType(analysisRuleType == null ? null : analysisRuleType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetConfiguredTableAnalysisRuleRequest build() {
            return new GetConfiguredTableAnalysisRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CleanRoomsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConfiguredTableAnalysisRuleRequest> {
        public Builder configuredTableIdentifier(String var1);

        public Builder analysisRuleType(String var1);

        public Builder analysisRuleType(ConfiguredTableAnalysisRuleType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

