/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChimeSdkMessagingRequest;
import software.amazon.awssdk.services.chimesdkmessaging.model.StreamingConfiguration;
import software.amazon.awssdk.services.chimesdkmessaging.model.StreamingConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutMessagingStreamingConfigurationsRequest
extends ChimeSdkMessagingRequest
implements ToCopyableBuilder<Builder, PutMessagingStreamingConfigurationsRequest> {
    private static final SdkField<String> APP_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppInstanceArn").getter(PutMessagingStreamingConfigurationsRequest.getter(PutMessagingStreamingConfigurationsRequest::appInstanceArn)).setter(PutMessagingStreamingConfigurationsRequest.setter(Builder::appInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appInstanceArn").build()}).build();
    private static final SdkField<List<StreamingConfiguration>> STREAMING_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StreamingConfigurations").getter(PutMessagingStreamingConfigurationsRequest.getter(PutMessagingStreamingConfigurationsRequest::streamingConfigurations)).setter(PutMessagingStreamingConfigurationsRequest.setter(Builder::streamingConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StreamingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_ARN_FIELD, STREAMING_CONFIGURATIONS_FIELD));
    private final String appInstanceArn;
    private final List<StreamingConfiguration> streamingConfigurations;

    private PutMessagingStreamingConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.appInstanceArn = builder.appInstanceArn;
        this.streamingConfigurations = builder.streamingConfigurations;
    }

    public final String appInstanceArn() {
        return this.appInstanceArn;
    }

    public final boolean hasStreamingConfigurations() {
        return this.streamingConfigurations != null && !(this.streamingConfigurations instanceof SdkAutoConstructList);
    }

    public final List<StreamingConfiguration> streamingConfigurations() {
        return this.streamingConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStreamingConfigurations() ? this.streamingConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMessagingStreamingConfigurationsRequest)) {
            return false;
        }
        PutMessagingStreamingConfigurationsRequest other = (PutMessagingStreamingConfigurationsRequest)((Object)obj);
        return Objects.equals(this.appInstanceArn(), other.appInstanceArn()) && this.hasStreamingConfigurations() == other.hasStreamingConfigurations() && Objects.equals(this.streamingConfigurations(), other.streamingConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"PutMessagingStreamingConfigurationsRequest").add("AppInstanceArn", (Object)this.appInstanceArn()).add("StreamingConfigurations", this.hasStreamingConfigurations() ? this.streamingConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.appInstanceArn()));
            }
            case "StreamingConfigurations": {
                return Optional.ofNullable(clazz.cast(this.streamingConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutMessagingStreamingConfigurationsRequest, T> g) {
        return obj -> g.apply((PutMessagingStreamingConfigurationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMessagingRequest.BuilderImpl
    implements Builder {
        private String appInstanceArn;
        private List<StreamingConfiguration> streamingConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutMessagingStreamingConfigurationsRequest model) {
            super(model);
            this.appInstanceArn(model.appInstanceArn);
            this.streamingConfigurations(model.streamingConfigurations);
        }

        public final String getAppInstanceArn() {
            return this.appInstanceArn;
        }

        public final void setAppInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
        }

        @Override
        public final Builder appInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
            return this;
        }

        public final List<StreamingConfiguration.Builder> getStreamingConfigurations() {
            List<StreamingConfiguration.Builder> result = StreamingConfigurationListCopier.copyToBuilder(this.streamingConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStreamingConfigurations(Collection<StreamingConfiguration.BuilderImpl> streamingConfigurations) {
            this.streamingConfigurations = StreamingConfigurationListCopier.copyFromBuilder(streamingConfigurations);
        }

        @Override
        public final Builder streamingConfigurations(Collection<StreamingConfiguration> streamingConfigurations) {
            this.streamingConfigurations = StreamingConfigurationListCopier.copy(streamingConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamingConfigurations(StreamingConfiguration ... streamingConfigurations) {
            this.streamingConfigurations(Arrays.asList(streamingConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamingConfigurations(Consumer<StreamingConfiguration.Builder> ... streamingConfigurations) {
            this.streamingConfigurations(Stream.of(streamingConfigurations).map(c -> (StreamingConfiguration)((StreamingConfiguration.Builder)StreamingConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutMessagingStreamingConfigurationsRequest build() {
            return new PutMessagingStreamingConfigurationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeSdkMessagingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutMessagingStreamingConfigurationsRequest> {
        public Builder appInstanceArn(String var1);

        public Builder streamingConfigurations(Collection<StreamingConfiguration> var1);

        public Builder streamingConfigurations(StreamingConfiguration ... var1);

        public Builder streamingConfigurations(Consumer<StreamingConfiguration.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

