/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The resource target configurations for receiving Amazon Chime SDK meeting and attendee event notifications. The
 * Amazon Chime SDK supports resource targets located in the US East (N. Virginia) AWS Region (<code>us-east-1</code>).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MeetingNotificationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MeetingNotificationConfiguration.Builder, MeetingNotificationConfiguration> {
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsTopicArn").getter(getter(MeetingNotificationConfiguration::snsTopicArn))
            .setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()).build();

    private static final SdkField<String> SQS_QUEUE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SqsQueueArn").getter(getter(MeetingNotificationConfiguration::sqsQueueArn))
            .setter(setter(Builder::sqsQueueArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqsQueueArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNS_TOPIC_ARN_FIELD,
            SQS_QUEUE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String snsTopicArn;

    private final String sqsQueueArn;

    private MeetingNotificationConfiguration(BuilderImpl builder) {
        this.snsTopicArn = builder.snsTopicArn;
        this.sqsQueueArn = builder.sqsQueueArn;
    }

    /**
     * <p>
     * The SNS topic ARN.
     * </p>
     * 
     * @return The SNS topic ARN.
     */
    public final String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * <p>
     * The SQS queue ARN.
     * </p>
     * 
     * @return The SQS queue ARN.
     */
    public final String sqsQueueArn() {
        return sqsQueueArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(sqsQueueArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MeetingNotificationConfiguration)) {
            return false;
        }
        MeetingNotificationConfiguration other = (MeetingNotificationConfiguration) obj;
        return Objects.equals(snsTopicArn(), other.snsTopicArn()) && Objects.equals(sqsQueueArn(), other.sqsQueueArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MeetingNotificationConfiguration")
                .add("SnsTopicArn", snsTopicArn() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SqsQueueArn", sqsQueueArn() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnsTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        case "SqsQueueArn":
            return Optional.ofNullable(clazz.cast(sqsQueueArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MeetingNotificationConfiguration, T> g) {
        return obj -> g.apply((MeetingNotificationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MeetingNotificationConfiguration> {
        /**
         * <p>
         * The SNS topic ARN.
         * </p>
         * 
         * @param snsTopicArn
         *        The SNS topic ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * <p>
         * The SQS queue ARN.
         * </p>
         * 
         * @param sqsQueueArn
         *        The SQS queue ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqsQueueArn(String sqsQueueArn);
    }

    static final class BuilderImpl implements Builder {
        private String snsTopicArn;

        private String sqsQueueArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MeetingNotificationConfiguration model) {
            snsTopicArn(model.snsTopicArn);
            sqsQueueArn(model.sqsQueueArn);
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final String getSqsQueueArn() {
            return sqsQueueArn;
        }

        public final void setSqsQueueArn(String sqsQueueArn) {
            this.sqsQueueArn = sqsQueueArn;
        }

        @Override
        public final Builder sqsQueueArn(String sqsQueueArn) {
            this.sqsQueueArn = sqsQueueArn;
            return this;
        }

        @Override
        public MeetingNotificationConfiguration build() {
            return new MeetingNotificationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
