/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedactRoomMessageRequest extends ChimeRequest implements
        ToCopyableBuilder<RedactRoomMessageRequest.Builder, RedactRoomMessageRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(RedactRoomMessageRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("accountId").build()).build();

    private static final SdkField<String> ROOM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RoomId")
            .getter(getter(RedactRoomMessageRequest::roomId)).setter(setter(Builder::roomId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("roomId").build()).build();

    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageId").getter(getter(RedactRoomMessageRequest::messageId)).setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("messageId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            ROOM_ID_FIELD, MESSAGE_ID_FIELD));

    private final String accountId;

    private final String roomId;

    private final String messageId;

    private RedactRoomMessageRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.roomId = builder.roomId;
        this.messageId = builder.messageId;
    }

    /**
     * <p>
     * The Amazon Chime account ID.
     * </p>
     * 
     * @return The Amazon Chime account ID.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The room ID.
     * </p>
     * 
     * @return The room ID.
     */
    public final String roomId() {
        return roomId;
    }

    /**
     * <p>
     * The message ID.
     * </p>
     * 
     * @return The message ID.
     */
    public final String messageId() {
        return messageId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(roomId());
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedactRoomMessageRequest)) {
            return false;
        }
        RedactRoomMessageRequest other = (RedactRoomMessageRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(roomId(), other.roomId())
                && Objects.equals(messageId(), other.messageId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedactRoomMessageRequest").add("AccountId", accountId()).add("RoomId", roomId())
                .add("MessageId", messageId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "RoomId":
            return Optional.ofNullable(clazz.cast(roomId()));
        case "MessageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RedactRoomMessageRequest, T> g) {
        return obj -> g.apply((RedactRoomMessageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, RedactRoomMessageRequest> {
        /**
         * <p>
         * The Amazon Chime account ID.
         * </p>
         * 
         * @param accountId
         *        The Amazon Chime account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The room ID.
         * </p>
         * 
         * @param roomId
         *        The room ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomId(String roomId);

        /**
         * <p>
         * The message ID.
         * </p>
         * 
         * @param messageId
         *        The message ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String accountId;

        private String roomId;

        private String messageId;

        private BuilderImpl() {
        }

        private BuilderImpl(RedactRoomMessageRequest model) {
            super(model);
            accountId(model.accountId);
            roomId(model.roomId);
            messageId(model.messageId);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getRoomId() {
            return roomId;
        }

        public final void setRoomId(String roomId) {
            this.roomId = roomId;
        }

        @Override
        public final Builder roomId(String roomId) {
            this.roomId = roomId;
            return this;
        }

        public final String getMessageId() {
            return messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RedactRoomMessageRequest build() {
            return new RedactRoomMessageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
