/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRoomMembershipsResponse extends ChimeResponse implements
        ToCopyableBuilder<ListRoomMembershipsResponse.Builder, ListRoomMembershipsResponse> {
    private static final SdkField<List<RoomMembership>> ROOM_MEMBERSHIPS_FIELD = SdkField
            .<List<RoomMembership>> builder(MarshallingType.LIST)
            .memberName("RoomMemberships")
            .getter(getter(ListRoomMembershipsResponse::roomMemberships))
            .setter(setter(Builder::roomMemberships))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomMemberships").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RoomMembership> builder(MarshallingType.SDK_POJO)
                                            .constructor(RoomMembership::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRoomMembershipsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOM_MEMBERSHIPS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<RoomMembership> roomMemberships;

    private final String nextToken;

    private ListRoomMembershipsResponse(BuilderImpl builder) {
        super(builder);
        this.roomMemberships = builder.roomMemberships;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the RoomMemberships property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRoomMemberships() {
        return roomMemberships != null && !(roomMemberships instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The room membership details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoomMemberships} method.
     * </p>
     * 
     * @return The room membership details.
     */
    public final List<RoomMembership> roomMemberships() {
        return roomMemberships;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRoomMemberships() ? roomMemberships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRoomMembershipsResponse)) {
            return false;
        }
        ListRoomMembershipsResponse other = (ListRoomMembershipsResponse) obj;
        return hasRoomMemberships() == other.hasRoomMemberships() && Objects.equals(roomMemberships(), other.roomMemberships())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRoomMembershipsResponse")
                .add("RoomMemberships", hasRoomMemberships() ? roomMemberships() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoomMemberships":
            return Optional.ofNullable(clazz.cast(roomMemberships()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRoomMembershipsResponse, T> g) {
        return obj -> g.apply((ListRoomMembershipsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRoomMembershipsResponse> {
        /**
         * <p>
         * The room membership details.
         * </p>
         * 
         * @param roomMemberships
         *        The room membership details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomMemberships(Collection<RoomMembership> roomMemberships);

        /**
         * <p>
         * The room membership details.
         * </p>
         * 
         * @param roomMemberships
         *        The room membership details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomMemberships(RoomMembership... roomMemberships);

        /**
         * <p>
         * The room membership details.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chime.model.RoomMembership.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.chime.model.RoomMembership#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chime.model.RoomMembership.Builder#build()} is called immediately and
         * its result is passed to {@link #roomMemberships(List<RoomMembership>)}.
         * 
         * @param roomMemberships
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chime.model.RoomMembership.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #roomMemberships(java.util.Collection<RoomMembership>)
         */
        Builder roomMemberships(Consumer<RoomMembership.Builder>... roomMemberships);

        /**
         * <p>
         * The token to use to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private List<RoomMembership> roomMemberships = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRoomMembershipsResponse model) {
            super(model);
            roomMemberships(model.roomMemberships);
            nextToken(model.nextToken);
        }

        public final List<RoomMembership.Builder> getRoomMemberships() {
            List<RoomMembership.Builder> result = RoomMembershipListCopier.copyToBuilder(this.roomMemberships);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoomMemberships(Collection<RoomMembership.BuilderImpl> roomMemberships) {
            this.roomMemberships = RoomMembershipListCopier.copyFromBuilder(roomMemberships);
        }

        @Override
        public final Builder roomMemberships(Collection<RoomMembership> roomMemberships) {
            this.roomMemberships = RoomMembershipListCopier.copy(roomMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roomMemberships(RoomMembership... roomMemberships) {
            roomMemberships(Arrays.asList(roomMemberships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roomMemberships(Consumer<RoomMembership.Builder>... roomMemberships) {
            roomMemberships(Stream.of(roomMemberships).map(c -> RoomMembership.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRoomMembershipsResponse build() {
            return new ListRoomMembershipsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
