/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSipMediaApplicationCallRequest extends ChimeRequest implements
        ToCopyableBuilder<CreateSipMediaApplicationCallRequest.Builder, CreateSipMediaApplicationCallRequest> {
    private static final SdkField<String> FROM_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FromPhoneNumber").getter(getter(CreateSipMediaApplicationCallRequest::fromPhoneNumber))
            .setter(setter(Builder::fromPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromPhoneNumber").build()).build();

    private static final SdkField<String> TO_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ToPhoneNumber").getter(getter(CreateSipMediaApplicationCallRequest::toPhoneNumber))
            .setter(setter(Builder::toPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToPhoneNumber").build()).build();

    private static final SdkField<String> SIP_MEDIA_APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SipMediaApplicationId").getter(getter(CreateSipMediaApplicationCallRequest::sipMediaApplicationId))
            .setter(setter(Builder::sipMediaApplicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sipMediaApplicationId").build())
            .build();

    private static final SdkField<Map<String, String>> SIP_HEADERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("SipHeaders")
            .getter(getter(CreateSipMediaApplicationCallRequest::sipHeaders))
            .setter(setter(Builder::sipHeaders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SipHeaders").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_PHONE_NUMBER_FIELD,
            TO_PHONE_NUMBER_FIELD, SIP_MEDIA_APPLICATION_ID_FIELD, SIP_HEADERS_FIELD));

    private final String fromPhoneNumber;

    private final String toPhoneNumber;

    private final String sipMediaApplicationId;

    private final Map<String, String> sipHeaders;

    private CreateSipMediaApplicationCallRequest(BuilderImpl builder) {
        super(builder);
        this.fromPhoneNumber = builder.fromPhoneNumber;
        this.toPhoneNumber = builder.toPhoneNumber;
        this.sipMediaApplicationId = builder.sipMediaApplicationId;
        this.sipHeaders = builder.sipHeaders;
    }

    /**
     * <p>
     * The phone number that a user calls from. This is a phone number in your Amazon Chime phone number inventory.
     * </p>
     * 
     * @return The phone number that a user calls from. This is a phone number in your Amazon Chime phone number
     *         inventory.
     */
    public final String fromPhoneNumber() {
        return fromPhoneNumber;
    }

    /**
     * <p>
     * The phone number that the service should call.
     * </p>
     * 
     * @return The phone number that the service should call.
     */
    public final String toPhoneNumber() {
        return toPhoneNumber;
    }

    /**
     * <p>
     * The ID of the SIP media application.
     * </p>
     * 
     * @return The ID of the SIP media application.
     */
    public final String sipMediaApplicationId() {
        return sipMediaApplicationId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SipHeaders property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSipHeaders() {
        return sipHeaders != null && !(sipHeaders instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The SIP headers added to an outbound call leg.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSipHeaders} method.
     * </p>
     * 
     * @return The SIP headers added to an outbound call leg.
     */
    public final Map<String, String> sipHeaders() {
        return sipHeaders;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fromPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(toPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(sipMediaApplicationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSipHeaders() ? sipHeaders() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSipMediaApplicationCallRequest)) {
            return false;
        }
        CreateSipMediaApplicationCallRequest other = (CreateSipMediaApplicationCallRequest) obj;
        return Objects.equals(fromPhoneNumber(), other.fromPhoneNumber())
                && Objects.equals(toPhoneNumber(), other.toPhoneNumber())
                && Objects.equals(sipMediaApplicationId(), other.sipMediaApplicationId())
                && hasSipHeaders() == other.hasSipHeaders() && Objects.equals(sipHeaders(), other.sipHeaders());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSipMediaApplicationCallRequest")
                .add("FromPhoneNumber", fromPhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ToPhoneNumber", toPhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SipMediaApplicationId", sipMediaApplicationId())
                .add("SipHeaders", sipHeaders() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FromPhoneNumber":
            return Optional.ofNullable(clazz.cast(fromPhoneNumber()));
        case "ToPhoneNumber":
            return Optional.ofNullable(clazz.cast(toPhoneNumber()));
        case "SipMediaApplicationId":
            return Optional.ofNullable(clazz.cast(sipMediaApplicationId()));
        case "SipHeaders":
            return Optional.ofNullable(clazz.cast(sipHeaders()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSipMediaApplicationCallRequest, T> g) {
        return obj -> g.apply((CreateSipMediaApplicationCallRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSipMediaApplicationCallRequest> {
        /**
         * <p>
         * The phone number that a user calls from. This is a phone number in your Amazon Chime phone number inventory.
         * </p>
         * 
         * @param fromPhoneNumber
         *        The phone number that a user calls from. This is a phone number in your Amazon Chime phone number
         *        inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPhoneNumber(String fromPhoneNumber);

        /**
         * <p>
         * The phone number that the service should call.
         * </p>
         * 
         * @param toPhoneNumber
         *        The phone number that the service should call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toPhoneNumber(String toPhoneNumber);

        /**
         * <p>
         * The ID of the SIP media application.
         * </p>
         * 
         * @param sipMediaApplicationId
         *        The ID of the SIP media application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sipMediaApplicationId(String sipMediaApplicationId);

        /**
         * <p>
         * The SIP headers added to an outbound call leg.
         * </p>
         * 
         * @param sipHeaders
         *        The SIP headers added to an outbound call leg.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sipHeaders(Map<String, String> sipHeaders);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String fromPhoneNumber;

        private String toPhoneNumber;

        private String sipMediaApplicationId;

        private Map<String, String> sipHeaders = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSipMediaApplicationCallRequest model) {
            super(model);
            fromPhoneNumber(model.fromPhoneNumber);
            toPhoneNumber(model.toPhoneNumber);
            sipMediaApplicationId(model.sipMediaApplicationId);
            sipHeaders(model.sipHeaders);
        }

        public final String getFromPhoneNumber() {
            return fromPhoneNumber;
        }

        public final void setFromPhoneNumber(String fromPhoneNumber) {
            this.fromPhoneNumber = fromPhoneNumber;
        }

        @Override
        public final Builder fromPhoneNumber(String fromPhoneNumber) {
            this.fromPhoneNumber = fromPhoneNumber;
            return this;
        }

        public final String getToPhoneNumber() {
            return toPhoneNumber;
        }

        public final void setToPhoneNumber(String toPhoneNumber) {
            this.toPhoneNumber = toPhoneNumber;
        }

        @Override
        public final Builder toPhoneNumber(String toPhoneNumber) {
            this.toPhoneNumber = toPhoneNumber;
            return this;
        }

        public final String getSipMediaApplicationId() {
            return sipMediaApplicationId;
        }

        public final void setSipMediaApplicationId(String sipMediaApplicationId) {
            this.sipMediaApplicationId = sipMediaApplicationId;
        }

        @Override
        public final Builder sipMediaApplicationId(String sipMediaApplicationId) {
            this.sipMediaApplicationId = sipMediaApplicationId;
            return this;
        }

        public final Map<String, String> getSipHeaders() {
            if (sipHeaders instanceof SdkAutoConstructMap) {
                return null;
            }
            return sipHeaders;
        }

        public final void setSipHeaders(Map<String, String> sipHeaders) {
            this.sipHeaders = SipHeadersMapCopier.copy(sipHeaders);
        }

        @Override
        public final Builder sipHeaders(Map<String, String> sipHeaders) {
            this.sipHeaders = SipHeadersMapCopier.copy(sipHeaders);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSipMediaApplicationCallRequest build() {
            return new CreateSipMediaApplicationCallRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
