/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters that determine the budget amount for an auto-adjusting budget.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoAdjustData implements SdkPojo, Serializable, ToCopyableBuilder<AutoAdjustData.Builder, AutoAdjustData> {
    private static final SdkField<String> AUTO_ADJUST_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoAdjustType").getter(getter(AutoAdjustData::autoAdjustTypeAsString))
            .setter(setter(Builder::autoAdjustType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAdjustType").build()).build();

    private static final SdkField<HistoricalOptions> HISTORICAL_OPTIONS_FIELD = SdkField
            .<HistoricalOptions> builder(MarshallingType.SDK_POJO).memberName("HistoricalOptions")
            .getter(getter(AutoAdjustData::historicalOptions)).setter(setter(Builder::historicalOptions))
            .constructor(HistoricalOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HistoricalOptions").build()).build();

    private static final SdkField<Instant> LAST_AUTO_ADJUST_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastAutoAdjustTime").getter(getter(AutoAdjustData::lastAutoAdjustTime))
            .setter(setter(Builder::lastAutoAdjustTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAutoAdjustTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ADJUST_TYPE_FIELD,
            HISTORICAL_OPTIONS_FIELD, LAST_AUTO_ADJUST_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String autoAdjustType;

    private final HistoricalOptions historicalOptions;

    private final Instant lastAutoAdjustTime;

    private AutoAdjustData(BuilderImpl builder) {
        this.autoAdjustType = builder.autoAdjustType;
        this.historicalOptions = builder.historicalOptions;
        this.lastAutoAdjustTime = builder.lastAutoAdjustTime;
    }

    /**
     * <p>
     * The string that defines whether your budget auto-adjusts based on historical or forecasted data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoAdjustType}
     * will return {@link AutoAdjustType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #autoAdjustTypeAsString}.
     * </p>
     * 
     * @return The string that defines whether your budget auto-adjusts based on historical or forecasted data.
     * @see AutoAdjustType
     */
    public final AutoAdjustType autoAdjustType() {
        return AutoAdjustType.fromValue(autoAdjustType);
    }

    /**
     * <p>
     * The string that defines whether your budget auto-adjusts based on historical or forecasted data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoAdjustType}
     * will return {@link AutoAdjustType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #autoAdjustTypeAsString}.
     * </p>
     * 
     * @return The string that defines whether your budget auto-adjusts based on historical or forecasted data.
     * @see AutoAdjustType
     */
    public final String autoAdjustTypeAsString() {
        return autoAdjustType;
    }

    /**
     * <p>
     * The parameters that define or describe the historical data that your auto-adjusting budget is based on.
     * </p>
     * 
     * @return The parameters that define or describe the historical data that your auto-adjusting budget is based on.
     */
    public final HistoricalOptions historicalOptions() {
        return historicalOptions;
    }

    /**
     * <p>
     * The last time that your budget was auto-adjusted.
     * </p>
     * 
     * @return The last time that your budget was auto-adjusted.
     */
    public final Instant lastAutoAdjustTime() {
        return lastAutoAdjustTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoAdjustTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(historicalOptions());
        hashCode = 31 * hashCode + Objects.hashCode(lastAutoAdjustTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoAdjustData)) {
            return false;
        }
        AutoAdjustData other = (AutoAdjustData) obj;
        return Objects.equals(autoAdjustTypeAsString(), other.autoAdjustTypeAsString())
                && Objects.equals(historicalOptions(), other.historicalOptions())
                && Objects.equals(lastAutoAdjustTime(), other.lastAutoAdjustTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoAdjustData").add("AutoAdjustType", autoAdjustTypeAsString())
                .add("HistoricalOptions", historicalOptions()).add("LastAutoAdjustTime", lastAutoAdjustTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoAdjustType":
            return Optional.ofNullable(clazz.cast(autoAdjustTypeAsString()));
        case "HistoricalOptions":
            return Optional.ofNullable(clazz.cast(historicalOptions()));
        case "LastAutoAdjustTime":
            return Optional.ofNullable(clazz.cast(lastAutoAdjustTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoAdjustData, T> g) {
        return obj -> g.apply((AutoAdjustData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoAdjustData> {
        /**
         * <p>
         * The string that defines whether your budget auto-adjusts based on historical or forecasted data.
         * </p>
         * 
         * @param autoAdjustType
         *        The string that defines whether your budget auto-adjusts based on historical or forecasted data.
         * @see AutoAdjustType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoAdjustType
         */
        Builder autoAdjustType(String autoAdjustType);

        /**
         * <p>
         * The string that defines whether your budget auto-adjusts based on historical or forecasted data.
         * </p>
         * 
         * @param autoAdjustType
         *        The string that defines whether your budget auto-adjusts based on historical or forecasted data.
         * @see AutoAdjustType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoAdjustType
         */
        Builder autoAdjustType(AutoAdjustType autoAdjustType);

        /**
         * <p>
         * The parameters that define or describe the historical data that your auto-adjusting budget is based on.
         * </p>
         * 
         * @param historicalOptions
         *        The parameters that define or describe the historical data that your auto-adjusting budget is based
         *        on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder historicalOptions(HistoricalOptions historicalOptions);

        /**
         * <p>
         * The parameters that define or describe the historical data that your auto-adjusting budget is based on.
         * </p>
         * This is a convenience method that creates an instance of the {@link HistoricalOptions.Builder} avoiding the
         * need to create one manually via {@link HistoricalOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HistoricalOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #historicalOptions(HistoricalOptions)}.
         * 
         * @param historicalOptions
         *        a consumer that will call methods on {@link HistoricalOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #historicalOptions(HistoricalOptions)
         */
        default Builder historicalOptions(Consumer<HistoricalOptions.Builder> historicalOptions) {
            return historicalOptions(HistoricalOptions.builder().applyMutation(historicalOptions).build());
        }

        /**
         * <p>
         * The last time that your budget was auto-adjusted.
         * </p>
         * 
         * @param lastAutoAdjustTime
         *        The last time that your budget was auto-adjusted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAutoAdjustTime(Instant lastAutoAdjustTime);
    }

    static final class BuilderImpl implements Builder {
        private String autoAdjustType;

        private HistoricalOptions historicalOptions;

        private Instant lastAutoAdjustTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoAdjustData model) {
            autoAdjustType(model.autoAdjustType);
            historicalOptions(model.historicalOptions);
            lastAutoAdjustTime(model.lastAutoAdjustTime);
        }

        public final String getAutoAdjustType() {
            return autoAdjustType;
        }

        public final void setAutoAdjustType(String autoAdjustType) {
            this.autoAdjustType = autoAdjustType;
        }

        @Override
        public final Builder autoAdjustType(String autoAdjustType) {
            this.autoAdjustType = autoAdjustType;
            return this;
        }

        @Override
        public final Builder autoAdjustType(AutoAdjustType autoAdjustType) {
            this.autoAdjustType(autoAdjustType == null ? null : autoAdjustType.toString());
            return this;
        }

        public final HistoricalOptions.Builder getHistoricalOptions() {
            return historicalOptions != null ? historicalOptions.toBuilder() : null;
        }

        public final void setHistoricalOptions(HistoricalOptions.BuilderImpl historicalOptions) {
            this.historicalOptions = historicalOptions != null ? historicalOptions.build() : null;
        }

        @Override
        public final Builder historicalOptions(HistoricalOptions historicalOptions) {
            this.historicalOptions = historicalOptions;
            return this;
        }

        public final Instant getLastAutoAdjustTime() {
            return lastAutoAdjustTime;
        }

        public final void setLastAutoAdjustTime(Instant lastAutoAdjustTime) {
            this.lastAutoAdjustTime = lastAutoAdjustTime;
        }

        @Override
        public final Builder lastAutoAdjustTime(Instant lastAutoAdjustTime) {
            this.lastAutoAdjustTime = lastAutoAdjustTime;
            return this;
        }

        @Override
        public AutoAdjustData build() {
            return new AutoAdjustData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
