/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.KnowledgeBaseType;
import software.amazon.awssdk.services.bedrockagent.model.VectorKnowledgeBaseConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KnowledgeBaseConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KnowledgeBaseConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(KnowledgeBaseConfiguration.getter(KnowledgeBaseConfiguration::typeAsString)).setter(KnowledgeBaseConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<VectorKnowledgeBaseConfiguration> VECTOR_KNOWLEDGE_BASE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vectorKnowledgeBaseConfiguration").getter(KnowledgeBaseConfiguration.getter(KnowledgeBaseConfiguration::vectorKnowledgeBaseConfiguration)).setter(KnowledgeBaseConfiguration.setter(Builder::vectorKnowledgeBaseConfiguration)).constructor(VectorKnowledgeBaseConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorKnowledgeBaseConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, VECTOR_KNOWLEDGE_BASE_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final VectorKnowledgeBaseConfiguration vectorKnowledgeBaseConfiguration;

    private KnowledgeBaseConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.vectorKnowledgeBaseConfiguration = builder.vectorKnowledgeBaseConfiguration;
    }

    public final KnowledgeBaseType type() {
        return KnowledgeBaseType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final VectorKnowledgeBaseConfiguration vectorKnowledgeBaseConfiguration() {
        return this.vectorKnowledgeBaseConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vectorKnowledgeBaseConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseConfiguration)) {
            return false;
        }
        KnowledgeBaseConfiguration other = (KnowledgeBaseConfiguration)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.vectorKnowledgeBaseConfiguration(), other.vectorKnowledgeBaseConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"KnowledgeBaseConfiguration").add("Type", (Object)this.typeAsString()).add("VectorKnowledgeBaseConfiguration", (Object)this.vectorKnowledgeBaseConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "vectorKnowledgeBaseConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vectorKnowledgeBaseConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseConfiguration, T> g) {
        return obj -> g.apply((KnowledgeBaseConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private VectorKnowledgeBaseConfiguration vectorKnowledgeBaseConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseConfiguration model) {
            this.type(model.type);
            this.vectorKnowledgeBaseConfiguration(model.vectorKnowledgeBaseConfiguration);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(KnowledgeBaseType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final VectorKnowledgeBaseConfiguration.Builder getVectorKnowledgeBaseConfiguration() {
            return this.vectorKnowledgeBaseConfiguration != null ? this.vectorKnowledgeBaseConfiguration.toBuilder() : null;
        }

        public final void setVectorKnowledgeBaseConfiguration(VectorKnowledgeBaseConfiguration.BuilderImpl vectorKnowledgeBaseConfiguration) {
            this.vectorKnowledgeBaseConfiguration = vectorKnowledgeBaseConfiguration != null ? vectorKnowledgeBaseConfiguration.build() : null;
        }

        @Override
        public final Builder vectorKnowledgeBaseConfiguration(VectorKnowledgeBaseConfiguration vectorKnowledgeBaseConfiguration) {
            this.vectorKnowledgeBaseConfiguration = vectorKnowledgeBaseConfiguration;
            return this;
        }

        public KnowledgeBaseConfiguration build() {
            return new KnowledgeBaseConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KnowledgeBaseConfiguration> {
        public Builder type(String var1);

        public Builder type(KnowledgeBaseType var1);

        public Builder vectorKnowledgeBaseConfiguration(VectorKnowledgeBaseConfiguration var1);

        default public Builder vectorKnowledgeBaseConfiguration(Consumer<VectorKnowledgeBaseConfiguration.Builder> vectorKnowledgeBaseConfiguration) {
            return this.vectorKnowledgeBaseConfiguration((VectorKnowledgeBaseConfiguration)((VectorKnowledgeBaseConfiguration.Builder)VectorKnowledgeBaseConfiguration.builder().applyMutation(vectorKnowledgeBaseConfiguration)).build());
        }
    }
}

