/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIngestionJobRequest
extends BedrockAgentRequest
implements ToCopyableBuilder<Builder, GetIngestionJobRequest> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(GetIngestionJobRequest.getter(GetIngestionJobRequest::knowledgeBaseId)).setter(GetIngestionJobRequest.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceId").getter(GetIngestionJobRequest.getter(GetIngestionJobRequest::dataSourceId)).setter(GetIngestionJobRequest.setter(Builder::dataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("dataSourceId").build()}).build();
    private static final SdkField<String> INGESTION_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ingestionJobId").getter(GetIngestionJobRequest.getter(GetIngestionJobRequest::ingestionJobId)).setter(GetIngestionJobRequest.setter(Builder::ingestionJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ingestionJobId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD, DATA_SOURCE_ID_FIELD, INGESTION_JOB_ID_FIELD));
    private final String knowledgeBaseId;
    private final String dataSourceId;
    private final String ingestionJobId;

    private GetIngestionJobRequest(BuilderImpl builder) {
        super(builder);
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.dataSourceId = builder.dataSourceId;
        this.ingestionJobId = builder.ingestionJobId;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final String dataSourceId() {
        return this.dataSourceId;
    }

    public final String ingestionJobId() {
        return this.ingestionJobId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionJobId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIngestionJobRequest)) {
            return false;
        }
        GetIngestionJobRequest other = (GetIngestionJobRequest)((Object)obj);
        return Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.ingestionJobId(), other.ingestionJobId());
    }

    public final String toString() {
        return ToString.builder((String)"GetIngestionJobRequest").add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("DataSourceId", (Object)this.dataSourceId()).add("IngestionJobId", (Object)this.ingestionJobId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "dataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
            case "ingestionJobId": {
                return Optional.ofNullable(clazz.cast(this.ingestionJobId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIngestionJobRequest, T> g) {
        return obj -> g.apply((GetIngestionJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRequest.BuilderImpl
    implements Builder {
        private String knowledgeBaseId;
        private String dataSourceId;
        private String ingestionJobId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIngestionJobRequest model) {
            super(model);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.dataSourceId(model.dataSourceId);
            this.ingestionJobId(model.ingestionJobId);
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getIngestionJobId() {
            return this.ingestionJobId;
        }

        public final void setIngestionJobId(String ingestionJobId) {
            this.ingestionJobId = ingestionJobId;
        }

        @Override
        public final Builder ingestionJobId(String ingestionJobId) {
            this.ingestionJobId = ingestionJobId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetIngestionJobRequest build() {
            return new GetIngestionJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BedrockAgentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIngestionJobRequest> {
        public Builder knowledgeBaseId(String var1);

        public Builder dataSourceId(String var1);

        public Builder ingestionJobId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

