/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.batch.model.FirelensConfiguration;
import software.amazon.awssdk.services.batch.model.KeyValuePair;
import software.amazon.awssdk.services.batch.model.LinuxParameters;
import software.amazon.awssdk.services.batch.model.LogConfiguration;
import software.amazon.awssdk.services.batch.model.MountPoint;
import software.amazon.awssdk.services.batch.model.MountPointsCopier;
import software.amazon.awssdk.services.batch.model.NetworkInterface;
import software.amazon.awssdk.services.batch.model.NetworkInterfaceListCopier;
import software.amazon.awssdk.services.batch.model.RepositoryCredentials;
import software.amazon.awssdk.services.batch.model.ResourceRequirement;
import software.amazon.awssdk.services.batch.model.ResourceRequirementsCopier;
import software.amazon.awssdk.services.batch.model.Secret;
import software.amazon.awssdk.services.batch.model.SecretListCopier;
import software.amazon.awssdk.services.batch.model.StringListCopier;
import software.amazon.awssdk.services.batch.model.TaskContainerDependency;
import software.amazon.awssdk.services.batch.model.TaskContainerDependencyListCopier;
import software.amazon.awssdk.services.batch.model.Ulimit;
import software.amazon.awssdk.services.batch.model.UlimitsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskContainerDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskContainerDetails> {
    private static final SdkField<List<String>> COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("command").getter(TaskContainerDetails.getter(TaskContainerDetails::command)).setter(TaskContainerDetails.setter(Builder::command)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("command").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TaskContainerDependency>> DEPENDS_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dependsOn").getter(TaskContainerDetails.getter(TaskContainerDetails::dependsOn)).setter(TaskContainerDetails.setter(Builder::dependsOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependsOn").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TaskContainerDependency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<KeyValuePair>> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("environment").getter(TaskContainerDetails.getter(TaskContainerDetails::environment)).setter(TaskContainerDetails.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyValuePair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ESSENTIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("essential").getter(TaskContainerDetails.getter(TaskContainerDetails::essential)).setter(TaskContainerDetails.setter(Builder::essential)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("essential").build()}).build();
    private static final SdkField<FirelensConfiguration> FIRELENS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("firelensConfiguration").getter(TaskContainerDetails.getter(TaskContainerDetails::firelensConfiguration)).setter(TaskContainerDetails.setter(Builder::firelensConfiguration)).constructor(FirelensConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firelensConfiguration").build()}).build();
    private static final SdkField<String> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("image").getter(TaskContainerDetails.getter(TaskContainerDetails::image)).setter(TaskContainerDetails.setter(Builder::image)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()}).build();
    private static final SdkField<LinuxParameters> LINUX_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("linuxParameters").getter(TaskContainerDetails.getter(TaskContainerDetails::linuxParameters)).setter(TaskContainerDetails.setter(Builder::linuxParameters)).constructor(LinuxParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linuxParameters").build()}).build();
    private static final SdkField<LogConfiguration> LOG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logConfiguration").getter(TaskContainerDetails.getter(TaskContainerDetails::logConfiguration)).setter(TaskContainerDetails.setter(Builder::logConfiguration)).constructor(LogConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfiguration").build()}).build();
    private static final SdkField<List<MountPoint>> MOUNT_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("mountPoints").getter(TaskContainerDetails.getter(TaskContainerDetails::mountPoints)).setter(TaskContainerDetails.setter(Builder::mountPoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mountPoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MountPoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(TaskContainerDetails.getter(TaskContainerDetails::name)).setter(TaskContainerDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Boolean> PRIVILEGED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("privileged").getter(TaskContainerDetails.getter(TaskContainerDetails::privileged)).setter(TaskContainerDetails.setter(Builder::privileged)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privileged").build()}).build();
    private static final SdkField<Boolean> READONLY_ROOT_FILESYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("readonlyRootFilesystem").getter(TaskContainerDetails.getter(TaskContainerDetails::readonlyRootFilesystem)).setter(TaskContainerDetails.setter(Builder::readonlyRootFilesystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readonlyRootFilesystem").build()}).build();
    private static final SdkField<RepositoryCredentials> REPOSITORY_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("repositoryCredentials").getter(TaskContainerDetails.getter(TaskContainerDetails::repositoryCredentials)).setter(TaskContainerDetails.setter(Builder::repositoryCredentials)).constructor(RepositoryCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryCredentials").build()}).build();
    private static final SdkField<List<ResourceRequirement>> RESOURCE_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceRequirements").getter(TaskContainerDetails.getter(TaskContainerDetails::resourceRequirements)).setter(TaskContainerDetails.setter(Builder::resourceRequirements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceRequirements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceRequirement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Secret>> SECRETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("secrets").getter(TaskContainerDetails.getter(TaskContainerDetails::secrets)).setter(TaskContainerDetails.setter(Builder::secrets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secrets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Secret::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Ulimit>> ULIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ulimits").getter(TaskContainerDetails.getter(TaskContainerDetails::ulimits)).setter(TaskContainerDetails.setter(Builder::ulimits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ulimits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Ulimit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("user").getter(TaskContainerDetails.getter(TaskContainerDetails::user)).setter(TaskContainerDetails.setter(Builder::user)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()}).build();
    private static final SdkField<Integer> EXIT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("exitCode").getter(TaskContainerDetails.getter(TaskContainerDetails::exitCode)).setter(TaskContainerDetails.setter(Builder::exitCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exitCode").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reason").getter(TaskContainerDetails.getter(TaskContainerDetails::reason)).setter(TaskContainerDetails.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final SdkField<String> LOG_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logStreamName").getter(TaskContainerDetails.getter(TaskContainerDetails::logStreamName)).setter(TaskContainerDetails.setter(Builder::logStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamName").build()}).build();
    private static final SdkField<List<NetworkInterface>> NETWORK_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("networkInterfaces").getter(TaskContainerDetails.getter(TaskContainerDetails::networkInterfaces)).setter(TaskContainerDetails.setter(Builder::networkInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_FIELD, DEPENDS_ON_FIELD, ENVIRONMENT_FIELD, ESSENTIAL_FIELD, FIRELENS_CONFIGURATION_FIELD, IMAGE_FIELD, LINUX_PARAMETERS_FIELD, LOG_CONFIGURATION_FIELD, MOUNT_POINTS_FIELD, NAME_FIELD, PRIVILEGED_FIELD, READONLY_ROOT_FILESYSTEM_FIELD, REPOSITORY_CREDENTIALS_FIELD, RESOURCE_REQUIREMENTS_FIELD, SECRETS_FIELD, ULIMITS_FIELD, USER_FIELD, EXIT_CODE_FIELD, REASON_FIELD, LOG_STREAM_NAME_FIELD, NETWORK_INTERFACES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TaskContainerDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> command;
    private final List<TaskContainerDependency> dependsOn;
    private final List<KeyValuePair> environment;
    private final Boolean essential;
    private final FirelensConfiguration firelensConfiguration;
    private final String image;
    private final LinuxParameters linuxParameters;
    private final LogConfiguration logConfiguration;
    private final List<MountPoint> mountPoints;
    private final String name;
    private final Boolean privileged;
    private final Boolean readonlyRootFilesystem;
    private final RepositoryCredentials repositoryCredentials;
    private final List<ResourceRequirement> resourceRequirements;
    private final List<Secret> secrets;
    private final List<Ulimit> ulimits;
    private final String user;
    private final Integer exitCode;
    private final String reason;
    private final String logStreamName;
    private final List<NetworkInterface> networkInterfaces;

    private TaskContainerDetails(BuilderImpl builder) {
        this.command = builder.command;
        this.dependsOn = builder.dependsOn;
        this.environment = builder.environment;
        this.essential = builder.essential;
        this.firelensConfiguration = builder.firelensConfiguration;
        this.image = builder.image;
        this.linuxParameters = builder.linuxParameters;
        this.logConfiguration = builder.logConfiguration;
        this.mountPoints = builder.mountPoints;
        this.name = builder.name;
        this.privileged = builder.privileged;
        this.readonlyRootFilesystem = builder.readonlyRootFilesystem;
        this.repositoryCredentials = builder.repositoryCredentials;
        this.resourceRequirements = builder.resourceRequirements;
        this.secrets = builder.secrets;
        this.ulimits = builder.ulimits;
        this.user = builder.user;
        this.exitCode = builder.exitCode;
        this.reason = builder.reason;
        this.logStreamName = builder.logStreamName;
        this.networkInterfaces = builder.networkInterfaces;
    }

    public final boolean hasCommand() {
        return this.command != null && !(this.command instanceof SdkAutoConstructList);
    }

    public final List<String> command() {
        return this.command;
    }

    public final boolean hasDependsOn() {
        return this.dependsOn != null && !(this.dependsOn instanceof SdkAutoConstructList);
    }

    public final List<TaskContainerDependency> dependsOn() {
        return this.dependsOn;
    }

    public final boolean hasEnvironment() {
        return this.environment != null && !(this.environment instanceof SdkAutoConstructList);
    }

    public final List<KeyValuePair> environment() {
        return this.environment;
    }

    public final Boolean essential() {
        return this.essential;
    }

    public final FirelensConfiguration firelensConfiguration() {
        return this.firelensConfiguration;
    }

    public final String image() {
        return this.image;
    }

    public final LinuxParameters linuxParameters() {
        return this.linuxParameters;
    }

    public final LogConfiguration logConfiguration() {
        return this.logConfiguration;
    }

    public final boolean hasMountPoints() {
        return this.mountPoints != null && !(this.mountPoints instanceof SdkAutoConstructList);
    }

    public final List<MountPoint> mountPoints() {
        return this.mountPoints;
    }

    public final String name() {
        return this.name;
    }

    public final Boolean privileged() {
        return this.privileged;
    }

    public final Boolean readonlyRootFilesystem() {
        return this.readonlyRootFilesystem;
    }

    public final RepositoryCredentials repositoryCredentials() {
        return this.repositoryCredentials;
    }

    public final boolean hasResourceRequirements() {
        return this.resourceRequirements != null && !(this.resourceRequirements instanceof SdkAutoConstructList);
    }

    public final List<ResourceRequirement> resourceRequirements() {
        return this.resourceRequirements;
    }

    public final boolean hasSecrets() {
        return this.secrets != null && !(this.secrets instanceof SdkAutoConstructList);
    }

    public final List<Secret> secrets() {
        return this.secrets;
    }

    public final boolean hasUlimits() {
        return this.ulimits != null && !(this.ulimits instanceof SdkAutoConstructList);
    }

    public final List<Ulimit> ulimits() {
        return this.ulimits;
    }

    public final String user() {
        return this.user;
    }

    public final Integer exitCode() {
        return this.exitCode;
    }

    public final String reason() {
        return this.reason;
    }

    public final String logStreamName() {
        return this.logStreamName;
    }

    public final boolean hasNetworkInterfaces() {
        return this.networkInterfaces != null && !(this.networkInterfaces instanceof SdkAutoConstructList);
    }

    public final List<NetworkInterface> networkInterfaces() {
        return this.networkInterfaces;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommand() ? this.command() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDependsOn() ? this.dependsOn() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironment() ? this.environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.essential());
        hashCode = 31 * hashCode + Objects.hashCode(this.firelensConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.linuxParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMountPoints() ? this.mountPoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.privileged());
        hashCode = 31 * hashCode + Objects.hashCode(this.readonlyRootFilesystem());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceRequirements() ? this.resourceRequirements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecrets() ? this.secrets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUlimits() ? this.ulimits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        hashCode = 31 * hashCode + Objects.hashCode(this.exitCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        hashCode = 31 * hashCode + Objects.hashCode(this.logStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInterfaces() ? this.networkInterfaces() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskContainerDetails)) {
            return false;
        }
        TaskContainerDetails other = (TaskContainerDetails)obj;
        return this.hasCommand() == other.hasCommand() && Objects.equals(this.command(), other.command()) && this.hasDependsOn() == other.hasDependsOn() && Objects.equals(this.dependsOn(), other.dependsOn()) && this.hasEnvironment() == other.hasEnvironment() && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.essential(), other.essential()) && Objects.equals(this.firelensConfiguration(), other.firelensConfiguration()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.linuxParameters(), other.linuxParameters()) && Objects.equals(this.logConfiguration(), other.logConfiguration()) && this.hasMountPoints() == other.hasMountPoints() && Objects.equals(this.mountPoints(), other.mountPoints()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.privileged(), other.privileged()) && Objects.equals(this.readonlyRootFilesystem(), other.readonlyRootFilesystem()) && Objects.equals(this.repositoryCredentials(), other.repositoryCredentials()) && this.hasResourceRequirements() == other.hasResourceRequirements() && Objects.equals(this.resourceRequirements(), other.resourceRequirements()) && this.hasSecrets() == other.hasSecrets() && Objects.equals(this.secrets(), other.secrets()) && this.hasUlimits() == other.hasUlimits() && Objects.equals(this.ulimits(), other.ulimits()) && Objects.equals(this.user(), other.user()) && Objects.equals(this.exitCode(), other.exitCode()) && Objects.equals(this.reason(), other.reason()) && Objects.equals(this.logStreamName(), other.logStreamName()) && this.hasNetworkInterfaces() == other.hasNetworkInterfaces() && Objects.equals(this.networkInterfaces(), other.networkInterfaces());
    }

    public final String toString() {
        return ToString.builder((String)"TaskContainerDetails").add("Command", this.hasCommand() ? this.command() : null).add("DependsOn", this.hasDependsOn() ? this.dependsOn() : null).add("Environment", this.hasEnvironment() ? this.environment() : null).add("Essential", (Object)this.essential()).add("FirelensConfiguration", (Object)this.firelensConfiguration()).add("Image", (Object)this.image()).add("LinuxParameters", (Object)this.linuxParameters()).add("LogConfiguration", (Object)this.logConfiguration()).add("MountPoints", this.hasMountPoints() ? this.mountPoints() : null).add("Name", (Object)this.name()).add("Privileged", (Object)this.privileged()).add("ReadonlyRootFilesystem", (Object)this.readonlyRootFilesystem()).add("RepositoryCredentials", (Object)this.repositoryCredentials()).add("ResourceRequirements", this.hasResourceRequirements() ? this.resourceRequirements() : null).add("Secrets", this.hasSecrets() ? this.secrets() : null).add("Ulimits", this.hasUlimits() ? this.ulimits() : null).add("User", (Object)this.user()).add("ExitCode", (Object)this.exitCode()).add("Reason", (Object)this.reason()).add("LogStreamName", (Object)this.logStreamName()).add("NetworkInterfaces", this.hasNetworkInterfaces() ? this.networkInterfaces() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "command": {
                return Optional.ofNullable(clazz.cast(this.command()));
            }
            case "dependsOn": {
                return Optional.ofNullable(clazz.cast(this.dependsOn()));
            }
            case "environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "essential": {
                return Optional.ofNullable(clazz.cast(this.essential()));
            }
            case "firelensConfiguration": {
                return Optional.ofNullable(clazz.cast(this.firelensConfiguration()));
            }
            case "image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "linuxParameters": {
                return Optional.ofNullable(clazz.cast(this.linuxParameters()));
            }
            case "logConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logConfiguration()));
            }
            case "mountPoints": {
                return Optional.ofNullable(clazz.cast(this.mountPoints()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "privileged": {
                return Optional.ofNullable(clazz.cast(this.privileged()));
            }
            case "readonlyRootFilesystem": {
                return Optional.ofNullable(clazz.cast(this.readonlyRootFilesystem()));
            }
            case "repositoryCredentials": {
                return Optional.ofNullable(clazz.cast(this.repositoryCredentials()));
            }
            case "resourceRequirements": {
                return Optional.ofNullable(clazz.cast(this.resourceRequirements()));
            }
            case "secrets": {
                return Optional.ofNullable(clazz.cast(this.secrets()));
            }
            case "ulimits": {
                return Optional.ofNullable(clazz.cast(this.ulimits()));
            }
            case "user": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
            case "exitCode": {
                return Optional.ofNullable(clazz.cast(this.exitCode()));
            }
            case "reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
            case "logStreamName": {
                return Optional.ofNullable(clazz.cast(this.logStreamName()));
            }
            case "networkInterfaces": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaces()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("command", COMMAND_FIELD);
        map.put("dependsOn", DEPENDS_ON_FIELD);
        map.put("environment", ENVIRONMENT_FIELD);
        map.put("essential", ESSENTIAL_FIELD);
        map.put("firelensConfiguration", FIRELENS_CONFIGURATION_FIELD);
        map.put("image", IMAGE_FIELD);
        map.put("linuxParameters", LINUX_PARAMETERS_FIELD);
        map.put("logConfiguration", LOG_CONFIGURATION_FIELD);
        map.put("mountPoints", MOUNT_POINTS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("privileged", PRIVILEGED_FIELD);
        map.put("readonlyRootFilesystem", READONLY_ROOT_FILESYSTEM_FIELD);
        map.put("repositoryCredentials", REPOSITORY_CREDENTIALS_FIELD);
        map.put("resourceRequirements", RESOURCE_REQUIREMENTS_FIELD);
        map.put("secrets", SECRETS_FIELD);
        map.put("ulimits", ULIMITS_FIELD);
        map.put("user", USER_FIELD);
        map.put("exitCode", EXIT_CODE_FIELD);
        map.put("reason", REASON_FIELD);
        map.put("logStreamName", LOG_STREAM_NAME_FIELD);
        map.put("networkInterfaces", NETWORK_INTERFACES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaskContainerDetails, T> g) {
        return obj -> g.apply((TaskContainerDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> command = DefaultSdkAutoConstructList.getInstance();
        private List<TaskContainerDependency> dependsOn = DefaultSdkAutoConstructList.getInstance();
        private List<KeyValuePair> environment = DefaultSdkAutoConstructList.getInstance();
        private Boolean essential;
        private FirelensConfiguration firelensConfiguration;
        private String image;
        private LinuxParameters linuxParameters;
        private LogConfiguration logConfiguration;
        private List<MountPoint> mountPoints = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private Boolean privileged;
        private Boolean readonlyRootFilesystem;
        private RepositoryCredentials repositoryCredentials;
        private List<ResourceRequirement> resourceRequirements = DefaultSdkAutoConstructList.getInstance();
        private List<Secret> secrets = DefaultSdkAutoConstructList.getInstance();
        private List<Ulimit> ulimits = DefaultSdkAutoConstructList.getInstance();
        private String user;
        private Integer exitCode;
        private String reason;
        private String logStreamName;
        private List<NetworkInterface> networkInterfaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TaskContainerDetails model) {
            this.command(model.command);
            this.dependsOn(model.dependsOn);
            this.environment(model.environment);
            this.essential(model.essential);
            this.firelensConfiguration(model.firelensConfiguration);
            this.image(model.image);
            this.linuxParameters(model.linuxParameters);
            this.logConfiguration(model.logConfiguration);
            this.mountPoints(model.mountPoints);
            this.name(model.name);
            this.privileged(model.privileged);
            this.readonlyRootFilesystem(model.readonlyRootFilesystem);
            this.repositoryCredentials(model.repositoryCredentials);
            this.resourceRequirements(model.resourceRequirements);
            this.secrets(model.secrets);
            this.ulimits(model.ulimits);
            this.user(model.user);
            this.exitCode(model.exitCode);
            this.reason(model.reason);
            this.logStreamName(model.logStreamName);
            this.networkInterfaces(model.networkInterfaces);
        }

        public final Collection<String> getCommand() {
            if (this.command instanceof SdkAutoConstructList) {
                return null;
            }
            return this.command;
        }

        public final void setCommand(Collection<String> command) {
            this.command = StringListCopier.copy(command);
        }

        @Override
        public final Builder command(Collection<String> command) {
            this.command = StringListCopier.copy(command);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder command(String ... command) {
            this.command(Arrays.asList(command));
            return this;
        }

        public final List<TaskContainerDependency.Builder> getDependsOn() {
            List<TaskContainerDependency.Builder> result = TaskContainerDependencyListCopier.copyToBuilder(this.dependsOn);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDependsOn(Collection<TaskContainerDependency.BuilderImpl> dependsOn) {
            this.dependsOn = TaskContainerDependencyListCopier.copyFromBuilder(dependsOn);
        }

        @Override
        public final Builder dependsOn(Collection<TaskContainerDependency> dependsOn) {
            this.dependsOn = TaskContainerDependencyListCopier.copy(dependsOn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(TaskContainerDependency ... dependsOn) {
            this.dependsOn(Arrays.asList(dependsOn));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(Consumer<TaskContainerDependency.Builder> ... dependsOn) {
            this.dependsOn(Stream.of(dependsOn).map(c -> (TaskContainerDependency)((TaskContainerDependency.Builder)TaskContainerDependency.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<KeyValuePair.Builder> getEnvironment() {
            List<KeyValuePair.Builder> result = EnvironmentVariablesCopier.copyToBuilder(this.environment);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironment(Collection<KeyValuePair.BuilderImpl> environment) {
            this.environment = EnvironmentVariablesCopier.copyFromBuilder(environment);
        }

        @Override
        public final Builder environment(Collection<KeyValuePair> environment) {
            this.environment = EnvironmentVariablesCopier.copy(environment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(KeyValuePair ... environment) {
            this.environment(Arrays.asList(environment));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(Consumer<KeyValuePair.Builder> ... environment) {
            this.environment(Stream.of(environment).map(c -> (KeyValuePair)((KeyValuePair.Builder)KeyValuePair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEssential() {
            return this.essential;
        }

        public final void setEssential(Boolean essential) {
            this.essential = essential;
        }

        @Override
        public final Builder essential(Boolean essential) {
            this.essential = essential;
            return this;
        }

        public final FirelensConfiguration.Builder getFirelensConfiguration() {
            return this.firelensConfiguration != null ? this.firelensConfiguration.toBuilder() : null;
        }

        public final void setFirelensConfiguration(FirelensConfiguration.BuilderImpl firelensConfiguration) {
            this.firelensConfiguration = firelensConfiguration != null ? firelensConfiguration.build() : null;
        }

        @Override
        public final Builder firelensConfiguration(FirelensConfiguration firelensConfiguration) {
            this.firelensConfiguration = firelensConfiguration;
            return this;
        }

        public final String getImage() {
            return this.image;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final LinuxParameters.Builder getLinuxParameters() {
            return this.linuxParameters != null ? this.linuxParameters.toBuilder() : null;
        }

        public final void setLinuxParameters(LinuxParameters.BuilderImpl linuxParameters) {
            this.linuxParameters = linuxParameters != null ? linuxParameters.build() : null;
        }

        @Override
        public final Builder linuxParameters(LinuxParameters linuxParameters) {
            this.linuxParameters = linuxParameters;
            return this;
        }

        public final LogConfiguration.Builder getLogConfiguration() {
            return this.logConfiguration != null ? this.logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(LogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(LogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final List<MountPoint.Builder> getMountPoints() {
            List<MountPoint.Builder> result = MountPointsCopier.copyToBuilder(this.mountPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMountPoints(Collection<MountPoint.BuilderImpl> mountPoints) {
            this.mountPoints = MountPointsCopier.copyFromBuilder(mountPoints);
        }

        @Override
        public final Builder mountPoints(Collection<MountPoint> mountPoints) {
            this.mountPoints = MountPointsCopier.copy(mountPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountPoints(MountPoint ... mountPoints) {
            this.mountPoints(Arrays.asList(mountPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountPoints(Consumer<MountPoint.Builder> ... mountPoints) {
            this.mountPoints(Stream.of(mountPoints).map(c -> (MountPoint)((MountPoint.Builder)MountPoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getPrivileged() {
            return this.privileged;
        }

        public final void setPrivileged(Boolean privileged) {
            this.privileged = privileged;
        }

        @Override
        public final Builder privileged(Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public final Boolean getReadonlyRootFilesystem() {
            return this.readonlyRootFilesystem;
        }

        public final void setReadonlyRootFilesystem(Boolean readonlyRootFilesystem) {
            this.readonlyRootFilesystem = readonlyRootFilesystem;
        }

        @Override
        public final Builder readonlyRootFilesystem(Boolean readonlyRootFilesystem) {
            this.readonlyRootFilesystem = readonlyRootFilesystem;
            return this;
        }

        public final RepositoryCredentials.Builder getRepositoryCredentials() {
            return this.repositoryCredentials != null ? this.repositoryCredentials.toBuilder() : null;
        }

        public final void setRepositoryCredentials(RepositoryCredentials.BuilderImpl repositoryCredentials) {
            this.repositoryCredentials = repositoryCredentials != null ? repositoryCredentials.build() : null;
        }

        @Override
        public final Builder repositoryCredentials(RepositoryCredentials repositoryCredentials) {
            this.repositoryCredentials = repositoryCredentials;
            return this;
        }

        public final List<ResourceRequirement.Builder> getResourceRequirements() {
            List<ResourceRequirement.Builder> result = ResourceRequirementsCopier.copyToBuilder(this.resourceRequirements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceRequirements(Collection<ResourceRequirement.BuilderImpl> resourceRequirements) {
            this.resourceRequirements = ResourceRequirementsCopier.copyFromBuilder(resourceRequirements);
        }

        @Override
        public final Builder resourceRequirements(Collection<ResourceRequirement> resourceRequirements) {
            this.resourceRequirements = ResourceRequirementsCopier.copy(resourceRequirements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRequirements(ResourceRequirement ... resourceRequirements) {
            this.resourceRequirements(Arrays.asList(resourceRequirements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRequirements(Consumer<ResourceRequirement.Builder> ... resourceRequirements) {
            this.resourceRequirements(Stream.of(resourceRequirements).map(c -> (ResourceRequirement)((ResourceRequirement.Builder)ResourceRequirement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Secret.Builder> getSecrets() {
            List<Secret.Builder> result = SecretListCopier.copyToBuilder(this.secrets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecrets(Collection<Secret.BuilderImpl> secrets) {
            this.secrets = SecretListCopier.copyFromBuilder(secrets);
        }

        @Override
        public final Builder secrets(Collection<Secret> secrets) {
            this.secrets = SecretListCopier.copy(secrets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secrets(Secret ... secrets) {
            this.secrets(Arrays.asList(secrets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secrets(Consumer<Secret.Builder> ... secrets) {
            this.secrets(Stream.of(secrets).map(c -> (Secret)((Secret.Builder)Secret.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Ulimit.Builder> getUlimits() {
            List<Ulimit.Builder> result = UlimitsCopier.copyToBuilder(this.ulimits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUlimits(Collection<Ulimit.BuilderImpl> ulimits) {
            this.ulimits = UlimitsCopier.copyFromBuilder(ulimits);
        }

        @Override
        public final Builder ulimits(Collection<Ulimit> ulimits) {
            this.ulimits = UlimitsCopier.copy(ulimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ulimits(Ulimit ... ulimits) {
            this.ulimits(Arrays.asList(ulimits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ulimits(Consumer<Ulimit.Builder> ... ulimits) {
            this.ulimits(Stream.of(ulimits).map(c -> (Ulimit)((Ulimit.Builder)Ulimit.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUser() {
            return this.user;
        }

        public final void setUser(String user) {
            this.user = user;
        }

        @Override
        public final Builder user(String user) {
            this.user = user;
            return this;
        }

        public final Integer getExitCode() {
            return this.exitCode;
        }

        public final void setExitCode(Integer exitCode) {
            this.exitCode = exitCode;
        }

        @Override
        public final Builder exitCode(Integer exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final String getLogStreamName() {
            return this.logStreamName;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final List<NetworkInterface.Builder> getNetworkInterfaces() {
            List<NetworkInterface.Builder> result = NetworkInterfaceListCopier.copyToBuilder(this.networkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInterfaces(Collection<NetworkInterface.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = NetworkInterfaceListCopier.copyFromBuilder(networkInterfaces);
        }

        @Override
        public final Builder networkInterfaces(Collection<NetworkInterface> networkInterfaces) {
            this.networkInterfaces = NetworkInterfaceListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(NetworkInterface ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<NetworkInterface.Builder> ... networkInterfaces) {
            this.networkInterfaces(Stream.of(networkInterfaces).map(c -> (NetworkInterface)((NetworkInterface.Builder)NetworkInterface.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TaskContainerDetails build() {
            return new TaskContainerDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskContainerDetails> {
        public Builder command(Collection<String> var1);

        public Builder command(String ... var1);

        public Builder dependsOn(Collection<TaskContainerDependency> var1);

        public Builder dependsOn(TaskContainerDependency ... var1);

        public Builder dependsOn(Consumer<TaskContainerDependency.Builder> ... var1);

        public Builder environment(Collection<KeyValuePair> var1);

        public Builder environment(KeyValuePair ... var1);

        public Builder environment(Consumer<KeyValuePair.Builder> ... var1);

        public Builder essential(Boolean var1);

        public Builder firelensConfiguration(FirelensConfiguration var1);

        default public Builder firelensConfiguration(Consumer<FirelensConfiguration.Builder> firelensConfiguration) {
            return this.firelensConfiguration((FirelensConfiguration)((FirelensConfiguration.Builder)FirelensConfiguration.builder().applyMutation(firelensConfiguration)).build());
        }

        public Builder image(String var1);

        public Builder linuxParameters(LinuxParameters var1);

        default public Builder linuxParameters(Consumer<LinuxParameters.Builder> linuxParameters) {
            return this.linuxParameters((LinuxParameters)((LinuxParameters.Builder)LinuxParameters.builder().applyMutation(linuxParameters)).build());
        }

        public Builder logConfiguration(LogConfiguration var1);

        default public Builder logConfiguration(Consumer<LogConfiguration.Builder> logConfiguration) {
            return this.logConfiguration((LogConfiguration)((LogConfiguration.Builder)LogConfiguration.builder().applyMutation(logConfiguration)).build());
        }

        public Builder mountPoints(Collection<MountPoint> var1);

        public Builder mountPoints(MountPoint ... var1);

        public Builder mountPoints(Consumer<MountPoint.Builder> ... var1);

        public Builder name(String var1);

        public Builder privileged(Boolean var1);

        public Builder readonlyRootFilesystem(Boolean var1);

        public Builder repositoryCredentials(RepositoryCredentials var1);

        default public Builder repositoryCredentials(Consumer<RepositoryCredentials.Builder> repositoryCredentials) {
            return this.repositoryCredentials((RepositoryCredentials)((RepositoryCredentials.Builder)RepositoryCredentials.builder().applyMutation(repositoryCredentials)).build());
        }

        public Builder resourceRequirements(Collection<ResourceRequirement> var1);

        public Builder resourceRequirements(ResourceRequirement ... var1);

        public Builder resourceRequirements(Consumer<ResourceRequirement.Builder> ... var1);

        public Builder secrets(Collection<Secret> var1);

        public Builder secrets(Secret ... var1);

        public Builder secrets(Consumer<Secret.Builder> ... var1);

        public Builder ulimits(Collection<Ulimit> var1);

        public Builder ulimits(Ulimit ... var1);

        public Builder ulimits(Consumer<Ulimit.Builder> ... var1);

        public Builder user(String var1);

        public Builder exitCode(Integer var1);

        public Builder reason(String var1);

        public Builder logStreamName(String var1);

        public Builder networkInterfaces(Collection<NetworkInterface> var1);

        public Builder networkInterfaces(NetworkInterface ... var1);

        public Builder networkInterfaces(Consumer<NetworkInterface.Builder> ... var1);
    }
}

