/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A legal hold is an administrative tool that helps prevent backups from being deleted while under a hold. While the
 * hold is in place, backups under a hold cannot be deleted and lifecycle policies that would alter the backup status
 * (such as transition to cold storage) are delayed until the legal hold is removed. A backup can have more than one
 * legal hold. Legal holds are applied to one or more backups (also known as recovery points). These backups can be
 * filtered by resource types and by resource IDs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LegalHold implements SdkPojo, Serializable, ToCopyableBuilder<LegalHold.Builder, LegalHold> {
    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(LegalHold::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(LegalHold::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(LegalHold::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> LEGAL_HOLD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LegalHoldId").getter(getter(LegalHold::legalHoldId)).setter(setter(Builder::legalHoldId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LegalHoldId").build()).build();

    private static final SdkField<String> LEGAL_HOLD_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LegalHoldArn").getter(getter(LegalHold::legalHoldArn)).setter(setter(Builder::legalHoldArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LegalHoldArn").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(LegalHold::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<Instant> CANCELLATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CancellationDate").getter(getter(LegalHold::cancellationDate)).setter(setter(Builder::cancellationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CancellationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, STATUS_FIELD,
            DESCRIPTION_FIELD, LEGAL_HOLD_ID_FIELD, LEGAL_HOLD_ARN_FIELD, CREATION_DATE_FIELD, CANCELLATION_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String title;

    private final String status;

    private final String description;

    private final String legalHoldId;

    private final String legalHoldArn;

    private final Instant creationDate;

    private final Instant cancellationDate;

    private LegalHold(BuilderImpl builder) {
        this.title = builder.title;
        this.status = builder.status;
        this.description = builder.description;
        this.legalHoldId = builder.legalHoldId;
        this.legalHoldArn = builder.legalHoldArn;
        this.creationDate = builder.creationDate;
        this.cancellationDate = builder.cancellationDate;
    }

    /**
     * <p>
     * This is the title of a legal hold.
     * </p>
     * 
     * @return This is the title of a legal hold.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * This is the status of the legal hold. Statuses can be <code>ACTIVE</code>, <code>CREATING</code>,
     * <code>CANCELED</code>, and <code>CANCELING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LegalHoldStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return This is the status of the legal hold. Statuses can be <code>ACTIVE</code>, <code>CREATING</code>,
     *         <code>CANCELED</code>, and <code>CANCELING</code>.
     * @see LegalHoldStatus
     */
    public final LegalHoldStatus status() {
        return LegalHoldStatus.fromValue(status);
    }

    /**
     * <p>
     * This is the status of the legal hold. Statuses can be <code>ACTIVE</code>, <code>CREATING</code>,
     * <code>CANCELED</code>, and <code>CANCELING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LegalHoldStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return This is the status of the legal hold. Statuses can be <code>ACTIVE</code>, <code>CREATING</code>,
     *         <code>CANCELED</code>, and <code>CANCELING</code>.
     * @see LegalHoldStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * This is the description of a legal hold.
     * </p>
     * 
     * @return This is the description of a legal hold.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * ID of specific legal hold on one or more recovery points.
     * </p>
     * 
     * @return ID of specific legal hold on one or more recovery points.
     */
    public final String legalHoldId() {
        return legalHoldId;
    }

    /**
     * <p>
     * This is an Amazon Resource Number (ARN) that uniquely identifies the legal hold; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     * </p>
     * 
     * @return This is an Amazon Resource Number (ARN) that uniquely identifies the legal hold; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     */
    public final String legalHoldArn() {
        return legalHoldArn;
    }

    /**
     * <p>
     * This is the time in number format when legal hold was created.
     * </p>
     * 
     * @return This is the time in number format when legal hold was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * This is the time in number format when legal hold was cancelled.
     * </p>
     * 
     * @return This is the time in number format when legal hold was cancelled.
     */
    public final Instant cancellationDate() {
        return cancellationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(legalHoldId());
        hashCode = 31 * hashCode + Objects.hashCode(legalHoldArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(cancellationDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LegalHold)) {
            return false;
        }
        LegalHold other = (LegalHold) obj;
        return Objects.equals(title(), other.title()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(legalHoldId(), other.legalHoldId())
                && Objects.equals(legalHoldArn(), other.legalHoldArn()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(cancellationDate(), other.cancellationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LegalHold").add("Title", title()).add("Status", statusAsString())
                .add("Description", description()).add("LegalHoldId", legalHoldId()).add("LegalHoldArn", legalHoldArn())
                .add("CreationDate", creationDate()).add("CancellationDate", cancellationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LegalHoldId":
            return Optional.ofNullable(clazz.cast(legalHoldId()));
        case "LegalHoldArn":
            return Optional.ofNullable(clazz.cast(legalHoldArn()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "CancellationDate":
            return Optional.ofNullable(clazz.cast(cancellationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LegalHold, T> g) {
        return obj -> g.apply((LegalHold) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LegalHold> {
        /**
         * <p>
         * This is the title of a legal hold.
         * </p>
         * 
         * @param title
         *        This is the title of a legal hold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * This is the status of the legal hold. Statuses can be <code>ACTIVE</code>, <code>CREATING</code>,
         * <code>CANCELED</code>, and <code>CANCELING</code>.
         * </p>
         * 
         * @param status
         *        This is the status of the legal hold. Statuses can be <code>ACTIVE</code>, <code>CREATING</code>,
         *        <code>CANCELED</code>, and <code>CANCELING</code>.
         * @see LegalHoldStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LegalHoldStatus
         */
        Builder status(String status);

        /**
         * <p>
         * This is the status of the legal hold. Statuses can be <code>ACTIVE</code>, <code>CREATING</code>,
         * <code>CANCELED</code>, and <code>CANCELING</code>.
         * </p>
         * 
         * @param status
         *        This is the status of the legal hold. Statuses can be <code>ACTIVE</code>, <code>CREATING</code>,
         *        <code>CANCELED</code>, and <code>CANCELING</code>.
         * @see LegalHoldStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LegalHoldStatus
         */
        Builder status(LegalHoldStatus status);

        /**
         * <p>
         * This is the description of a legal hold.
         * </p>
         * 
         * @param description
         *        This is the description of a legal hold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * ID of specific legal hold on one or more recovery points.
         * </p>
         * 
         * @param legalHoldId
         *        ID of specific legal hold on one or more recovery points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legalHoldId(String legalHoldId);

        /**
         * <p>
         * This is an Amazon Resource Number (ARN) that uniquely identifies the legal hold; for example,
         * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
         * </p>
         * 
         * @param legalHoldArn
         *        This is an Amazon Resource Number (ARN) that uniquely identifies the legal hold; for example,
         *        <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legalHoldArn(String legalHoldArn);

        /**
         * <p>
         * This is the time in number format when legal hold was created.
         * </p>
         * 
         * @param creationDate
         *        This is the time in number format when legal hold was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * This is the time in number format when legal hold was cancelled.
         * </p>
         * 
         * @param cancellationDate
         *        This is the time in number format when legal hold was cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancellationDate(Instant cancellationDate);
    }

    static final class BuilderImpl implements Builder {
        private String title;

        private String status;

        private String description;

        private String legalHoldId;

        private String legalHoldArn;

        private Instant creationDate;

        private Instant cancellationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(LegalHold model) {
            title(model.title);
            status(model.status);
            description(model.description);
            legalHoldId(model.legalHoldId);
            legalHoldArn(model.legalHoldArn);
            creationDate(model.creationDate);
            cancellationDate(model.cancellationDate);
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LegalHoldStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getLegalHoldId() {
            return legalHoldId;
        }

        public final void setLegalHoldId(String legalHoldId) {
            this.legalHoldId = legalHoldId;
        }

        @Override
        public final Builder legalHoldId(String legalHoldId) {
            this.legalHoldId = legalHoldId;
            return this;
        }

        public final String getLegalHoldArn() {
            return legalHoldArn;
        }

        public final void setLegalHoldArn(String legalHoldArn) {
            this.legalHoldArn = legalHoldArn;
        }

        @Override
        public final Builder legalHoldArn(String legalHoldArn) {
            this.legalHoldArn = legalHoldArn;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getCancellationDate() {
            return cancellationDate;
        }

        public final void setCancellationDate(Instant cancellationDate) {
            this.cancellationDate = cancellationDate;
        }

        @Override
        public final Builder cancellationDate(Instant cancellationDate) {
            this.cancellationDate = cancellationDate;
            return this;
        }

        @Override
        public LegalHold build() {
            return new LegalHold(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
