/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.FrameworkControl;
import software.amazon.awssdk.services.backup.model.FrameworkControlsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFrameworkResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, DescribeFrameworkResponse> {
    private static final SdkField<String> FRAMEWORK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FrameworkName").getter(DescribeFrameworkResponse.getter(DescribeFrameworkResponse::frameworkName)).setter(DescribeFrameworkResponse.setter(Builder::frameworkName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkName").build()}).build();
    private static final SdkField<String> FRAMEWORK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FrameworkArn").getter(DescribeFrameworkResponse.getter(DescribeFrameworkResponse::frameworkArn)).setter(DescribeFrameworkResponse.setter(Builder::frameworkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkArn").build()}).build();
    private static final SdkField<String> FRAMEWORK_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FrameworkDescription").getter(DescribeFrameworkResponse.getter(DescribeFrameworkResponse::frameworkDescription)).setter(DescribeFrameworkResponse.setter(Builder::frameworkDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkDescription").build()}).build();
    private static final SdkField<List<FrameworkControl>> FRAMEWORK_CONTROLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FrameworkControls").getter(DescribeFrameworkResponse.getter(DescribeFrameworkResponse::frameworkControls)).setter(DescribeFrameworkResponse.setter(Builder::frameworkControls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkControls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FrameworkControl::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeFrameworkResponse.getter(DescribeFrameworkResponse::creationTime)).setter(DescribeFrameworkResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentStatus").getter(DescribeFrameworkResponse.getter(DescribeFrameworkResponse::deploymentStatus)).setter(DescribeFrameworkResponse.setter(Builder::deploymentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStatus").build()}).build();
    private static final SdkField<String> FRAMEWORK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FrameworkStatus").getter(DescribeFrameworkResponse.getter(DescribeFrameworkResponse::frameworkStatus)).setter(DescribeFrameworkResponse.setter(Builder::frameworkStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkStatus").build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdempotencyToken").getter(DescribeFrameworkResponse.getter(DescribeFrameworkResponse::idempotencyToken)).setter(DescribeFrameworkResponse.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAMEWORK_NAME_FIELD, FRAMEWORK_ARN_FIELD, FRAMEWORK_DESCRIPTION_FIELD, FRAMEWORK_CONTROLS_FIELD, CREATION_TIME_FIELD, DEPLOYMENT_STATUS_FIELD, FRAMEWORK_STATUS_FIELD, IDEMPOTENCY_TOKEN_FIELD));
    private final String frameworkName;
    private final String frameworkArn;
    private final String frameworkDescription;
    private final List<FrameworkControl> frameworkControls;
    private final Instant creationTime;
    private final String deploymentStatus;
    private final String frameworkStatus;
    private final String idempotencyToken;

    private DescribeFrameworkResponse(BuilderImpl builder) {
        super(builder);
        this.frameworkName = builder.frameworkName;
        this.frameworkArn = builder.frameworkArn;
        this.frameworkDescription = builder.frameworkDescription;
        this.frameworkControls = builder.frameworkControls;
        this.creationTime = builder.creationTime;
        this.deploymentStatus = builder.deploymentStatus;
        this.frameworkStatus = builder.frameworkStatus;
        this.idempotencyToken = builder.idempotencyToken;
    }

    public final String frameworkName() {
        return this.frameworkName;
    }

    public final String frameworkArn() {
        return this.frameworkArn;
    }

    public final String frameworkDescription() {
        return this.frameworkDescription;
    }

    public final boolean hasFrameworkControls() {
        return this.frameworkControls != null && !(this.frameworkControls instanceof SdkAutoConstructList);
    }

    public final List<FrameworkControl> frameworkControls() {
        return this.frameworkControls;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String deploymentStatus() {
        return this.deploymentStatus;
    }

    public final String frameworkStatus() {
        return this.frameworkStatus;
    }

    public final String idempotencyToken() {
        return this.idempotencyToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkName());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFrameworkControls() ? this.frameworkControls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFrameworkResponse)) {
            return false;
        }
        DescribeFrameworkResponse other = (DescribeFrameworkResponse)((Object)obj);
        return Objects.equals(this.frameworkName(), other.frameworkName()) && Objects.equals(this.frameworkArn(), other.frameworkArn()) && Objects.equals(this.frameworkDescription(), other.frameworkDescription()) && this.hasFrameworkControls() == other.hasFrameworkControls() && Objects.equals(this.frameworkControls(), other.frameworkControls()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.deploymentStatus(), other.deploymentStatus()) && Objects.equals(this.frameworkStatus(), other.frameworkStatus()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFrameworkResponse").add("FrameworkName", (Object)this.frameworkName()).add("FrameworkArn", (Object)this.frameworkArn()).add("FrameworkDescription", (Object)this.frameworkDescription()).add("FrameworkControls", this.hasFrameworkControls() ? this.frameworkControls() : null).add("CreationTime", (Object)this.creationTime()).add("DeploymentStatus", (Object)this.deploymentStatus()).add("FrameworkStatus", (Object)this.frameworkStatus()).add("IdempotencyToken", (Object)this.idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FrameworkName": {
                return Optional.ofNullable(clazz.cast(this.frameworkName()));
            }
            case "FrameworkArn": {
                return Optional.ofNullable(clazz.cast(this.frameworkArn()));
            }
            case "FrameworkDescription": {
                return Optional.ofNullable(clazz.cast(this.frameworkDescription()));
            }
            case "FrameworkControls": {
                return Optional.ofNullable(clazz.cast(this.frameworkControls()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "DeploymentStatus": {
                return Optional.ofNullable(clazz.cast(this.deploymentStatus()));
            }
            case "FrameworkStatus": {
                return Optional.ofNullable(clazz.cast(this.frameworkStatus()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFrameworkResponse, T> g) {
        return obj -> g.apply((DescribeFrameworkResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String frameworkName;
        private String frameworkArn;
        private String frameworkDescription;
        private List<FrameworkControl> frameworkControls = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTime;
        private String deploymentStatus;
        private String frameworkStatus;
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFrameworkResponse model) {
            super(model);
            this.frameworkName(model.frameworkName);
            this.frameworkArn(model.frameworkArn);
            this.frameworkDescription(model.frameworkDescription);
            this.frameworkControls(model.frameworkControls);
            this.creationTime(model.creationTime);
            this.deploymentStatus(model.deploymentStatus);
            this.frameworkStatus(model.frameworkStatus);
            this.idempotencyToken(model.idempotencyToken);
        }

        public final String getFrameworkName() {
            return this.frameworkName;
        }

        public final void setFrameworkName(String frameworkName) {
            this.frameworkName = frameworkName;
        }

        @Override
        public final Builder frameworkName(String frameworkName) {
            this.frameworkName = frameworkName;
            return this;
        }

        public final String getFrameworkArn() {
            return this.frameworkArn;
        }

        public final void setFrameworkArn(String frameworkArn) {
            this.frameworkArn = frameworkArn;
        }

        @Override
        public final Builder frameworkArn(String frameworkArn) {
            this.frameworkArn = frameworkArn;
            return this;
        }

        public final String getFrameworkDescription() {
            return this.frameworkDescription;
        }

        public final void setFrameworkDescription(String frameworkDescription) {
            this.frameworkDescription = frameworkDescription;
        }

        @Override
        public final Builder frameworkDescription(String frameworkDescription) {
            this.frameworkDescription = frameworkDescription;
            return this;
        }

        public final List<FrameworkControl.Builder> getFrameworkControls() {
            List<FrameworkControl.Builder> result = FrameworkControlsCopier.copyToBuilder(this.frameworkControls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFrameworkControls(Collection<FrameworkControl.BuilderImpl> frameworkControls) {
            this.frameworkControls = FrameworkControlsCopier.copyFromBuilder(frameworkControls);
        }

        @Override
        public final Builder frameworkControls(Collection<FrameworkControl> frameworkControls) {
            this.frameworkControls = FrameworkControlsCopier.copy(frameworkControls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder frameworkControls(FrameworkControl ... frameworkControls) {
            this.frameworkControls(Arrays.asList(frameworkControls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder frameworkControls(Consumer<FrameworkControl.Builder> ... frameworkControls) {
            this.frameworkControls(Stream.of(frameworkControls).map(c -> (FrameworkControl)((FrameworkControl.Builder)FrameworkControl.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDeploymentStatus() {
            return this.deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        public final String getFrameworkStatus() {
            return this.frameworkStatus;
        }

        public final void setFrameworkStatus(String frameworkStatus) {
            this.frameworkStatus = frameworkStatus;
        }

        @Override
        public final Builder frameworkStatus(String frameworkStatus) {
            this.frameworkStatus = frameworkStatus;
            return this;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        @Override
        public DescribeFrameworkResponse build() {
            return new DescribeFrameworkResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFrameworkResponse> {
        public Builder frameworkName(String var1);

        public Builder frameworkArn(String var1);

        public Builder frameworkDescription(String var1);

        public Builder frameworkControls(Collection<FrameworkControl> var1);

        public Builder frameworkControls(FrameworkControl ... var1);

        public Builder frameworkControls(Consumer<FrameworkControl.Builder> ... var1);

        public Builder creationTime(Instant var1);

        public Builder deploymentStatus(String var1);

        public Builder frameworkStatus(String var1);

        public Builder idempotencyToken(String var1);
    }
}

