/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.autoscaling.AutoScalingAsyncClient;
import software.amazon.awssdk.services.autoscaling.internal.UserAgentUtils;
import software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribePoliciesResponse;
import software.amazon.awssdk.services.autoscaling.model.ScalingPolicy;

public class DescribePoliciesPublisher
implements SdkPublisher<DescribePoliciesResponse> {
    private final AutoScalingAsyncClient client;
    private final DescribePoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribePoliciesPublisher(AutoScalingAsyncClient client, DescribePoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribePoliciesPublisher(AutoScalingAsyncClient client, DescribePoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribePoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribePoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ScalingPolicy> scalingPolicies() {
        Function<DescribePoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.scalingPolicies() != null) {
                return response.scalingPolicies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribePoliciesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribePoliciesResponseFetcher
    implements AsyncPageFetcher<DescribePoliciesResponse> {
        private DescribePoliciesResponseFetcher() {
        }

        public boolean hasNextPage(DescribePoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribePoliciesResponse> nextPage(DescribePoliciesResponse previousPage) {
            if (previousPage == null) {
                return DescribePoliciesPublisher.this.client.describePolicies(DescribePoliciesPublisher.this.firstRequest);
            }
            return DescribePoliciesPublisher.this.client.describePolicies((DescribePoliciesRequest)((Object)DescribePoliciesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

