/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InstanceRefreshStatus {
    PENDING("Pending"),
    IN_PROGRESS("InProgress"),
    SUCCESSFUL("Successful"),
    FAILED("Failed"),
    CANCELLING("Cancelling"),
    CANCELLED("Cancelled"),
    ROLLBACK_IN_PROGRESS("RollbackInProgress"),
    ROLLBACK_FAILED("RollbackFailed"),
    ROLLBACK_SUCCESSFUL("RollbackSuccessful"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InstanceRefreshStatus> VALUE_MAP;
    private final String value;

    private InstanceRefreshStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceRefreshStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceRefreshStatus> knownValues() {
        EnumSet<InstanceRefreshStatus> knownValues = EnumSet.allOf(InstanceRefreshStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InstanceRefreshStatus.class, InstanceRefreshStatus::toString);
    }
}

