/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.auditmanager.AuditManagerClient;
import software.amazon.awssdk.services.auditmanager.model.ListControlsRequest;
import software.amazon.awssdk.services.auditmanager.model.ListControlsResponse;

public class ListControlsIterable
implements SdkIterable<ListControlsResponse> {
    private final AuditManagerClient client;
    private final ListControlsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListControlsIterable(AuditManagerClient client, ListControlsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListControlsResponseFetcher();
    }

    public Iterator<ListControlsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListControlsResponseFetcher
    implements SyncPageFetcher<ListControlsResponse> {
        private ListControlsResponseFetcher() {
        }

        public boolean hasNextPage(ListControlsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListControlsResponse nextPage(ListControlsResponse previousPage) {
            if (previousPage == null) {
                return ListControlsIterable.this.client.listControls(ListControlsIterable.this.firstRequest);
            }
            return ListControlsIterable.this.client.listControls((ListControlsRequest)((Object)ListControlsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

