/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.auditmanager.AuditManagerAsyncClient;
import software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainRequest;
import software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainResponse;

public class ListControlInsightsByControlDomainPublisher
implements SdkPublisher<ListControlInsightsByControlDomainResponse> {
    private final AuditManagerAsyncClient client;
    private final ListControlInsightsByControlDomainRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListControlInsightsByControlDomainPublisher(AuditManagerAsyncClient client, ListControlInsightsByControlDomainRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListControlInsightsByControlDomainPublisher(AuditManagerAsyncClient client, ListControlInsightsByControlDomainRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListControlInsightsByControlDomainResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListControlInsightsByControlDomainResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListControlInsightsByControlDomainResponseFetcher
    implements AsyncPageFetcher<ListControlInsightsByControlDomainResponse> {
        private ListControlInsightsByControlDomainResponseFetcher() {
        }

        public boolean hasNextPage(ListControlInsightsByControlDomainResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListControlInsightsByControlDomainResponse> nextPage(ListControlInsightsByControlDomainResponse previousPage) {
            if (previousPage == null) {
                return ListControlInsightsByControlDomainPublisher.this.client.listControlInsightsByControlDomain(ListControlInsightsByControlDomainPublisher.this.firstRequest);
            }
            return ListControlInsightsByControlDomainPublisher.this.client.listControlInsightsByControlDomain((ListControlInsightsByControlDomainRequest)((Object)ListControlInsightsByControlDomainPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

