/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.auditmanager.AuditManagerAsyncClient;
import software.amazon.awssdk.services.auditmanager.model.ListControlsRequest;
import software.amazon.awssdk.services.auditmanager.model.ListControlsResponse;

public class ListControlsPublisher
implements SdkPublisher<ListControlsResponse> {
    private final AuditManagerAsyncClient client;
    private final ListControlsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListControlsPublisher(AuditManagerAsyncClient client, ListControlsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListControlsPublisher(AuditManagerAsyncClient client, ListControlsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListControlsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListControlsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListControlsResponseFetcher
    implements AsyncPageFetcher<ListControlsResponse> {
        private ListControlsResponseFetcher() {
        }

        public boolean hasNextPage(ListControlsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListControlsResponse> nextPage(ListControlsResponse previousPage) {
            if (previousPage == null) {
                return ListControlsPublisher.this.client.listControls(ListControlsPublisher.this.firstRequest);
            }
            return ListControlsPublisher.this.client.listControls((ListControlsRequest)((Object)ListControlsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

